/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.level.structure;

import com.mojang.serialization.Codec;
import com.ninni.spawn.registry.SpawnStructureProcessors;
import com.ninni.spawn.server.block.BigSeaPickleBlock;
import com.ninni.spawn.server.block.state.properties.BigSeaPickleType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class OctopolisProcessor
extends StructureProcessor {
    private static final int SEA_LEVEL = 63;
    public static final Codec<OctopolisProcessor> CODEC = Codec.unit(OctopolisProcessor::new);

    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos pos, BlockPos relativePos, StructureTemplate.StructureBlockInfo original, StructureTemplate.StructureBlockInfo current, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        BlockState state = current.f_74676_();
        if (state.m_60734_() instanceof BigSeaPickleBlock) {
            boolean tip = BigSeaPickleBlock.shouldTipBeTrue(current.f_74675_().m_123342_() < 63, state.m_61143_(BigSeaPickleBlock.TYPE) == BigSeaPickleType.SINGLE, level, current.f_74675_());
            return new StructureTemplate.StructureBlockInfo(current.f_74675_(), (BlockState)((BlockState)state.m_61124_((Property)BigSeaPickleBlock.TIP, (Comparable)Boolean.valueOf(tip))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(current.f_74675_().m_123342_() < 63)), current.f_74677_());
        }
        if (level.m_204166_(pos).m_203565_(Biomes.f_48166_) && current.f_74675_().m_123342_() < 63) {
            ResourceLocation location = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_());
            BlockState aliveState = ((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(location.m_135827_(), location.m_135815_().replace("dead_", "")))).m_49966_();
            if (location.m_135815_().contains("coral") && location.m_135815_().startsWith("dead_") && !aliveState.m_60795_()) {
                for (Property property : state.m_61147_()) {
                    if (!aliveState.m_61138_(property) || !state.m_61138_(property)) continue;
                    if (!property.equals((Object)BlockStateProperties.f_61362_)) {
                        aliveState = OctopolisProcessor.copyProperty(aliveState, state, property);
                        continue;
                    }
                    aliveState = (BlockState)aliveState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(current.f_74675_().m_123342_() < 63));
                }
                return new StructureTemplate.StructureBlockInfo(current.f_74675_(), aliveState, current.f_74677_());
            }
        }
        if (state.m_60795_() && current.f_74675_().m_123342_() < 63) {
            return new StructureTemplate.StructureBlockInfo(current.f_74675_(), Blocks.f_49990_.m_49966_(), current.f_74677_());
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61362_) && current.f_74675_().m_123342_() < 63) {
            return new StructureTemplate.StructureBlockInfo(current.f_74675_(), (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)), current.f_74677_());
        }
        return current;
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState to, BlockState from, Property<T> property) {
        return (BlockState)to.m_61124_(property, from.m_61143_(property));
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)SpawnStructureProcessors.OCTOPOLIS_PROCESSOR.get();
    }
}

