/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client;

import com.ninni.spawn.client.inventory.OctoductScreen;
import com.ninni.spawn.client.inventory.PigmentShifterScreen;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnMenuTypes;
import com.ninni.spawn.registry.SpawnTags;
import com.ninni.spawn.server.CommonProxy;
import com.ninni.spawn.server.entity.Clam;
import com.ninni.spawn.server.entity.variant.ClamVariant;
import java.util.Comparator;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ClientProxy
extends CommonProxy {
    @Override
    public void clientSetup() {
        MenuScreens.m_96206_((MenuType)((MenuType)SpawnMenuTypes.PIGMENT_SHIFTER.get()), PigmentShifterScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)SpawnMenuTypes.OCTODUCT.get()), OctoductScreen::new);
        ClientProxy.registerItemModelPredicates();
    }

    private static void registerItemModelPredicates() {
        ItemProperties.register((Item)((Item)SpawnItems.BABY_SUNFISH_BUCKET.get()), (ResourceLocation)new ResourceLocation("age"), (itemStack, clientLevel, livingEntity, i) -> {
            CompoundTag compoundTag = itemStack.m_41783_();
            if (compoundTag != null && compoundTag.m_128425_("Age", 3)) {
                int a = compoundTag.m_128451_("Age");
                if (a < -24000) {
                    return 0.0f;
                }
                return 1.0f;
            }
            return 0.0f;
        });
        ItemProperties.register((Item)((Item)SpawnItems.SUSPICIOUS_STICK.get()), (ResourceLocation)new ResourceLocation("age"), (itemStack, clientLevel, livingEntity, i) -> {
            CompoundTag compoundTag = itemStack.m_41783_();
            if (compoundTag != null && compoundTag.m_128425_("Age", 3)) {
                int a = compoundTag.m_128451_("Age");
                if (a < 0) {
                    return 1.0f;
                }
                return 0.0f;
            }
            return 0.0f;
        });
        ItemProperties.register((Item)((Item)SpawnItems.CASTING_NET.get()), (ResourceLocation)new ResourceLocation("full"), (itemStack, clientLevel, livingEntity, i) -> itemStack.m_41783_() != null && itemStack.m_41783_().m_128425_("CapturedMobs", 9) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)SpawnItems.CLAM.get()), (ResourceLocation)new ResourceLocation("variant"), (itemStack, clientLevel, livingEntity, i) -> {
            CompoundTag compoundTag = itemStack.m_41783_();
            if (compoundTag != null && compoundTag.m_128425_("ClamVariant", 3)) {
                int a = compoundTag.m_128451_("ClamVariant");
                ClamVariant.Base base = Clam.getBaseColor(a).base();
                if (base == ClamVariant.Base.WEDGE_SHELL) {
                    return 0.25f;
                }
                if (base == ClamVariant.Base.SCALLOP) {
                    return 0.5f;
                }
                if (base == ClamVariant.Base.GIANT_CLAM) {
                    return 0.75f;
                }
            }
            return 0.0f;
        });
        ItemProperties.register((Item)((Item)SpawnItems.CAPTURED_OCTOPUS.get()), (ResourceLocation)new ResourceLocation("item"), (stack, level, entity, seed) -> {
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128441_("Item")) {
                ItemStack inner = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
                List<Item> taggedItems = StreamSupport.stream(BuiltInRegistries.f_257033_.m_206058_(SpawnTags.CATCHES_OCTOPUS).spliterator(), false).map(Holder::m_203334_).sorted(Comparator.comparing(item -> BuiltInRegistries.f_257033_.m_7981_(item).toString())).toList();
                int index = taggedItems.indexOf(inner.m_41720_());
                if (index >= 0) {
                    return (float)Math.round(0.01f * (float)(index + 1) * 100.0f) / 100.0f;
                }
            }
            return 0.0f;
        });
        ItemProperties.register((Item)((Item)SpawnItems.CAPTURED_OCTOPUS.get()), (ResourceLocation)new ResourceLocation("tooting"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
    }

    @Override
    public Level getWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    @Override
    public Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Override
    public void playClientSoundEvent(SoundEvent soundEvent, SoundSource source, float volume, float pitch, long seed) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new EntityBoundSoundInstance(soundEvent, source, volume, pitch, (Entity)Minecraft.m_91087_().f_91074_, seed));
        }
    }
}

