/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.spawn.server.entity.AnglerFish;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnglerFishModel<E extends AnglerFish>
extends EntityModel<E> {
    public static final String LANTERN = "lantern";
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart lantern;
    private final ModelPart jaw;
    private final ModelPart leftFin;
    private final ModelPart rightFin;

    public AnglerFishModel(ModelPart root) {
        this.root = root;
        this.body = this.root.m_171324_("body");
        this.tail = this.body.m_171324_("tail");
        this.lantern = this.body.m_171324_(LANTERN);
        this.jaw = this.body.m_171324_("jaw");
        this.leftFin = this.body.m_171324_("left_fin");
        this.rightFin = this.body.m_171324_("right_fin");
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition data = new MeshDefinition();
        PartDefinition root = data.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -4.5f, 7.0f, 7.0f, 9.0f), PartPose.m_171419_((float)0.5f, (float)19.0f, (float)-1.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -2.5f, 0.0f, 0.0f, 5.0f, 4.0f), PartPose.m_171419_((float)-0.5f, (float)0.5f, (float)4.5f));
        PartDefinition lantern = body.m_171599_(LANTERN, CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(0.0f, -3.0f, -1.0f, 0.0f, 3.0f, 2.0f).m_171514_(22, 16).m_171481_(-0.5f, -5.0f, -1.0f, 1.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-0.5f, (float)-3.5f, (float)-2.5f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition jaw = body.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.5f, -3.0f, -7.5f, 7.0f, 5.0f, 7.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)-0.5f, (float)1.0f, (float)3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftFin = body.m_171599_("left_fin", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -1.0f, 0.0f, 0.0f, 2.0f, 2.0f), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)1.5f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition rightFin = body.m_171599_("right_fin", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -1.0f, 0.0f, 0.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-4.0f, (float)0.0f, (float)1.5f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)data, (int)32, (int)32);
    }

    public static LayerDefinition getDeflatedLayerDefinition() {
        MeshDefinition data = new MeshDefinition();
        PartDefinition root = data.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 2).m_171481_(-4.0f, -2.0f, -4.5f, 7.0f, 5.0f, 9.0f), PartPose.m_171419_((float)0.5f, (float)21.0f, (float)-1.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -2.5f, 0.0f, 0.0f, 5.0f, 4.0f), PartPose.m_171419_((float)-0.5f, (float)0.5f, (float)4.5f));
        PartDefinition lantern = body.m_171599_(LANTERN, CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(0.0f, -3.0f, -1.0f, 0.0f, 3.0f, 2.0f).m_171514_(22, 16).m_171481_(-0.5f, -5.0f, -1.0f, 1.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-0.5f, (float)-1.5f, (float)-2.5f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition jaw = body.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.5f, -3.0f, -7.5f, 7.0f, 5.0f, 7.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-0.5f, (float)1.0f, (float)3.0f));
        PartDefinition leftFin = body.m_171599_("left_fin", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 1.0f, 0.0f, 0.0f, 2.0f, 2.0f), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)1.5f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition rightFin = body.m_171599_("right_fin", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 1.0f, 0.0f, 0.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-4.0f, (float)0.0f, (float)1.5f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)data, (int)32, (int)32);
    }

    public void setupAnim(E entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float speed = 2.5f;
        float degree = 1.5f;
        this.body.f_104204_ = headYaw * 0.01f;
        this.tail.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.2f)) * degree * 1.4f * 0.25f;
        this.leftFin.f_104204_ = Mth.m_14089_((float)(-1.0f + animationProgress * speed * 0.2f)) * degree * 0.8f * 0.25f + 0.8f;
        this.rightFin.f_104204_ = Mth.m_14089_((float)(2.0f + animationProgress * speed * 0.2f)) * degree * 0.8f * 0.25f - 0.8f;
        if (((AnglerFish)entity).isDeflated()) {
            return;
        }
        this.body.f_104203_ = headPitch * 0.015f;
        this.body.f_104204_ += Mth.m_14089_((float)(animationProgress * speed * 0.2f)) * degree * 0.4f * 0.25f;
        this.jaw.f_104203_ = Mth.m_14089_((float)(limbAngle * speed * 0.2f)) * degree * 0.2f * limbDistance + 0.25f;
        this.tail.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.4f)) * degree * 0.8f * 0.25f;
        this.leftFin.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.4f)) * degree * 0.8f * 0.25f + 0.8f;
        this.rightFin.f_104204_ = Mth.m_14089_((float)(3.0f + animationProgress * speed * 0.4f)) * degree * 0.8f * 0.25f - 0.8f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, float f, float g, float h, float k) {
        this.root.m_104306_(poseStack, vertexConsumer, i, j, f, g, h, k);
    }
}

