/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.model;

import com.google.common.collect.ImmutableList;
import com.ninni.spawn.server.entity.Hamster;
import net.minecraft.client.model.ColorableAgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HamsterModel<E extends Hamster>
extends ColorableAgeableListModel<E> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart rightLeg;
    private final ModelPart rightArm;
    private final ModelPart rightCheek;
    private final ModelPart rightEar;
    private final ModelPart leftLeg;
    private final ModelPart leftArm;
    private final ModelPart leftCheek;
    private final ModelPart leftEar;
    private final ModelPart tail;

    public HamsterModel(ModelPart root) {
        this.root = root;
        this.all = this.root.m_171324_("all");
        this.body = this.all.m_171324_("body");
        this.leftCheek = this.body.m_171324_("leftCheek");
        this.rightCheek = this.body.m_171324_("rightCheek");
        this.tail = this.body.m_171324_("tail");
        this.rightEar = this.body.m_171324_("rightEar");
        this.leftEar = this.body.m_171324_("leftEar");
        this.rightLeg = this.all.m_171324_("rightLeg");
        this.rightArm = this.all.m_171324_("rightArm");
        this.leftLeg = this.all.m_171324_("leftLeg");
        this.leftArm = this.all.m_171324_("leftArm");
    }

    public void setupAnim(E hamster, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.root.m_171331_().forEach(ModelPart::m_233569_);
        float speed = 1.0f;
        float degree = 1.0f;
        float pi = (float)Math.PI;
        float puffTicks = ((Hamster)hamster).getPuffTicks();
        boolean standing = ((Hamster)hamster).isStanding() || ((Hamster)hamster).hasEatenTnt();
        boolean inWheel = ((Hamster)hamster).isInWheel();
        this.root.f_104201_ = standing || hamster.m_21825_() ? -3.0f : -4.0f;
        this.leftCheek.f_233553_ = 2.0f * puffTicks;
        this.leftCheek.f_233555_ = 2.0f * puffTicks;
        this.leftCheek.f_233554_ = 1.5f * puffTicks;
        this.rightCheek.f_233553_ = 2.0f * puffTicks;
        this.rightCheek.f_233555_ = 2.0f * puffTicks;
        this.rightCheek.f_233554_ = 1.5f * puffTicks;
        this.leftEar.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.05f)) * degree * 0.6f * 0.25f;
        this.rightEar.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.05f + pi)) * degree * 0.6f * 0.25f;
        if (inWheel) {
            this.root.f_104201_ = 24.0f;
            this.all.f_104201_ = Mth.m_14031_((float)(animationProgress * speed * 2.0f)) * degree * 1.0f * 0.25f;
            this.all.f_104201_ += Mth.m_14089_((float)(animationProgress * speed * 0.2f)) * degree * 1.8f * 0.25f;
            this.all.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 2.0f)) * degree * 0.18f * 0.25f;
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(animationProgress * 1.0f)) * 1.8f * 0.25f;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(animationProgress * 1.0f + pi)) * 1.8f * 0.25f;
            this.rightArm.f_104203_ = Mth.m_14089_((float)(animationProgress * 1.0f + pi)) * 1.8f * 0.25f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(animationProgress * 1.0f)) * 1.8f * 0.25f;
            this.leftEar.f_104204_ = Mth.m_14089_((float)(animationProgress * 2.0f)) * 0.5f * 0.25f;
            this.rightEar.f_104204_ = Mth.m_14089_((float)(animationProgress * 2.0f + pi)) * 0.2f * 0.25f + 0.3f;
        } else {
            this.body.f_104201_ = Mth.m_14089_((float)(2.0f + limbAngle * 0.6f * speed)) * 0.6f * limbDistance;
            this.body.f_104201_ += Mth.m_14031_((float)(animationProgress * speed * 0.05f + pi)) * degree * 0.4f * 0.25f;
            this.body.f_104204_ = Mth.m_14089_((float)(1.0f + limbAngle * 1.0f * speed)) * 0.2f * limbDistance;
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6f * speed)) * 1.4f * limbDistance;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6f * speed + pi)) * 1.4f * limbDistance;
            this.rightArm.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6f * speed + pi)) * 1.4f * limbDistance + (standing ? -0.3927f : 0.0f);
            this.leftArm.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6f * speed)) * 1.4f * limbDistance + (standing ? -0.3927f : 0.0f);
            this.rightLeg.f_104201_ = standing ? 2.0f : 3.0f;
            this.leftLeg.f_104201_ = standing ? 2.0f : 3.0f;
            this.rightArm.f_104201_ = standing ? -1.0f : 3.0f;
            this.leftArm.f_104201_ = standing ? -1.0f : 3.0f;
        }
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = all.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.75f, -3.0f, -4.5f, 7.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.25f, (float)-4.0f, (float)-0.5f));
        PartDefinition leftCheek = body.m_171599_("leftCheek", CubeListBuilder.m_171558_().m_171514_(23, 5).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.15f, (float)1.9f, (float)-3.4f));
        PartDefinition rightCheek = body.m_171599_("rightCheek", CubeListBuilder.m_171558_().m_171514_(23, 5).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.65f, (float)1.9f, (float)-3.4f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -1.0f, 0.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.25f, (float)1.0f, (float)4.5f));
        PartDefinition rightEar = body.m_171599_("rightEar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.75f, (float)-2.5f, (float)-3.5f));
        PartDefinition cube_r1 = rightEar.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171488_(-2.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition leftEar = body.m_171599_("leftEar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.25f, (float)-2.5f, (float)-3.5f));
        PartDefinition cube_r2 = leftEar.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171480_().m_171488_(0.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition rightLeg = all.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)-1.0f, (float)2.0f));
        PartDefinition rightArm = all.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)-1.0f, (float)-2.0f));
        PartDefinition leftLeg = all.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.5f, (float)-1.0f, (float)2.0f));
        PartDefinition leftArm = all.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.5f, (float)-1.0f, (float)-2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static LayerDefinition getStandingLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = all.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.75f, -7.0f, -1.5f, 7.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.25f, (float)-3.0f, (float)-1.5f));
        PartDefinition leftCheek = body.m_171599_("leftCheek", CubeListBuilder.m_171558_().m_171514_(23, 5).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.15f, (float)-2.1f, (float)-0.4f));
        PartDefinition rightCheek = body.m_171599_("rightCheek", CubeListBuilder.m_171558_().m_171514_(23, 5).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.65f, (float)-2.1f, (float)-0.4f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -1.0f, 0.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.25f, (float)1.0f, (float)4.5f));
        PartDefinition rightEar = body.m_171599_("rightEar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.75f, (float)-6.5f, (float)-0.5f));
        PartDefinition cube_r1 = rightEar.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171488_(-2.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition leftEar = body.m_171599_("leftEar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.25f, (float)-6.5f, (float)-0.5f));
        PartDefinition cube_r2 = leftEar.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171480_().m_171488_(0.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition rightLeg = all.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5f, (float)-1.0f, (float)-3.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition rightArm = all.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)-4.0f, (float)-3.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = all.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.5f, (float)-1.0f, (float)-3.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition leftArm = all.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.5f, (float)-4.0f, (float)-3.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.root);
    }
}

