/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.model;

import com.ninni.spawn.client.model.animation.OctopusAnimation;
import com.ninni.spawn.server.entity.Octopus;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OctopusModel
extends HierarchicalModel<Octopus> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart top;
    private final ModelPart mantle;
    private final ModelPart head;
    private final ModelPart eyes;
    private final ModelPart leftEye;
    private final ModelPart rightEye;
    private final ModelPart tentacles;
    private final ModelPart leftForeTentacle;
    private final ModelPart rightForeTentacle;
    private final ModelPart leftMidForeTentacle;
    private final ModelPart rightMidForeTentacle;
    private final ModelPart leftMidBackTentacle;
    private final ModelPart rightMidBackTentacle;
    private final ModelPart leftBackTentacle;
    private final ModelPart rightBackTentacle;

    public OctopusModel(ModelPart root) {
        this.root = root;
        this.all = this.root.m_171324_("all");
        this.top = this.all.m_171324_("top");
        this.mantle = this.top.m_171324_("mantle");
        this.head = this.top.m_171324_("head");
        this.eyes = this.head.m_171324_("eyes");
        this.leftEye = this.eyes.m_171324_("leftEye");
        this.rightEye = this.eyes.m_171324_("rightEye");
        this.tentacles = this.all.m_171324_("tentacles");
        this.leftForeTentacle = this.tentacles.m_171324_("leftForeTentacle");
        this.rightForeTentacle = this.tentacles.m_171324_("rightForeTentacle");
        this.leftMidForeTentacle = this.tentacles.m_171324_("leftMidForeTentacle");
        this.rightMidForeTentacle = this.tentacles.m_171324_("rightMidForeTentacle");
        this.leftMidBackTentacle = this.tentacles.m_171324_("leftMidBackTentacle");
        this.rightMidBackTentacle = this.tentacles.m_171324_("rightMidBackTentacle");
        this.leftBackTentacle = this.tentacles.m_171324_("leftBackTentacle");
        this.rightBackTentacle = this.tentacles.m_171324_("rightBackTentacle");
    }

    public void setupAnim(Octopus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float pi = (float)Math.PI;
        this.root.m_171331_().forEach(ModelPart::m_233569_);
        if (entity.isRenderedInTooltip()) {
            this.rightForeTentacle.m_171327_(2.0f, 0.0f, 0.0f);
            this.leftForeTentacle.m_171327_(1.8f, 0.0f, 0.0f);
            this.leftMidForeTentacle.m_171327_(1.7f, -0.5f, -0.5f);
            this.rightMidForeTentacle.m_171327_(2.0f, 0.5f, 0.5f);
            this.leftMidBackTentacle.m_171327_(1.0f, -2.3f, 0.0f);
            this.rightMidBackTentacle.m_171327_(1.0f, 2.3f, 0.0f);
            this.leftBackTentacle.m_171327_(1.0f, -2.3f, 0.0f);
            this.rightBackTentacle.m_171327_(1.0f, 2.3f, 0.0f);
        }
        if (!entity.isLocking()) {
            this.m_233385_(entity.waterIdleAnimationState, OctopusAnimation.WATER_IDLE, ageInTicks, 1.0f);
            this.m_233385_(entity.idleAnimationState, OctopusAnimation.IDLE, ageInTicks, 1.0f);
            this.m_233385_(entity.enterDuctAnimationState, OctopusAnimation.ENTER_DUCT, ageInTicks, 1.0f);
            this.m_233385_(entity.exitDuctAnimationState, OctopusAnimation.EXIT_DUCT, ageInTicks, 1.0f);
            if (entity.m_20072_() && !entity.isWalkingSeafloor()) {
                this.leftEye.f_104203_ = 0.0f;
                this.leftEye.f_104204_ = 0.0f;
                this.rightEye.f_104203_ = 0.0f;
                this.rightEye.f_104204_ = 0.0f;
                this.all.f_104203_ = headPitch * (pi / 180.0f);
                this.all.f_104204_ = headYaw * (pi / 180.0f);
                this.m_267799_(OctopusAnimation.SWIM, limbSwing, limbSwingAmount, 1.5f, 8.0f);
            } else {
                this.leftEye.f_104203_ = headPitch * (pi / 180.0f);
                this.leftEye.f_104204_ = headYaw * (pi / 180.0f);
                this.rightEye.f_104203_ = headPitch * (pi / 180.0f);
                this.rightEye.f_104204_ = headYaw * (pi / 180.0f);
                this.m_267799_(OctopusAnimation.WALK, limbSwing, limbSwingAmount, 4.5f, 8.0f);
            }
        } else {
            this.leftEye.f_104203_ = 0.0f;
            this.leftEye.f_104204_ = 0.0f;
            this.rightEye.f_104203_ = 0.0f;
            this.rightEye.f_104204_ = 0.0f;
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)-2.0f));
        PartDefinition top = all.m_171599_("top", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)1.0f));
        PartDefinition mantle = top.m_171599_("mantle", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.5f, -5.0f, 0.0f, 13.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(-11, 34).m_171488_(-7.5f, -4.98f, -1.0f, 15.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(20, 12).m_171488_(6.48f, -6.0f, -1.0f, 0.0f, 8.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(20, 12).m_171480_().m_171488_(-6.48f, -6.0f, -1.0f, 0.0f, 8.0f, 11.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = top.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(20, 16).m_171488_(-3.5f, -1.0f, -3.0f, 7.0f, 3.0f, 4.0f, new CubeDeformation(0.03f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition eyes = head.m_171599_("eyes", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-1.5f, -6.0f, -1.0f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition leftEye = eyes.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.0f, -2.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(35, 0).m_171488_(0.0f, -4.0f, -1.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)-6.0f, (float)0.0f));
        PartDefinition rightEye = eyes.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.0f, -2.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(35, 0).m_171480_().m_171488_(-2.0f, -4.0f, -1.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)-6.0f, (float)0.0f));
        PartDefinition tentacles = all.m_171599_("tentacles", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftForeTentacle = tentacles.m_171599_("leftForeTentacle", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.0f, -1.0f, -16.0f, 2.0f, 2.0f, 16.0f, new CubeDeformation(0.02f)), PartPose.m_171423_((float)2.5f, (float)-1.0f, (float)-1.5f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition rightForeTentacle = tentacles.m_171599_("rightForeTentacle", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-1.0f, -1.0f, -16.0f, 2.0f, 2.0f, 16.0f, new CubeDeformation(0.02f)).m_171555_(false), PartPose.m_171423_((float)-2.5f, (float)-1.0f, (float)-1.5f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition leftMidForeTentacle = tentacles.m_171599_("leftMidForeTentacle", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.0f, -1.0f, -16.0f, 2.0f, 2.0f, 16.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)3.0f, (float)-1.0f, (float)-1.0f, (float)0.0f, (float)-1.1781f, (float)0.0f));
        PartDefinition rightMidForeTentacle = tentacles.m_171599_("rightMidForeTentacle", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-1.0f, -1.0f, -16.0f, 2.0f, 2.0f, 16.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)-1.0f, (float)-1.0f, (float)0.0f, (float)1.1781f, (float)0.0f));
        PartDefinition leftMidBackTentacle = tentacles.m_171599_("leftMidBackTentacle", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.0f, -1.0f, -16.0f, 2.0f, 2.0f, 16.0f, new CubeDeformation(0.02f)), PartPose.m_171423_((float)3.0f, (float)-1.0f, (float)0.5f, (float)0.0f, (float)-1.9635f, (float)0.0f));
        PartDefinition rightMidBackTentacle = tentacles.m_171599_("rightMidBackTentacle", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-1.0f, -1.0f, -16.0f, 2.0f, 2.0f, 16.0f, new CubeDeformation(0.02f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)-1.0f, (float)0.5f, (float)0.0f, (float)1.9635f, (float)0.0f));
        PartDefinition leftBackTentacle = tentacles.m_171599_("leftBackTentacle", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.0f, -1.0f, -16.0f, 2.0f, 2.0f, 16.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)2.5f, (float)-1.0f, (float)1.5f, (float)0.0f, (float)-2.3562f, (float)0.0f));
        PartDefinition rightBackTentacle = tentacles.m_171599_("rightBackTentacle", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-1.0f, -1.0f, -16.0f, 2.0f, 2.0f, 16.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171423_((float)-2.5f, (float)-1.0f, (float)1.5f, (float)0.0f, (float)2.3562f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)48);
    }

    public static LayerDefinition createLockingBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)-2.0f));
        PartDefinition top = all.m_171599_("top", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)1.0f));
        PartDefinition head = top.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)2.0f));
        PartDefinition eyes = head.m_171599_("eyes", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-1.5f, -6.0f, -1.0f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition leftEye = eyes.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.0f, -2.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)-6.0f, (float)0.0f));
        PartDefinition rightEye = eyes.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.0f, -2.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)-6.0f, (float)0.0f));
        PartDefinition mantle = top.m_171599_("mantle", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tentacles = all.m_171599_("tentacles", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition leftForeTentacle = tentacles.m_171599_("leftForeTentacle", CubeListBuilder.m_171558_().m_171514_(8, 24).m_171488_(-1.0f, -1.0f, -8.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)-9.5f, (float)-5.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition rightForeTentacle = tentacles.m_171599_("rightForeTentacle", CubeListBuilder.m_171558_().m_171514_(8, 24).m_171480_().m_171488_(-1.0f, -1.0f, -8.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 0).m_171480_().m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.5f, (float)-9.5f, (float)-5.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition leftMidForeTentacle = tentacles.m_171599_("leftMidForeTentacle", CubeListBuilder.m_171558_().m_171514_(8, 24).m_171488_(-1.0f, -1.0f, -8.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(-0.01f)).m_171514_(0, 5).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)7.0f, (float)-9.5f, (float)-1.0f, (float)0.0f, (float)-1.5708f, (float)1.5708f));
        PartDefinition rightMidForeTentacle = tentacles.m_171599_("rightMidForeTentacle", CubeListBuilder.m_171558_().m_171514_(8, 24).m_171480_().m_171488_(-1.0f, -1.0f, -8.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(-0.01f)).m_171555_(false).m_171514_(0, 5).m_171480_().m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(-0.01f)).m_171555_(false), PartPose.m_171423_((float)-7.0f, (float)-9.5f, (float)-1.0f, (float)0.0f, (float)1.5708f, (float)-1.5708f));
        PartDefinition leftMidBackTentacle = tentacles.m_171599_("leftMidBackTentacle", CubeListBuilder.m_171558_().m_171514_(8, 24).m_171488_(-1.0f, -1.0f, -8.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 5).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.0f, (float)-9.5f, (float)5.0f, (float)0.0f, (float)-1.5708f, (float)1.5708f));
        PartDefinition rightMidBackTentacle = tentacles.m_171599_("rightMidBackTentacle", CubeListBuilder.m_171558_().m_171514_(8, 24).m_171480_().m_171488_(-1.0f, -1.0f, -8.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 5).m_171480_().m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-7.0f, (float)-9.5f, (float)5.0f, (float)0.0f, (float)1.5708f, (float)-1.5708f));
        PartDefinition leftBackTentacle = tentacles.m_171599_("leftBackTentacle", CubeListBuilder.m_171558_().m_171514_(8, 24).m_171488_(-1.0f, -1.0f, -8.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(-0.01f)).m_171514_(0, 0).m_171480_().m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.0f, (float)-9.5f, (float)9.0f, (float)1.5708f, (float)3.1416f, (float)0.0f));
        PartDefinition rightBackTentacle = tentacles.m_171599_("rightBackTentacle", CubeListBuilder.m_171558_().m_171514_(8, 24).m_171480_().m_171488_(-1.0f, -1.0f, -8.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(-0.01f)).m_171555_(false).m_171514_(0, 0).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-9.5f, (float)9.0f, (float)1.5708f, (float)-3.1416f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)48);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

