/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.model;

import com.google.common.collect.ImmutableList;
import com.ninni.spawn.server.entity.SeaCow;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SeaCowModel
extends AgeableListModel<SeaCow> {
    public static final String FLUKES = "flukes";
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart tail;
    private final ModelPart flukes;
    private float headXRot;

    public SeaCowModel(ModelPart root) {
        this.root = root;
        this.body = this.root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.leftArm = this.body.m_171324_("left_arm");
        this.rightArm = this.body.m_171324_("right_arm");
        this.tail = this.body.m_171324_("tail");
        this.flukes = this.tail.m_171324_(FLUKES);
    }

    public void setupAnim(SeaCow entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float pi = (float)Math.PI;
        if (entity.m_20072_()) {
            float degree = Math.min(limbDistance / 0.3f, 0.7f) + 0.3f;
            float tailDegree = Math.min(limbDistance / 0.3f, 0.8f) + 0.2f;
            float armDegree = Math.min(limbDistance / 0.3f, 0.6f);
            this.body.f_104203_ = headPitch * (pi / 180.0f);
            this.body.f_104204_ = headYaw * (pi / 180.0f);
            this.head.f_104203_ = -(headPitch * (pi / 180.0f)) / 2.0f;
            this.head.f_104204_ = -(headYaw * (pi / 180.0f)) / 2.0f;
            this.head.f_104203_ += this.headXRot;
            this.head.f_104203_ += Mth.m_14089_((float)(animationProgress * 0.2f + 3.0f)) * 0.6f * degree * 0.25f;
            this.body.f_104203_ += Mth.m_14089_((float)(animationProgress * 0.2f + 2.0f)) * 0.6f * degree * 0.25f;
            this.body.f_104201_ = Mth.m_14089_((float)(animationProgress * 0.2f)) * 1.5f * degree + 17.0f;
            this.rightArm.f_104205_ = Mth.m_14089_((float)(animationProgress * 0.2f + 3.5f)) * 2.0f * 0.25f * degree - 0.8f;
            this.rightArm.f_104204_ = Mth.m_14031_((float)(animationProgress * 0.2f + 3.5f)) * 3.0f * 0.25f * armDegree;
            this.leftArm.f_104205_ = Mth.m_14089_((float)(animationProgress * 0.2f + 3.5f + pi)) * 2.0f * 0.25f * degree + 0.8f;
            this.leftArm.f_104204_ = Mth.m_14031_((float)(animationProgress * 0.2f + 3.5f + pi)) * 3.0f * 0.25f * armDegree;
            this.tail.f_104203_ = Mth.m_14089_((float)(animationProgress * 0.2f + 1.0f)) * tailDegree * 0.35f;
            this.flukes.f_104203_ = Mth.m_14089_((float)(animationProgress * 0.2f - 1.0f)) * tailDegree * 0.35f;
        } else {
            limbDistance = Mth.m_14036_((float)limbDistance, (float)-0.25f, (float)0.25f);
            float degree = 3.0f;
            this.body.f_104203_ = 0.0f;
            this.body.f_104204_ = 0.0f;
            this.head.f_104203_ = headPitch * (pi / 180.0f) / 2.0f;
            this.head.f_104204_ = headYaw * (pi / 180.0f) / 2.0f;
            this.body.f_104201_ = Mth.m_14089_((float)(limbAngle + 1.0f)) * 1.4f * 2.0f * limbDistance + 17.0f;
            this.rightArm.f_104205_ = 0.0f;
            this.rightArm.f_104204_ = Mth.m_14089_((float)limbAngle) * 1.4f * degree * limbDistance + 0.4f;
            this.leftArm.f_104205_ = 0.0f;
            this.leftArm.f_104204_ = Mth.m_14089_((float)(limbAngle + pi)) * 1.4f * degree * limbDistance - 0.4f;
            this.tail.f_104203_ = Mth.m_14089_((float)limbAngle) * 0.4f * degree * limbDistance - 0.4f;
            this.flukes.f_104203_ = Mth.m_14089_((float)limbAngle) * 0.4f * degree * limbDistance + 0.3f;
        }
    }

    public void prepareMobModel(SeaCow entity, float f, float g, float h) {
        super.m_6839_((Entity)entity, f, g, h);
        this.head.f_104201_ = -1.0f + entity.getHeadEatPositionScale(h) * 3.0f;
        this.headXRot = entity.getHeadEatAngleScale(h);
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-10.5f, -9.0f, -13.0f, 21.0f, 16.0f, 25.0f), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)1.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 41).m_171481_(-7.5f, -6.0f, -6.0f, 15.0f, 11.0f, 8.0f).m_171514_(46, 41).m_171481_(-5.5f, -6.0f, -13.0f, 11.0f, 14.0f, 7.0f), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-13.0f));
        PartDefinition leftArm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(67, 15).m_171481_(0.0f, -1.0f, -4.0f, 14.0f, 2.0f, 8.0f), PartPose.m_171419_((float)10.5f, (float)6.0f, (float)-7.0f));
        PartDefinition rightArm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(67, 15).m_171480_().m_171481_(-14.0f, -1.0f, -4.0f, 14.0f, 2.0f, 8.0f).m_171555_(false), PartPose.m_171419_((float)-10.5f, (float)6.0f, (float)-7.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171481_(-6.5f, -4.5f, 0.0f, 13.0f, 9.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)12.0f));
        PartDefinition flukes = tail.m_171599_(FLUKES, CubeListBuilder.m_171558_().m_171514_(36, 67).m_171481_(-9.5f, -1.0f, -1.0f, 19.0f, 2.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)8.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)112, (int)96);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body);
    }
}

