/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.model;

import com.ninni.spawn.client.model.animation.StickbugAnimations;
import com.ninni.spawn.server.entity.Stickbug;
import net.minecraft.client.model.AgeableHierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StickbugModel<E extends Stickbug>
extends AgeableHierarchicalModel<E> {
    private final ModelPart root;
    private final ModelPart bug;
    private final ModelPart body;
    private final ModelPart stick;
    private final ModelPart eyes;
    private final ModelPart rightEye;
    private final ModelPart leftEye;
    private final ModelPart legs;
    private final ModelPart rightFrontLeg;
    private final ModelPart rightBackLeg;
    private final ModelPart leftBackLeg;
    private final ModelPart rightMidLeg;
    private final ModelPart leftMidLeg;
    private final ModelPart leftFrontLeg;

    public StickbugModel(ModelPart root) {
        super(0.5f, 23.0f);
        this.root = root;
        this.bug = root.m_171324_("bug");
        this.body = this.bug.m_171324_("body");
        this.stick = this.body.m_171324_("stick");
        this.eyes = this.stick.m_171324_("eyes");
        this.rightEye = this.eyes.m_171324_("rightEye");
        this.leftEye = this.eyes.m_171324_("leftEye");
        this.legs = this.bug.m_171324_("legs");
        this.rightFrontLeg = this.legs.m_171324_("rightFrontLeg");
        this.rightBackLeg = this.legs.m_171324_("rightBackLeg");
        this.leftBackLeg = this.legs.m_171324_("leftBackLeg");
        this.rightMidLeg = this.legs.m_171324_("rightMidLeg");
        this.leftMidLeg = this.legs.m_171324_("leftMidLeg");
        this.leftFrontLeg = this.legs.m_171324_("leftFrontLeg");
    }

    public void setupAnim(E entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.leftEye.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.leftEye.f_104204_ = headYaw * ((float)Math.PI / 180) * 0.5f;
        this.rightEye.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.rightEye.f_104204_ = headYaw * ((float)Math.PI / 180) * 0.5f;
        this.m_233381_(((Stickbug)entity).lookOutAnimationState, StickbugAnimations.LOOK_OUT, animationProgress);
        this.m_233381_(((Stickbug)entity).danceAnimationState, StickbugAnimations.DANCE, animationProgress);
        this.m_267799_(StickbugAnimations.WALK, limbAngle, limbDistance, 3.0f, 8.0f);
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bug = partdefinition.m_171599_("bug", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-1.0f));
        PartDefinition body = bug.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition stick = body.m_171599_("stick", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, -6.0f, 4.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 4).m_171488_(-0.5f, -5.0f, 3.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 8).m_171488_(-0.5f, -4.0f, 2.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 4).m_171488_(-0.5f, -3.0f, 1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 4).m_171488_(-0.5f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 8).m_171488_(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 8).m_171488_(-0.5f, 0.0f, -2.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 4).m_171488_(-0.5f, 1.0f, -3.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 4).m_171488_(-0.5f, 3.0f, -5.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 8).m_171488_(-0.5f, 2.0f, -4.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 12).m_171488_(-0.5f, 4.0f, -6.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition eyes = stick.m_171599_("eyes", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-0.5f, (float)4.3f, (float)-4.625f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightEye = eyes.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171514_(6, 0).m_171480_().m_171488_(-2.0f, -4.5f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEye = eyes.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(6, 0).m_171488_(0.0f, -4.5f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)0.0f, (float)0.0f));
        PartDefinition legs = bug.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg = legs.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(5, 5).m_171480_().m_171488_(-7.0f, 0.0f, -0.5f, 7.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-0.5f, (float)0.0f, (float)-2.0f, (float)0.3927f, (float)-0.7854f, (float)-0.6109f));
        PartDefinition rightBackLeg = legs.m_171599_("rightBackLeg", CubeListBuilder.m_171558_().m_171514_(5, 5).m_171480_().m_171488_(-7.0f, 0.0f, -0.5f, 7.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-0.5f, (float)0.0f, (float)2.0f, (float)-0.3927f, (float)0.7854f, (float)-0.6109f));
        PartDefinition leftBackLeg = legs.m_171599_("leftBackLeg", CubeListBuilder.m_171558_().m_171514_(5, 5).m_171488_(0.0f, 0.0f, -0.5f, 7.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)0.0f, (float)2.0f, (float)-0.3927f, (float)-0.7854f, (float)0.6109f));
        PartDefinition rightMidLeg = legs.m_171599_("rightMidLeg", CubeListBuilder.m_171558_().m_171514_(5, 5).m_171480_().m_171488_(-7.0f, 0.0f, -0.5f, 7.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        PartDefinition leftMidLeg = legs.m_171599_("leftMidLeg", CubeListBuilder.m_171558_().m_171514_(5, 5).m_171488_(0.0f, 0.0f, -0.5f, 7.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition leftFrontLeg = legs.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(5, 5).m_171488_(0.0f, 0.0f, -0.5f, 7.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)0.0f, (float)-2.0f, (float)0.3927f, (float)0.7854f, (float)0.6109f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

