/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.model;

import com.ninni.spawn.client.model.animation.TunaAnimations;
import com.ninni.spawn.server.entity.Tuna;
import net.minecraft.client.model.AgeableHierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TunaModel
extends AgeableHierarchicalModel<Tuna> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart mouth;
    private final ModelPart tail;
    private final ModelPart tailFin;
    private final ModelPart dorsalFin;
    private final ModelPart dorsalFin2;
    private final ModelPart leftPectoralFin;
    private final ModelPart rightPectoralFin;
    private final ModelPart pelvicFin;
    private final ModelPart leftFin;
    private final ModelPart rightFin;

    public TunaModel(ModelPart root) {
        super(0.5f, 20.0f);
        this.root = root;
        this.body = this.root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.mouth = this.head.m_171324_("mouth");
        this.tail = this.body.m_171324_("tail");
        this.tailFin = this.tail.m_171324_("tailFin");
        this.dorsalFin = this.body.m_171324_("dorsalFin");
        this.dorsalFin2 = this.body.m_171324_("dorsalFin2");
        this.leftPectoralFin = this.body.m_171324_("leftPectoralFin");
        this.rightPectoralFin = this.body.m_171324_("rightPectoralFin");
        this.pelvicFin = this.body.m_171324_("pelvicFin");
        this.leftFin = this.body.m_171324_("leftFin");
        this.rightFin = this.body.m_171324_("rightFin");
    }

    public void setupAnim(Tuna entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        float speed = 1.2f;
        float degree = 1.5f;
        float pi = (float)Math.PI;
        this.body.f_104203_ = headPitch * (pi / 180.0f);
        this.body.f_104204_ = headYaw * (pi / 180.0f);
        if (this.f_102610_) {
            this.m_288214_(TunaAnimations.BABY_PROPORTIONS);
        }
        this.head.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.4f + 3.0f)) * degree * 0.4f * 0.25f;
        this.body.f_104201_ = Mth.m_14089_((float)(animationProgress * speed * 0.2f)) * degree * 1.5f * 0.25f + 20.0f;
        this.body.f_104204_ += Mth.m_14089_((float)(animationProgress * speed * 0.4f + 2.0f)) * degree * 0.4f * 0.25f;
        this.body.f_104203_ += Mth.m_14089_((float)(animationProgress * speed * 0.2f + 2.0f)) * degree * 0.1f * 0.25f;
        this.tail.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.4f + 1.0f)) * degree * 0.8f * 0.25f;
        this.tailFin.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.4f)) * degree * 1.6f * 0.25f;
        this.mouth.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 0.1f)) * degree * 0.1f * 0.25f + 0.05f;
        this.rightFin.f_104205_ = Mth.m_14089_((float)(animationProgress * speed * 0.4f + 1.0f)) * degree * 0.8f * 0.25f - 0.4f;
        this.leftFin.f_104205_ = Mth.m_14089_((float)(animationProgress * speed * 0.4f + 1.0f + pi)) * degree * 0.8f * 0.25f + 0.4f;
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.5f, -7.0f, -9.0f, 7.0f, 12.0f, 19.0f), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)-1.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(16, 31).m_171481_(-2.5f, -5.0f, -4.0f, 5.0f, 9.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-9.0f));
        PartDefinition mouth = head.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(53, 0).m_171481_(-1.5f, -7.0f, -1.0f, 3.0f, 7.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-4.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(23, 33).m_171481_(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 11.0f).m_171514_(33, -2).m_171481_(0.0f, 2.0f, 0.0f, 0.0f, 1.0f, 9.0f).m_171514_(33, -3).m_171481_(0.0f, -3.0f, 0.0f, 0.0f, 1.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)10.0f));
        PartDefinition tailFin = tail.m_171599_("tailFin", CubeListBuilder.m_171558_().m_171514_(0, -6).m_171481_(0.0f, -11.0f, -2.0f, 0.0f, 18.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)11.0f));
        PartDefinition dorsalFin = body.m_171599_("dorsalFin", CubeListBuilder.m_171558_().m_171514_(33, -3).m_171481_(0.0f, -6.0f, -3.5f, 0.0f, 6.0f, 11.0f), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)-2.5f));
        PartDefinition dorsalFin2 = body.m_171599_("dorsalFin2", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171481_(0.0f, -4.0f, -3.0f, 0.0f, 6.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)10.0f));
        PartDefinition leftPectoralFin = body.m_171599_("leftPectoralFin", CubeListBuilder.m_171558_().m_171514_(41, 10).m_171481_(0.0f, 0.0f, -1.5f, 0.0f, 3.0f, 4.0f), PartPose.m_171419_((float)1.5f, (float)5.0f, (float)-3.5f));
        PartDefinition rightPectoralFin = body.m_171599_("rightPectoralFin", CubeListBuilder.m_171558_().m_171514_(33, 10).m_171481_(0.0f, 0.0f, -1.5f, 0.0f, 3.0f, 4.0f), PartPose.m_171419_((float)-1.5f, (float)5.0f, (float)-3.5f));
        PartDefinition pelvicFin = body.m_171599_("pelvicFin", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171481_(0.0f, -2.0f, -3.0f, 0.0f, 6.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)10.0f));
        PartDefinition leftFin = body.m_171599_("leftFin", CubeListBuilder.m_171558_().m_171514_(33, -7).m_171480_().m_171481_(0.0f, -3.0f, -1.0f, 0.0f, 3.0f, 10.0f).m_171555_(false), PartPose.m_171423_((float)3.5f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition rightFin = body.m_171599_("rightFin", CubeListBuilder.m_171558_().m_171514_(33, -10).m_171481_(0.0f, -3.0f, -1.0f, 0.0f, 3.0f, 10.0f), PartPose.m_171423_((float)-3.5f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

