/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import com.ninni.spawn.server.block.MorayCreviceBlock;
import com.ninni.spawn.server.block.entity.MorayCreviceBlockEntity;
import com.ninni.spawn.server.block.state.properties.CaptureState;
import java.util.function.Function;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class MorayCreviceRenderer
implements BlockEntityRenderer<MorayCreviceBlockEntity> {
    private final ModelPart eel;
    private final ModelPart body;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart mandible;
    private final ModelPart noseLeft;
    private final ModelPart noseRight;
    private final ModelPart jaw;

    public MorayCreviceRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(SpawnEntityModelLayers.MORAY_EEL);
        this.eel = modelPart.m_171324_("eel");
        this.body = this.eel.m_171324_("body");
        this.neck = this.eel.m_171324_("neck");
        this.head = this.eel.m_171324_("head");
        this.mandible = this.head.m_171324_("mandible");
        this.noseLeft = this.mandible.m_171324_("noseLeft");
        this.noseRight = this.mandible.m_171324_("noseRight");
        this.jaw = this.head.m_171324_("jaw");
    }

    public void render(MorayCreviceBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int i, int j) {
        boolean doPeek;
        CaptureState state = (CaptureState)((Object)blockEntity.m_58900_().m_61143_(MorayCreviceBlock.STATE));
        Direction d = (Direction)blockEntity.m_58900_().m_61143_((Property)MorayCreviceBlock.FACING);
        boolean doPounce = state == CaptureState.POUNCING;
        boolean bl = doPeek = state == CaptureState.PEEKING;
        if (!doPounce && !doPeek) {
            return;
        }
        this.orientToFacing(poseStack, d);
        VertexConsumer consumer = MorayCreviceRenderer.textureFor(blockEntity).m_119194_(buffer, RenderType::m_110458_);
        int light = LevelRenderer.m_109541_((BlockAndTintGetter)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_().m_121945_(d));
        if (doPounce) {
            float t = ((float)(10 - blockEntity.getPounceTicks()) + partialTick) / 10.0f;
            t = Mth.m_14036_((float)t, (float)0.0f, (float)1.0f);
            float recoil = Mth.m_14036_((float)(t / 0.15f), (float)0.0f, (float)1.0f);
            float bite = Mth.m_14036_((float)((t - 0.35f) / 0.35f), (float)0.0f, (float)1.0f);
            float retF = Mth.m_14036_((float)((t - 0.5f) / 0.5f), (float)0.0f, (float)1.0f);
            double extend = (double)(-1.5f * recoil + 1.5f * retF) + 1.85;
            poseStack.m_85837_(0.0, 0.0, extend);
            float openPhase = t < 0.25f ? recoil : (t < 0.5f ? 1.0f - bite : 0.0f);
            float jawDeg = 30.0f * openPhase;
            this.jaw.f_104203_ = jawDeg * ((float)Math.PI / 180);
            float bend = 8.0f * (1.0f - Math.abs(0.5f - t) * 2.0f);
            this.neck.f_104203_ = bend * ((float)Math.PI / 180) * 0.3f;
            this.head.f_104203_ = bend * ((float)Math.PI / 180) * 0.15f;
            this.body.f_104207_ = extend < 0.5;
            this.neck.f_104207_ = extend < 1.2;
            this.head.f_104207_ = extend < 1.6;
            this.eel.m_104301_(poseStack, consumer, light, OverlayTexture.f_118083_);
            return;
        }
        double extend = MorayCreviceRenderer.getPeeking(blockEntity, partialTick);
        poseStack.m_85837_(0.0, 0.0, extend);
        long seed = blockEntity.m_58899_().m_121878_();
        int mix = Mth.m_14183_((int)Long.hashCode(seed));
        float r0 = (float)(mix & 0xFF) / 255.0f;
        float r1 = (float)(mix >>> 8 & 0xFF) / 255.0f;
        float r2 = (float)(mix >>> 16 & 0xFF) / 255.0f;
        float phase = r0 * ((float)Math.PI * 2);
        float speed = 0.85f + 0.3f * r1;
        float amp = 0.9f + 0.2f * r2;
        long gameTime = blockEntity.m_58904_() != null ? blockEntity.m_58904_().m_46467_() : 0L;
        float time = ((float)gameTime + partialTick) * speed;
        float s = Mth.m_14031_((float)(time / 60.0f * ((float)Math.PI * 2) + phase)) * 0.5f + 0.5f;
        float s2 = Mth.m_14031_((float)(time / 60.0f * ((float)Math.PI * 2) + phase + 1.1f)) * 0.5f + 0.5f;
        float jawDeg = (6.0f + 2.0f * (s - 0.5f)) * amp;
        float bendDeg = 22.0f * (s - 0.5f) * amp;
        float bendDeg2 = 22.0f * (s2 - 0.5f) * amp;
        this.jaw.f_104203_ = jawDeg * ((float)Math.PI / 180) * 2.0f;
        this.neck.f_104205_ = bendDeg * ((float)Math.PI / 180) * 0.7f;
        this.head.f_104205_ = bendDeg2 * ((float)Math.PI / 180) * 0.5f;
        this.body.f_104207_ = extend < 0.5;
        this.neck.f_104207_ = extend < 1.2;
        this.head.f_104207_ = extend < 1.6;
        this.eel.m_104301_(poseStack, consumer, light, OverlayTexture.f_118083_);
    }

    private static double getPeeking(MorayCreviceBlockEntity blockEntity, float partialTick) {
        float extendNorm;
        double extendHidden = 1.85;
        double extendPeekMax = 1.0;
        float f = 0.2f;
        float holdEnd = 0.8f;
        float total = Math.max(1, blockEntity.getPeekTotalTicks());
        float elapsed = Math.min(total, (float)blockEntity.getPeekClientAge() + partialTick);
        float t = Mth.m_14036_((float)(elapsed / total), (float)0.0f, (float)1.0f);
        Function<Float, Float> smooth01 = a -> {
            float x = Mth.m_14036_((float)a.floatValue(), (float)0.0f, (float)1.0f);
            return Float.valueOf(x * x * (3.0f - 2.0f * x));
        };
        if (t < 0.2f) {
            float u = t / 0.2f;
            extendNorm = smooth01.apply(Float.valueOf(u)).floatValue();
        } else if (t > 0.8f) {
            float u = (t - 0.8f) / 0.2f;
            extendNorm = 1.0f - smooth01.apply(Float.valueOf(u)).floatValue();
        } else {
            extendNorm = 1.0f;
        }
        return Mth.m_14139_((double)extendNorm, (double)1.85, (double)1.0);
    }

    private void orientToFacing(PoseStack poseStack, Direction direction) {
        poseStack.m_252880_(0.5f, 1.5f, 0.5f);
        float g = direction.m_122435_();
        if (direction == Direction.NORTH) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
        } else if (direction == Direction.SOUTH) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        } else {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(g));
        }
        poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.PI));
    }

    private static Material textureFor(MorayCreviceBlockEntity be) {
        ResourceLocation variant = be.getVariant();
        ResourceLocation texture = new ResourceLocation(variant.m_135827_(), "block_entity/moray_eel/moray_eel_" + variant.m_135815_());
        return new Material(TextureAtlas.f_118259_, texture);
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition eel = partdefinition.m_171599_("eel", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition body = eel.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(20, 17).m_171488_(-2.0f, -3.0f, -10.08f, 4.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 15).m_171488_(0.0f, -5.0f, -10.0f, 0.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-1.0f));
        PartDefinition neck = eel.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(-2.0f, -3.0f, -10.04f, 4.0f, 6.0f, 10.0f, new CubeDeformation(-0.02f)).m_171514_(0, 7).m_171488_(0.0f, -7.0f, -10.0f, 0.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-11.0f));
        PartDefinition head = eel.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-21.0f));
        PartDefinition mandible = head.m_171599_("mandible", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -5.0f, -5.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(23, 10).m_171488_(-2.0f, -1.0f, -6.0f, 4.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 9).m_171488_(-2.0f, -3.0f, -9.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition noseLeft = mandible.m_171599_("noseLeft", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171488_(0.0f, -2.0f, -0.5f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-3.0f, (float)-8.5f));
        PartDefinition noseRight = mandible.m_171599_("noseRight", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171480_().m_171488_(0.0f, -2.0f, -0.5f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)-3.0f, (float)-8.5f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171488_(-2.0f, 0.0f, -9.0f, 4.0f, 1.0f, 9.0f, new CubeDeformation(0.1f)).m_171514_(11, 10).m_171488_(-2.0f, -1.2f, -9.0f, 4.0f, 1.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)48);
    }
}

