/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import com.ninni.spawn.server.block.PigmentShifterBlock;
import com.ninni.spawn.server.block.entity.PigmentShifterBlockEntity;
import net.minecraft.client.Camera;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PigmentShifterRenderer
implements BlockEntityRenderer<PigmentShifterBlockEntity> {
    public static final Material SHELL_TEXTURE = new Material(TextureAtlas.f_118259_, new ResourceLocation("spawn", "entity/clam/pigment_shifter/pigment_shifter"));
    private final ModelPart bottom;
    private final ModelPart top;
    private final ModelPart eye;
    private final BlockEntityRenderDispatcher renderer;

    public PigmentShifterRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(SpawnEntityModelLayers.PIGMENT_SHIFTER);
        this.renderer = context.m_173581_();
        this.bottom = modelPart.m_171324_("bottom");
        this.top = modelPart.m_171324_("top");
        this.eye = modelPart.m_171324_("eye");
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171481_(-8.0f, -6.0f, -8.0f, 16.0f, 6.0f, 16.0f).m_171514_(0, 17).m_171481_(-5.0f, -10.0f, -5.0f, 10.0f, 4.0f, 10.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171599_("eye", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171481_(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)0.0f));
        partdefinition.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-5.0f, -7.0f, -5.0f, 10.0f, 7.0f, 10.0f), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(PigmentShifterBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        VertexConsumer vertexConsumer = SHELL_TEXTURE.m_119194_(multiBufferSource, RenderType::m_110458_);
        float g = (float)blockEntity.tickCount + f;
        float h = blockEntity.getActiveRotation(f) * 57.295776f;
        float k = Mth.m_14031_((float)(g * 0.1f)) / 2.0f + 0.3f;
        k = k * k + k;
        float l = Mth.m_14089_((float)(g * 0.1f)) / 2.0f + 0.3f;
        l = l * l + l;
        Camera camera = this.renderer.f_112249_;
        poseStack.m_252880_(0.5f, 1.5f, 0.5f);
        poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.PI));
        poseStack.m_85836_();
        if (((Boolean)blockEntity.m_58900_().m_61143_((Property)PigmentShifterBlock.WATERLOGGED)).booleanValue()) {
            poseStack.m_252880_(0.0f, -0.6f + k * 0.1f, 0.0f);
            Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f).normalize();
            poseStack.m_252781_(new Quaternionf().rotationAxis(h * ((float)Math.PI / 180), (Vector3fc)vector3f));
        }
        this.top.m_104301_(poseStack, vertexConsumer, i, j);
        poseStack.m_85849_();
        if (((Boolean)blockEntity.m_58900_().m_61143_((Property)PigmentShifterBlock.WATERLOGGED)).booleanValue()) {
            poseStack.m_85836_();
            poseStack.m_85841_(0.7f, 0.7f, 0.7f);
            poseStack.m_252880_(0.0f, 1.0f + l * 0.1f, 0.0f);
            poseStack.m_252781_(new Quaternionf().rotationYXZ(camera.m_90590_() * ((float)Math.PI / 180), -camera.m_90589_() * ((float)Math.PI / 180), 0.0f));
            poseStack.m_252880_(0.0f, -0.85f, 0.0f);
            this.eye.m_104301_(poseStack, vertexConsumer, i, j);
            poseStack.m_85849_();
        }
        this.bottom.m_104301_(poseStack, vertexConsumer, i, j);
    }
}

