/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ninni.spawn.client.model.HamsterModel;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.Hamster;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HamsterRenderer<E extends Hamster>
extends MobRenderer<E, HamsterModel<E>> {
    private final HamsterModel<E> normalModel;
    private final HamsterModel<E> standingModel;

    public HamsterRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, null, 0.4f);
        this.normalModel = this.createModel(ctx, SpawnEntityModelLayers.HAMSTER);
        this.f_115290_ = this.normalModel;
        this.standingModel = this.createModel(ctx, SpawnEntityModelLayers.HAMSTER_STANDING);
    }

    public void render(E mob, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.f_115290_ = ((Hamster)mob).isStanding() || ((Hamster)mob).hasEatenTnt() ? this.standingModel : this.normalModel;
        super.m_7392_(mob, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected float getWhiteOverlayProgress(E living, float partialTick) {
        float f = ((Hamster)living).getSwelling(partialTick);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.m_14036_((float)f, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(E entity) {
        return ((Hamster)entity).getYawningTimer() > 0 ? AnimalVariantManager.getVariantTexture(entity, "", "_yawning") : AnimalVariantManager.getVariantTexture(entity, "", "");
    }

    protected void scale(E living, PoseStack poseStack, float partialTick) {
        float base = AnimalVariantManager.getVariantScale(living);
        float f = ((Hamster)living).getSwelling(partialTick);
        float f1 = 1.0f + Mth.m_14031_((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float xz = (1.0f + f * 0.8f) * f1;
        float y = (1.0f + f * 0.2f) / f1;
        poseStack.m_85841_(base * xz, base * y, base * xz);
        super.m_7546_(living, poseStack, partialTick);
    }

    public HamsterModel<E> createModel(EntityRendererProvider.Context context, ModelLayerLocation layer) {
        return new HamsterModel(context.m_174023_(layer));
    }
}

