/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ninni.spawn.client.model.OctopusModel;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.Octopus;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OctopusRenderer<T extends LivingEntity>
extends MobRenderer<Octopus, OctopusModel> {
    private final OctopusModel normalModel;
    private final OctopusModel lockingModel;

    public OctopusRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, null, 0.0f);
        this.normalModel = new OctopusModel(ctx.m_174023_(SpawnEntityModelLayers.OCTOPUS));
        this.f_115290_ = this.normalModel;
        this.lockingModel = new OctopusModel(ctx.m_174023_(SpawnEntityModelLayers.OCTOPUS_LOCKING));
    }

    public void render(Octopus mob, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        this.f_115290_ = mob.isLocking() ? this.lockingModel : this.normalModel;
        super.m_7392_((Mob)mob, f, g, poseStack, multiBufferSource, i);
    }

    public ResourceLocation getTextureLocation(Octopus entity) {
        return AnimalVariantManager.getVariantTexture((LivingEntity)entity, "", "");
    }

    protected void scale(Octopus entity, PoseStack poseStack, float partialTickTime) {
        float scale = AnimalVariantManager.getVariantScale((LivingEntity)entity);
        poseStack.m_85841_(scale, scale, scale);
        super.m_7546_((LivingEntity)entity, poseStack, partialTickTime);
    }
}

