/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.ninni.spawn.client.model.StickbugModel;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.Stickbug;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StickbugRenderer
extends MobRenderer<Stickbug, StickbugModel<Stickbug>> {
    private final RandomSource random = RandomSource.m_216327_();
    private final ItemRenderer itemRenderer;

    public StickbugRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new StickbugModel(ctx.m_174023_(SpawnEntityModelLayers.STICKBUG)), 0.15f);
        this.itemRenderer = ctx.m_174025_();
        this.f_114478_ = 0.75f;
    }

    public void render(Stickbug entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (!entity.getItem().m_41619_()) {
            poseStack.m_85836_();
            ItemStack stack = entity.getItem();
            float hover = Mth.m_14031_((float)(((float)entity.f_19797_ + partialTicks) / 10.0f + entity.bobOffs)) * 0.1f + 0.1f;
            BakedModel model = this.itemRenderer.m_174264_(stack, entity.m_9236_(), null, entity.m_19879_());
            float groundScaleY = model.m_7442_().m_269404_((ItemDisplayContext)ItemDisplayContext.GROUND).f_111757_.y();
            poseStack.m_252880_(0.0f, hover + 0.25f * groundScaleY, 0.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252961_(entity.getSpin(partialTicks)));
            this.itemRenderer.m_269128_(stack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.f_118083_, poseStack, buffer, entity.m_9236_(), entity.m_19879_());
            poseStack.m_85849_();
        } else {
            super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(Stickbug entity) {
        return AnimalVariantManager.getVariantTexture((LivingEntity)entity, "", "");
    }

    protected void scale(Stickbug entity, PoseStack poseStack, float partialTickTime) {
        float scale = AnimalVariantManager.getVariantScale((LivingEntity)entity);
        poseStack.m_85841_(scale, scale, scale);
        super.m_7546_((LivingEntity)entity, poseStack, partialTickTime);
    }
}

