/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.ninni.spawn.mixin.accessor.EntityAccessor;
import com.ninni.spawn.mixin.accessor.TropicalFishAccessor;
import com.ninni.spawn.server.entity.AnglerFish;
import com.ninni.spawn.server.entity.common.Catchable;
import com.ninni.spawn.server.entity.common.CustomInventoryPose;
import com.ninni.spawn.server.item.tooltip.CapturedMobsTooltipData;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CapturedMobsTooltipRenderer
implements ClientTooltipComponent {
    private final ListTag capturedMobs;

    public CapturedMobsTooltipRenderer(CapturedMobsTooltipData data) {
        this.capturedMobs = data.capturedMobs();
    }

    public int m_142069_(Font font) {
        return 80;
    }

    public int m_142103_() {
        int total = 0;
        for (int h : this.computeRowHeights(Minecraft.m_91087_().f_91062_)) {
            total += h;
        }
        return total;
    }

    public void m_183452_(Font font, int x, int y, GuiGraphics graphics) {
        Minecraft mc = Minecraft.m_91087_();
        int cellSize = 16;
        int maxPerRow = 4;
        for (int i = 0; i < this.capturedMobs.size(); ++i) {
            AgeableMob ageableMob;
            Entity entity;
            CompoundTag tag = this.capturedMobs.m_128728_(i);
            EntityType type = EntityType.m_20632_((String)tag.m_128461_("id")).orElse(null);
            if (type == null || mc.f_91073_ == null || !((entity = type.m_20615_((Level)mc.f_91073_)) instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            CompoundTag fishTag = tag.m_6426_();
            fishTag.m_128473_("id");
            fishTag.m_128473_("CustomName");
            EntityType.m_20620_((Level)mc.f_91073_, null, (Entity)entity, (CompoundTag)fishTag);
            if (tag.m_128441_("CustomName")) {
                entity.m_6593_((Component)Component.m_237113_((String)tag.m_128461_("CustomName")));
            }
            if (entity instanceof Bucketable) {
                Bucketable bucketable = (Bucketable)entity;
                bucketable.m_142278_(fishTag);
                if (entity instanceof TropicalFishAccessor) {
                    TropicalFishAccessor tf = (TropicalFishAccessor)entity;
                    if (fishTag.m_128441_("BucketVariantTag")) {
                        tf.callSetPackedVariant(fishTag.m_128451_("BucketVariantTag"));
                    }
                }
            }
            if (entity instanceof Catchable) {
                Catchable catchable = (Catchable)entity;
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    catchable.loadDataFromTag(mob, fishTag);
                }
            }
            if (entity instanceof CustomInventoryPose) {
                CustomInventoryPose pose = (CustomInventoryPose)entity;
                pose.setIsRenderedInTooltip(true);
            }
            if (entity instanceof EntityAccessor) {
                EntityAccessor accessor = (EntityAccessor)entity;
                accessor.setTouchingWater(true);
            }
            entity.m_5616_(0.0f);
            float maxSize = Math.max(entity.m_6972_((Pose)entity.m_20089_()).f_20377_, entity.m_6972_((Pose)entity.m_20089_()).f_20378_);
            float scale = (float)cellSize * 0.8f / maxSize;
            scale = Math.min(scale, 32.0f);
            if (living instanceof AgeableMob && (ageableMob = (AgeableMob)living).m_6162_()) {
                scale *= 0.5f;
            }
            int col = i % maxPerRow;
            int row = i / maxPerRow;
            int[] rowHeights = this.computeRowHeights(font);
            int yOffset = 8;
            for (int r = 0; r < row; ++r) {
                yOffset += rowHeights[r];
            }
            float renderX = (float)(x + col * cellSize) + (float)cellSize / 2.0f + 8.0f;
            float renderY = (float)(y + yOffset) + (float)rowHeights[row] / 2.0f;
            float time = ((float)mc.f_91073_.m_46467_() + mc.m_91296_()) / 20.0f;
            float bob = (float)Math.sin((double)(time + (float)i * 0.4f) * Math.PI * 0.5) * 0.05f;
            PoseStack stack = graphics.m_280168_();
            stack.m_85836_();
            stack.m_252880_(renderX, renderY + bob * scale, 50.0f + (float)(i * 2));
            stack.m_85841_(-scale, -scale, scale);
            stack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
            stack.m_252781_(Axis.f_252529_.m_252977_(((float)(i % 4) - 1.5f) * 5.0f));
            int light = LightTexture.m_109885_((int)15, (int)15);
            if (entity instanceof AnglerFish) {
                light = LightTexture.m_109885_((int)0, (int)0);
            }
            Minecraft.m_91087_().m_91290_().m_114468_(false);
            Minecraft.m_91087_().m_91290_().m_114384_((Entity)living, 0.0, 0.0, 0.0, 0.0f, 1.0f, stack, (MultiBufferSource)graphics.m_280091_(), light);
            Minecraft.m_91087_().m_91290_().m_114468_(true);
            if (living.m_8077_()) {
                AgeableMob ageableMob2;
                String name = living.m_7755_().getString();
                int rawWidth = font.m_92895_(name);
                float maxWidthInPixels = (float)cellSize * 0.8f;
                float nameScale = Math.min(maxWidthInPixels / (float)rawWidth, 0.03f);
                float nameY = living.m_6972_((Pose)living.m_20089_()).f_20378_ * 2.0f;
                if (living instanceof AgeableMob && (ageableMob2 = (AgeableMob)living).m_6162_()) {
                    nameY *= 2.0f;
                }
                stack.m_252781_(Axis.f_252392_.m_252977_(45.0f));
                stack.m_252781_(Axis.f_252495_.m_252977_(((float)(i % 4) - 1.5f) * 5.0f));
                stack.m_85836_();
                stack.m_252880_(0.0f, nameY += 0.15f, 1.0f);
                stack.m_85841_(-nameScale, -nameScale, nameScale);
                int textWidth = font.m_92895_(name);
                int padding = 2;
                int x1 = -textWidth / 2 - padding;
                int y1 = -1;
                int x2 = textWidth / 2 + padding;
                Objects.requireNonNull(font);
                int y2 = 9 + 1;
                graphics.m_280509_(x1, y1, x2, y2, -1442840576);
                stack.m_252880_(0.0f, nameY, 1.0f);
                graphics.m_280056_(font, name, -textWidth / 2, 0, 0xFFFFFF, false);
                stack.m_85849_();
            }
            stack.m_85849_();
        }
    }

    private int[] computeRowHeights(Font font) {
        int maxPerRow = 4;
        int rows = (this.capturedMobs.size() + 7) / maxPerRow;
        int[] rowHeights = new int[rows];
        for (int row = 0; row < rows; ++row) {
            int index;
            boolean hasName = false;
            for (int col = 0; col < maxPerRow && (index = row * maxPerRow + col) < this.capturedMobs.size(); ++col) {
                CompoundTag tag = this.capturedMobs.m_128728_(index);
                if (!tag.m_128441_("CustomName")) continue;
                hasName = true;
                break;
            }
            rowHeights[row] = hasName ? 32 : 16;
        }
        return rowHeights;
    }
}

