/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.compat.jei;

import com.ninni.spawn.compat.jei.JEIAnthillRotRecipe;
import com.ninni.spawn.compat.jei.JEIPlugin;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.server.data.AnthillRotManager;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnthillRotCategory
implements IRecipeCategory<AnthillRotManager.AnthillRotData> {
    public static final ResourceLocation UID = new ResourceLocation("spawn", "anthill_rot");
    public static final ResourceLocation TEXTURE = new ResourceLocation("spawn", "textures/gui/jei/anthill_rot.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotDrawable;
    private final IDrawable goober;
    private final IDrawable resultArrow;

    public AnthillRotCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(150, 40);
        this.goober = guiHelper.createDrawable(TEXTURE, 0, 0, 61, 29);
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.resultArrow = guiHelper.createDrawable(TEXTURE, 0, 32, 21, 12);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)SpawnItems.ANTHILL.get()));
    }

    public RecipeType<AnthillRotManager.AnthillRotData> getRecipeType() {
        return JEIPlugin.ANTHILL_ROT;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.spawn.anthill_rot");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AnthillRotManager.AnthillRotData recipe, IFocusGroup focuses) {
        JEIAnthillRotRecipe jeiRecipe = new JEIAnthillRotRecipe(recipe);
        builder.addSlot(RecipeIngredientRole.INPUT, 67, 12).addIngredients(jeiRecipe.getInput());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 110, 12).addItemStack(new ItemStack((ItemLike)recipe.output().state().m_60734_().m_5456_()))).addTooltipCallback((view, tooltip) -> {
            recipe.output().explicitProps().forEach((key, value) -> tooltip.add(Component.m_237113_((String)(key + "=" + value)).m_130938_(style -> style.m_131140_(ChatFormatting.DARK_GRAY))));
            if (recipe.lootTable() != null) {
                tooltip.add(Component.m_237110_((String)"tooltip.spawn.loot_table", (Object[])new Object[]{recipe.lootTable().toString()}).m_130938_(style -> style.m_131140_(ChatFormatting.DARK_GRAY)));
            }
        });
    }

    public void draw(AnthillRotManager.AnthillRotData recipe, IRecipeSlotsView view, GuiGraphics stack, double mouseX, double mouseY) {
        this.slotDrawable.draw(stack, 66, 11);
        this.slotDrawable.draw(stack, 109, 11);
        this.goober.draw(stack, 12, 4);
        this.resultArrow.draw(stack, 86, 14);
    }
}

