/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.block;

import com.ninni.spawn.registry.SpawnBlockEntityTypes;
import com.ninni.spawn.registry.SpawnProperties;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.server.block.entity.ClamLauncherBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClamLauncherBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final IntegerProperty COOLDOWN = SpawnProperties.COOLDOWN;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

    public ClamLauncherBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)COOLDOWN, (Comparable)Integer.valueOf(0)));
    }

    public @Nullable BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ClamLauncherBlockEntity(blockPos, blockState);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (!((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue() && (Integer)blockState.m_61143_((Property)COOLDOWN) == 0) {
            this.open(blockState, level, blockPos);
            return InteractionResult.m_19078_((boolean)true);
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        boolean hasSignal;
        boolean bl2 = hasSignal = level.m_276867_(blockPos) || level.m_276867_(blockPos.m_7494_());
        if (hasSignal && !((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue() && (Integer)blockState.m_61143_((Property)COOLDOWN) == 0) {
            this.open(blockState, level, blockPos);
        }
    }

    public void open(BlockState blockState, Level level, BlockPos pos) {
        SoundEvent sound = (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? (SoundEvent)SpawnSoundEvents.CLAM_LAUNCHER_OPEN.get() : (SoundEvent)SpawnSoundEvents.CLAM_LAUNCHER_OPEN_LAND.get();
        level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_46597_(pos, (BlockState)((BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)COOLDOWN, (Comparable)Integer.valueOf(20)));
        level.m_186460_(new BlockPos((Vec3i)pos), (Block)this, 10);
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123774_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5, 15, 0.05, 0.5, 0.05, 0.2);
        }
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        serverLevel.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        SoundEvent sound = (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? (SoundEvent)SpawnSoundEvents.CLAM_LAUNCHER_CLOSE.get() : (SoundEvent)SpawnSoundEvents.CLAM_LAUNCHER_CLOSE_LAND.get();
        serverLevel.m_5594_(null, blockPos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        super.m_7892_(blockState, level, blockPos, entity);
        if (((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
            level.m_5594_(null, blockPos, (SoundEvent)SpawnSoundEvents.CLAM_LAUNCHER_BOUNCE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.bounce(entity, blockState);
        }
    }

    private void bounce(Entity entity, BlockState state) {
        LivingEntity livingEntity;
        double g;
        LivingEntity livingEntity2;
        Vec3 vec3 = entity.m_20184_();
        double d = entity instanceof LivingEntity ? 1.0 : 0.4;
        double s = entity instanceof LivingEntity ? 1.0 : 0.2;
        double e = entity instanceof LivingEntity && (livingEntity2 = (LivingEntity)entity).m_6844_(EquipmentSlot.CHEST).m_150930_(Items.f_42741_) ? 1.75 : 1.0;
        double d2 = g = entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6844_(EquipmentSlot.CHEST).m_150930_(Items.f_42741_) ? 3.75 : 1.0;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6844_(EquipmentSlot.CHEST).m_150930_(Items.f_42741_) && livingEntity.m_20072_()) {
            g = 2.0;
            e = 3.0;
        }
        double x = (vec3.f_82479_ * (double)0.2f + 2.0) * s * g;
        double y = (vec3.f_82480_ * (double)0.2f + 1.5) * d * e;
        double z = (vec3.f_82481_ * (double)0.2f + 2.0) * s * g;
        Vec3 vec31 = new Vec3(vec3.f_82479_, y, vec3.f_82481_);
        if (state.m_61143_((Property)FACING) == Direction.NORTH) {
            vec31 = new Vec3(vec3.f_82479_, y, z);
        } else if (state.m_61143_((Property)FACING) == Direction.EAST) {
            vec31 = new Vec3(-x, y, vec3.f_82481_);
        } else if (state.m_61143_((Property)FACING) == Direction.WEST) {
            vec31 = new Vec3(x, y, vec3.f_82481_);
        } else if (state.m_61143_((Property)FACING) == Direction.SOUTH) {
            vec31 = new Vec3(vec3.f_82479_, y, -z);
        }
        entity.m_20256_(vec31);
    }

    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return ClamLauncherBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)SpawnBlockEntityTypes.CLAM_LAUNCHER.get()), (BlockEntityTicker)(level.f_46443_ ? ClamLauncherBlockEntity::clientTick : ClamLauncherBlockEntity::serverTick));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(blockState);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public @Nullable BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        FluidState fluidState = blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76186_() == 8));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, POWERED, COOLDOWN});
    }
}

