/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.block;

import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.server.block.entity.DriedHamsterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DriedHamsterBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_NS = Block.m_49796_((double)4.5, (double)0.0, (double)3.5, (double)11.5, (double)3.0, (double)12.5);
    private static final VoxelShape SHAPE_EW = Block.m_49796_((double)3.5, (double)0.0, (double)4.5, (double)12.5, (double)3.0, (double)11.5);

    public DriedHamsterBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        FluidState fluidState = level.m_6425_(pos);
        if (!level.m_5776_() && fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76186_() == 8) {
            level.m_46796_(3009, pos, 0);
            level.m_247517_(null, pos, (SoundEvent)SpawnSoundEvents.DRIED_HAMSTER_PLACE_IN_WATER.get(), SoundSource.BLOCKS);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.m_61143_((Property)FACING) == Direction.NORTH || state.m_61143_((Property)FACING) == Direction.SOUTH ? SHAPE_NS : SHAPE_EW;
    }

    public FluidState m_5888_(BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(blockState);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public @Nullable BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76186_() == 8));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack stack = new ItemStack((ItemLike)this.m_5456_());
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof DriedHamsterBlockEntity) {
            DriedHamsterBlockEntity dh = (DriedHamsterBlockEntity)be;
            dh.m_187476_(stack);
        }
        return stack;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        DriedHamsterBlockEntity dh;
        BlockEntity be = level.m_7702_(pos);
        if (!level.f_46443_ && be instanceof DriedHamsterBlockEntity && (dh = (DriedHamsterBlockEntity)be).getHamsterData() != null) {
            ItemStack stack = new ItemStack((ItemLike)this.m_5456_());
            dh.m_187476_(stack);
            DriedHamsterBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
        }
        super.m_5707_(level, pos, state, player);
    }

    public @Nullable BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new DriedHamsterBlockEntity(blockPos, blockState);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        if (random.m_188501_() < 0.15f) {
            double x = (double)pos.m_123341_() + 0.5 + random.m_188583_() * 0.1;
            double y = (double)pos.m_123342_() + 0.25 + random.m_188583_() * 0.1;
            double z = (double)pos.m_123343_() + 0.5 + random.m_188583_() * 0.1;
            level.m_7106_((ParticleOptions)new DustParticleOptions(Vec3.m_82501_((int)9405819).m_252839_(), 1.0f), x, y, z, 0.0, 0.1, 0.0);
        }
    }

    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : (lvl, pos, st, be) -> {
            if (be instanceof DriedHamsterBlockEntity) {
                DriedHamsterBlockEntity dh = (DriedHamsterBlockEntity)be;
                DriedHamsterBlockEntity.serverTick(lvl, pos, st, dh);
            }
        };
    }
}

