/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.block;

import com.ninni.spawn.mixin.MobBucketItemAccessor;
import com.ninni.spawn.registry.SpawnProperties;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.server.block.entity.MorayCreviceBlockEntity;
import com.ninni.spawn.server.block.state.properties.CaptureState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MorayCreviceBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<CaptureState> STATE = SpawnProperties.CAPTURE_STATE;
    public static final BooleanProperty SUBMERGED = SpawnProperties.SUBMERGED;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public MorayCreviceBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SUBMERGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(STATE, (Comparable)((Object)CaptureState.READY)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, STATE, SUBMERGED, POWERED});
    }

    public void m_214162_(BlockState state, Level level, BlockPos blockPos, RandomSource random) {
        if (random.m_188503_(30) == 0 && ((Boolean)state.m_61143_((Property)SUBMERGED)).booleanValue() && state.m_61143_(STATE) != CaptureState.POUNCING) {
            level.m_245747_(blockPos, (SoundEvent)SpawnSoundEvents.MORAY_CREVICE_AMBIENT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MorayCreviceBlockEntity) {
            MorayCreviceBlockEntity eel = (MorayCreviceBlockEntity)be;
            if (stack.m_41788_()) {
                eel.setCustomName(stack.m_41786_());
            }
            eel.ensureVariantAssigned();
            if (eel.hasFish()) {
                level.m_7731_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)CaptureState.FULL)), 3);
            }
        }
        super.m_6402_(level, pos, state, placer, stack);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public @Nullable BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MorayCreviceBlockEntity(pos, state);
    }

    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? (lvl, pos, st, be) -> {
            if (be instanceof MorayCreviceBlockEntity) {
                MorayCreviceBlockEntity eel = (MorayCreviceBlockEntity)be;
                MorayCreviceBlockEntity.clientTick(eel);
            }
        } : (lvl, pos, st, be) -> {
            if (be instanceof MorayCreviceBlockEntity) {
                MorayCreviceBlockEntity eel = (MorayCreviceBlockEntity)be;
                MorayCreviceBlockEntity.serverTick(eel);
            }
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack bucketWithFish;
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_ && state.m_61143_(STATE) == CaptureState.FULL && (stack.m_150930_(Items.f_42447_) || stack.m_150930_(Items.f_42446_))) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof MorayCreviceBlockEntity)) {
            return InteractionResult.PASS;
        }
        MorayCreviceBlockEntity eel = (MorayCreviceBlockEntity)blockEntity;
        if (state.m_61143_(STATE) == CaptureState.FULL && (stack.m_150930_(Items.f_42447_) || stack.m_150930_(Items.f_42446_)) && !(bucketWithFish = eel.takeBucketedFish()).m_41619_()) {
            if (bucketWithFish.m_41720_() instanceof MobBucketItem) {
                Entity entity = ((MobBucketItemAccessor)bucketWithFish.m_41720_()).callGetFishType().m_20615_(level);
                if (entity instanceof Bucketable) {
                    Bucketable bucketable = (Bucketable)entity;
                    level.m_5594_(null, pos, bucketable.m_142623_(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                if (entity != null) {
                    entity.m_146870_();
                }
            }
            if (player.m_7500_()) {
                if (!player.m_36356_(bucketWithFish)) {
                    player.m_36176_(bucketWithFish, false);
                }
            } else {
                stack.m_41774_(1);
                player.m_21008_(hand, bucketWithFish);
            }
            level.m_5594_(null, pos, (SoundEvent)SpawnSoundEvents.MORAY_CREVICE_RETRIEVE.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)CaptureState.READY)), 3);
            eel.sync();
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public @Nullable BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_8125_().m_122424_();
        boolean submerged = MorayCreviceBlock.isFrontWater((LevelAccessor)ctx.m_43725_(), ctx.m_8083_(), facing);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_276867_(ctx.m_8083_())))).m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)SUBMERGED, (Comparable)Boolean.valueOf(submerged));
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (dir == state.m_61143_((Property)FACING)) {
            boolean submerged = MorayCreviceBlock.isFrontWater(level, pos, (Direction)state.m_61143_((Property)FACING));
            if (!(submerged || state.m_61143_(STATE) != CaptureState.PEEKING && state.m_61143_(STATE) != CaptureState.POUNCING)) {
                state = (BlockState)state.m_61124_(STATE, (Comparable)((Object)CaptureState.READY));
                BlockEntity be = level.m_7702_(pos);
                if (be instanceof MorayCreviceBlockEntity) {
                    MorayCreviceBlockEntity eel = (MorayCreviceBlockEntity)be;
                    eel.forceStopClientAnims();
                }
            }
            return (BlockState)state.m_61124_((Property)SUBMERGED, (Comparable)Boolean.valueOf(submerged));
        }
        return super.m_7417_(state, dir, neighbor, level, pos, neighborPos);
    }

    private static boolean isFrontWater(LevelAccessor level, BlockPos pos, Direction facing) {
        BlockPos front = pos.m_121945_(facing);
        return level.m_6425_(front).m_76152_() == Fluids.f_76193_;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && !level.m_276867_(pos)) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!level.f_46443_ && (flag = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) != level.m_276867_(pos)) {
            if (flag) {
                level.m_186460_(pos, (Block)this, 4);
            } else {
                level.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
            }
        }
    }
}

