/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.block;

import com.ninni.spawn.registry.SpawnBlocks;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnProperties;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.server.block.state.properties.SunflowerRotation;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class SunflowerBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final EnumProperty<SunflowerRotation> ROTATION = SpawnProperties.SUNFLOWER_ROTATION;
    public static final BooleanProperty SEEDS = SpawnProperties.SEEDS;

    public SunflowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)SEEDS, (Comparable)Boolean.valueOf(false))).m_61124_(ROTATION, (Comparable)((Object)SunflowerRotation.DAY))).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER));
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (blockState.m_61143_(ROTATION) != SunflowerRotation.NIGHT && ((Boolean)blockState.m_61143_((Property)SEEDS)).booleanValue() && blockState.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)SEEDS, (Comparable)Boolean.valueOf(false)), 3);
            int j = 1 + level.f_46441_.m_188503_(2);
            level.m_5594_(null, blockPos, (SoundEvent)SpawnSoundEvents.SUNFLOWER_SEED_PICKUP.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            SunflowerBlock.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)SpawnItems.SUNFLOWER_SEEDS.get(), j));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213898_(state, level, pos, random);
        this.tryAdvanceRotation(state, level, pos);
        for (int x = -4; x < 4; ++x) {
            for (int z = -4; z < 4; ++z) {
                for (int y = -4; y < 4; ++y) {
                    BlockPos otherPos = pos.m_7918_(x, y, z);
                    BlockState otherState = level.m_8055_(otherPos);
                    Block block = otherState.m_60734_();
                    if (!(block instanceof SunflowerBlock)) continue;
                    SunflowerBlock block2 = (SunflowerBlock)block;
                    if (otherState.m_61143_(ROTATION) == state.m_61143_(ROTATION)) continue;
                    level.m_186460_(otherPos, (Block)block2, random.m_188503_(15) + 3);
                }
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213897_(state, level, pos, random);
        this.tryAdvanceRotation(state, level, pos);
    }

    public void tryAdvanceRotation(BlockState state, ServerLevel level, BlockPos pos) {
        if (level.m_45517_(LightLayer.SKY, pos) <= 13 || state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER) {
            return;
        }
        SunflowerRotation sunflowerRotation = SunflowerBlock.getRotationType((Level)level);
        SunflowerRotation currentRotation = (SunflowerRotation)((Object)state.m_61143_(ROTATION));
        if (currentRotation == sunflowerRotation || !state.m_60713_((Block)SpawnBlocks.SUNFLOWER.get())) {
            return;
        }
        boolean flag = (Boolean)state.m_61143_((Property)SEEDS) != false || currentRotation == SunflowerRotation.NIGHT && sunflowerRotation == SunflowerRotation.MORNING;
        level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_(ROTATION, (Comparable)((Object)sunflowerRotation))).m_61124_((Property)SEEDS, (Comparable)Boolean.valueOf(flag)), 2);
    }

    public static SunflowerRotation getRotationType(Level world) {
        float timeOfDay = world.m_46942_(1.0f);
        if (world.m_46462_() || world.m_46472_() != Level.f_46428_) {
            return SunflowerRotation.NIGHT;
        }
        if (timeOfDay >= 0.92f && timeOfDay <= 1.0f || timeOfDay >= 0.0f && timeOfDay < 0.08f) {
            return SunflowerRotation.DAY;
        }
        if (timeOfDay >= 0.08f && (double)timeOfDay < 0.74) {
            return SunflowerRotation.EVENING;
        }
        if (timeOfDay >= 0.74f && timeOfDay < 0.92f) {
            return SunflowerRotation.MORNING;
        }
        return SunflowerRotation.DAY;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ROTATION, f_52858_, SEEDS});
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean bl) {
        return blockState.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER && (Boolean)blockState.m_61143_((Property)SEEDS) == false;
    }

    public boolean m_214167_(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return blockState.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER && (Boolean)blockState.m_61143_((Property)SEEDS) == false;
    }

    public void m_214148_(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        BlockState blockState2 = (BlockState)blockState.m_61124_((Property)SEEDS, (Comparable)Boolean.valueOf(true));
        serverLevel.m_7731_(blockPos, blockState2, 2);
        serverLevel.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223722_((BlockState)blockState2));
    }
}

