/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.block.entity;

import com.ninni.spawn.registry.SpawnBlockEntityTypes;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.server.block.DriedHamsterBlock;
import com.ninni.spawn.server.entity.Hamster;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DriedHamsterBlockEntity
extends BlockEntity {
    private @Nullable CompoundTag hamsterData;

    public DriedHamsterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)SpawnBlockEntityTypes.DRIED_HAMSTER.get(), blockPos, blockState);
    }

    public void setHamsterData(CompoundTag nbt) {
        this.hamsterData = nbt.m_6426_();
    }

    public @Nullable CompoundTag getHamsterData() {
        return this.hamsterData == null ? null : this.hamsterData.m_6426_();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.hamsterData != null) {
            tag.m_128365_("Hamster", (Tag)this.hamsterData);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Hamster")) {
            this.hamsterData = tag.m_128469_("Hamster").m_6426_();
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, DriedHamsterBlockEntity be) {
        if (level.f_46443_) {
            return;
        }
        if (level.f_46441_.m_188501_() < 0.001f) {
            level.m_247517_(null, pos, (SoundEvent)SpawnSoundEvents.DRIED_HAMSTER_AMBIENT.get(), SoundSource.BLOCKS);
        }
        if (((Boolean)state.m_61143_((Property)DriedHamsterBlock.WATERLOGGED)).booleanValue() && (double)level.f_46441_.m_188501_() < 0.01) {
            be.revive(level, pos, state);
        }
    }

    private void revive(Level level, BlockPos pos, BlockState state) {
        ServerLevel server;
        block5: {
            block4: {
                if (!(level instanceof ServerLevel)) break block4;
                server = (ServerLevel)level;
                if (this.hamsterData != null) break block5;
            }
            return;
        }
        Hamster hamster = (Hamster)((EntityType)SpawnEntityType.HAMSTER.get()).m_20615_((Level)server);
        if (hamster == null) {
            return;
        }
        hamster.m_20258_(this.hamsterData);
        hamster.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
        server.m_7967_((Entity)hamster);
        level.m_7471_(pos, false);
        level.m_5594_(null, pos, (SoundEvent)SpawnSoundEvents.DRIED_HAMSTER_REVIVE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void m_187476_(ItemStack stack) {
        if (this.hamsterData != null) {
            MutableComponent comp;
            stack.m_41784_().m_128365_("Hamster", (Tag)this.hamsterData.m_6426_());
            if (this.hamsterData.m_128425_("CustomName", 8) && (comp = Component.Serializer.m_130701_((String)this.hamsterData.m_128461_("CustomName"))) != null) {
                stack.m_41714_((Component)comp);
            }
        }
    }
}

