/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.block.entity;

import com.ninni.spawn.registry.SpawnBlockEntityTypes;
import com.ninni.spawn.server.block.HamsterWheelBlock;
import com.ninni.spawn.server.entity.Hamster;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HamsterWheelBlockEntity
extends BlockEntity {
    public float angle;
    public float speed;
    private float targetSpeed;
    private Optional<UUID> runner = Optional.empty();
    private int runTicksRemaining = 0;

    public HamsterWheelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SpawnBlockEntityTypes.HAMSTER_WHEEL.get(), pos, state);
    }

    public boolean isFree() {
        return this.runner.isEmpty() && this.runTicksRemaining <= 0;
    }

    public boolean tryBeginRun(Animal hamster, int ticks) {
        if (this.f_58857_ == null || !this.isFree()) {
            return false;
        }
        this.runner = Optional.of(hamster.m_20148_());
        this.runTicksRemaining = Math.max(40, ticks);
        if (!((Boolean)this.m_58900_().m_61143_((Property)HamsterWheelBlock.POWERED)).booleanValue()) {
            this.setPowered(true);
        }
        this.targetSpeed = 0.2617994f;
        this.m_6596_();
        return true;
    }

    public void stopRun() {
        if (!this.runner.isPresent() && this.runTicksRemaining == 0) {
            return;
        }
        this.runner = Optional.empty();
        this.runTicksRemaining = 0;
        this.targetSpeed = 0.0f;
        if (((Boolean)this.m_58900_().m_61143_((Property)HamsterWheelBlock.POWERED)).booleanValue()) {
            this.setPowered(false);
        }
        this.m_6596_();
    }

    private void setPowered(boolean powered) {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState st = this.m_58900_();
        if ((Boolean)st.m_61143_((Property)HamsterWheelBlock.POWERED) != powered) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)st.m_61124_((Property)HamsterWheelBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
            this.f_58857_.m_46672_(this.f_58858_, st.m_60734_());
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HamsterWheelBlockEntity be) {
        float accel = 0.02f;
        be.speed += (be.targetSpeed - be.speed) * accel;
        be.angle += be.speed;
        if ((double)be.angle > Math.PI * 2) {
            be.angle -= (float)Math.PI * 2;
        }
        if (!level.f_46443_) {
            Entity hamster;
            if (!(!be.runner.isPresent() || (hamster = ((ServerLevelAccessor)level).m_6018_().m_8791_(be.runner.get())) instanceof Hamster && hamster.m_6084_() && hamster.m_20183_().m_123314_((Vec3i)pos, 2.5))) {
                be.stopRun();
            }
            if (be.runTicksRemaining > 0) {
                --be.runTicksRemaining;
                if (be.runTicksRemaining == 0) {
                    be.stopRun();
                }
            }
            if (level.m_46467_() % 20L == 0L) {
                be.m_6596_();
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("Angle", this.angle);
        tag.m_128350_("Speed", this.speed);
        tag.m_128350_("TargetSpeed", this.targetSpeed);
        tag.m_128405_("RunTicks", this.runTicksRemaining);
        this.runner.ifPresent(u -> tag.m_128362_("Runner", u));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.angle = tag.m_128457_("Angle");
        this.speed = tag.m_128457_("Speed");
        this.targetSpeed = tag.m_128457_("TargetSpeed");
        this.runTicksRemaining = tag.m_128451_("RunTicks");
        this.runner = tag.m_128403_("Runner") ? Optional.of(tag.m_128342_("Runner")) : Optional.empty();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

