/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.data;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ninni.spawn.Spawn;
import com.ninni.spawn.server.block.entity.VariantHolderBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class BlockVariantManager
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().create();
    public static final List<BlockVariantData> DATA = Lists.newArrayList();

    public BlockVariantManager() {
        super(GSON, "block_variants");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager rm, ProfilerFiller profiler) {
        DATA.clear();
        object.forEach((loc, json) -> {
            BlockVariantData data = BlockVariantData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json).result().orElseGet(() -> {
                Spawn.LOGGER.error("Failed to read block variant entry for {}", loc);
                return null;
            });
            if (data != null) {
                DATA.add(data);
            }
        });
        Spawn.LOGGER.info("Loaded {} block variants", (Object)DATA.size());
    }

    public static boolean isValidVariant(BlockEntity blockEntity, ResourceLocation id) {
        if (id == null) {
            return false;
        }
        for (BlockVariantData d : DATA) {
            if (d.type() != blockEntity.m_58903_() || !d.id().equals((Object)id)) continue;
            return true;
        }
        return false;
    }

    public static void assignNaturally(VariantHolderBlockEntity blockEntity) {
        List<Weighted> entries = BlockVariantManager.candidatesFor(blockEntity);
        Weighted chosen = BlockVariantManager.choose(entries, blockEntity);
        if (chosen != null) {
            blockEntity.setVariant(chosen.id());
        } else {
            blockEntity.setVariant(blockEntity.getDefaultVariant());
        }
    }

    private static List<Weighted> candidatesFor(VariantHolderBlockEntity be) {
        ArrayList<Weighted> list = new ArrayList<Weighted>();
        Holder biome = be.m_58904_().m_204166_(be.m_58899_());
        int y = be.m_58899_().m_123342_();
        int maxY = be.m_58904_().m_151558_();
        int minY = be.m_58904_().m_141937_();
        Component name = be.m_7770_();
        for (BlockVariantData d2 : DATA) {
            if (d2.type() != be.m_58903_() || !d2.nameTag().isPresent() || !d2.nameTag().get().matches(name)) continue;
            list.clear();
            list.add(new Weighted(d2.id(), 1000));
            return list;
        }
        List<Weighted> filtered = BlockVariantManager.buildWeighted(be, d -> d.location().isPresent() && d.location().get().matchesBiome((Holder<Biome>)biome) && y <= d.maxY().orElse(maxY) && y > d.minY().orElse(minY));
        if (filtered.isEmpty()) {
            filtered = BlockVariantManager.buildWeighted(be, d -> d.location().isEmpty() && y <= d.maxY().orElse(maxY) && y > d.minY().orElse(minY));
        }
        return filtered;
    }

    private static List<Weighted> buildWeighted(BlockEntity be, Predicate<BlockVariantData> filter) {
        ArrayList<Weighted> out = new ArrayList<Weighted>();
        for (BlockVariantData d : DATA) {
            if (d.type() != be.m_58903_() || !filter.test(d) || !d.spawnWeight().isPresent()) continue;
            out.add(new Weighted(d.id(), d.spawnWeight().get()));
        }
        return out;
    }

    private static Weighted choose(List<Weighted> entries, BlockEntity be) {
        if (entries.isEmpty()) {
            return null;
        }
        int total = entries.stream().mapToInt(Weighted::weight).sum();
        if (total <= 0) {
            return null;
        }
        int r = be.m_58904_().f_46441_.m_188503_(total);
        int acc = 0;
        for (Weighted e : entries) {
            if (r >= (acc += e.weight())) continue;
            return e;
        }
        return null;
    }

    public record BlockVariantData(BlockEntityType<?> type, ResourceLocation id, Optional<Location> location, Optional<Integer> spawnWeight, Optional<Integer> maxY, Optional<Integer> minY, Optional<NameTagRule> nameTag) {
        public static final Codec<Location> LOCATION_CODEC = Codec.either((Codec)ResourceKey.m_195966_((ResourceKey)Registries.f_256952_), (Codec)TagKey.m_203886_((ResourceKey)Registries.f_256952_)).xmap(Location::new, Location::get);
        public static final Codec<BlockVariantData> CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.f_257049_.m_194605_().fieldOf("type").forGetter(BlockVariantData::type), (App)ResourceLocation.f_135803_.fieldOf("id").forGetter(BlockVariantData::id), (App)LOCATION_CODEC.optionalFieldOf("location").forGetter(BlockVariantData::location), (App)Codec.INT.optionalFieldOf("spawnWeight").forGetter(BlockVariantData::spawnWeight), (App)Codec.INT.optionalFieldOf("maxSpawnHeight").forGetter(BlockVariantData::maxY), (App)Codec.INT.optionalFieldOf("minSpawnHeight").forGetter(BlockVariantData::minY), (App)NameTagRule.CODEC.optionalFieldOf("nameTag").forGetter(BlockVariantData::nameTag)).apply((Applicative)i, BlockVariantData::new));
    }

    public record Weighted(ResourceLocation id, int weight) {
    }

    public record NameTagRule(List<String> names, boolean ignoreCase) {
        public static final Codec<NameTagRule> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.listOf().fieldOf("names").forGetter(NameTagRule::names), (App)Codec.BOOL.optionalFieldOf("ignoreCase", (Object)true).forGetter(NameTagRule::ignoreCase)).apply((Applicative)i, NameTagRule::new));

        public boolean matches(Component cn) {
            if (cn == null) {
                return false;
            }
            String actual = cn.getString();
            for (String n : this.names) {
                if (!(this.ignoreCase ? actual.equalsIgnoreCase(n) : actual.equals(n))) continue;
                return true;
            }
            return false;
        }
    }

    public static class Location {
        private final Either<ResourceKey<Biome>, TagKey<Biome>> value;

        public Location(Either<ResourceKey<Biome>, TagKey<Biome>> value) {
            this.value = value;
        }

        public Either<ResourceKey<Biome>, TagKey<Biome>> get() {
            return this.value;
        }

        public boolean matchesBiome(Holder<Biome> biome) {
            return this.value.left().map(arg_0 -> biome.m_203565_(arg_0)).orElseGet(() -> biome.m_203656_((TagKey)this.value.right().orElseThrow()));
        }
    }
}

