/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity;

import com.ninni.spawn.registry.SpawnCriteriaTriggers;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnParticles;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.registry.SpawnTags;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.common.FlopConditionable;
import com.ninni.spawn.server.entity.common.JsonVariantHolder;
import com.ninni.spawn.server.entity.common.PathFindingFavors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AnglerFish
extends AbstractFish
implements Bucketable,
PathFindingFavors,
FlopConditionable,
JsonVariantHolder {
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.m_135353_(AnglerFish.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(AnglerFish.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final Ingredient TEMPT_INGREDIENT = Ingredient.m_204132_(SpawnTags.ANGLER_FISH_TEMPTS);
    public static final String LAST_EFFECT_GIVEN_KEY = "LastEffectGiven";
    public static final int EFFECT_DURATION = 300;
    public static final int EFFECT_DELAY = 330;
    private boolean lastDeflated;
    private long lastDeflationSound;
    private long lastEffectGiven;

    public AnglerFish(EntityType<? extends AnglerFish> type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public boolean isDeflated() {
        return this.m_20146_() < this.m_6062_() - 4 || !this.m_6084_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.25, TEMPT_INGREDIENT, false));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @javax.annotation.Nullable SpawnGroupData spawnData, @javax.annotation.Nullable CompoundTag dataTag) {
        AnimalVariantManager.getNaturallyOccurringVariant((LivingEntity)this);
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public static AttributeSupplier.Builder m_27495_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            boolean deflated = this.isDeflated();
            if (deflated && !this.lastDeflated) {
                long time = this.m_9236_().m_46467_();
                if (this.lastDeflationSound == 0L || time - this.lastDeflationSound >= 15L) {
                    this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)SpawnSoundEvents.ANGLER_FISH_DEFLATE.get(), this.m_5720_(), this.m_6121_(), this.m_6100_());
                    this.lastDeflationSound = time;
                }
            }
            this.lastDeflated = deflated;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_5842_() && this.f_19797_ % 4 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)SpawnParticles.ANGLER_FISH_LANTERN_GLOW.get(), this.m_20208_(0.15), this.m_20227_(1.25), this.m_20262_(0.15), 0.0, 0.0, 0.0);
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.m_9236_().f_46443_ && stack.m_204117_(SpawnTags.ANGLER_FISH_LIKES) && !this.isDeflated() && !player.m_21023_(MobEffects.f_19611_)) {
            long time = this.m_9236_().m_46467_();
            if (this.lastEffectGiven == 0L || time - this.lastEffectGiven > 6600L) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    SpawnCriteriaTriggers.INTERACT_WITH_ANGLER_FISH.trigger(serverPlayer);
                }
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 6000, 0, false, true));
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                this.m_216990_((SoundEvent)SpawnSoundEvents.ANGLER_FISH_EFFECT_GIVE.get());
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel world = (ServerLevel)level;
                    world.m_8767_((ParticleOptions)((SimpleParticleType)SpawnParticles.ANGLER_FISH_LANTERN_GLOW.get()), this.m_20208_(0.1f), this.m_20227_(0.5), this.m_20262_(0.1f), 40, 25.0, 25.0, 25.0, 0.0);
                }
                this.lastEffectGiven = time;
            } else {
                this.m_216990_((SoundEvent)SpawnSoundEvents.ANGLER_FISH_EFFECT_DENY.get());
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel world = (ServerLevel)level;
                    world.m_8767_((ParticleOptions)((SimpleParticleType)SpawnParticles.ANGLER_FISH_LANTERN_GLOW.get()), this.m_20208_(0.05f), this.m_20227_(0.5), this.m_20262_(0.05f), 10, 25.0, 25.0, 25.0, 0.0);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean doesFlopWhileOutOfWater() {
        int air;
        return air % ((air = this.m_20146_()) > 40 ? 15 : 10) + this.f_19796_.m_188503_(5) == 0 && this.m_6084_();
    }

    public float m_5610_(BlockPos blockPos, LevelReader levelReader) {
        return this.getDepthPathfindingFavor(blockPos, levelReader);
    }

    public ItemStack m_28282_() {
        return ((Item)SpawnItems.ANGLER_FISH_BUCKET.get()).m_7968_();
    }

    protected @Nullable SoundEvent m_5592_() {
        return (SoundEvent)SpawnSoundEvents.FISH_DEATH.get();
    }

    protected SoundEvent m_5501_() {
        return (SoundEvent)SpawnSoundEvents.FISH_SWIM.get();
    }

    protected @Nullable SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpawnSoundEvents.FISH_HURT.get();
    }

    protected SoundEvent m_5699_() {
        return (SoundEvent)SpawnSoundEvents.FISH_FLOP.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)this.getDefaultVariant().toString());
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128356_(LAST_EFFECT_GIVEN_KEY, this.lastEffectGiven);
        tag.m_128359_("Variant", this.getVariant().toString());
        if (this.getVariantScale() != 1.0f) {
            tag.m_128350_("VariantScale", this.getVariantScale());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
        this.lastEffectGiven = tag.m_128454_(LAST_EFFECT_GIVEN_KEY);
    }

    public void m_6872_(ItemStack itemStack) {
        super.m_6872_(itemStack);
        Bucketable.m_148822_((Mob)this, (ItemStack)itemStack);
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128359_("Variant", this.getVariant().toString());
        if (this.getVariantScale() != 1.0f) {
            tag.m_128350_("VariantScale", this.getVariantScale());
        }
    }

    public void m_142278_(CompoundTag tag) {
        super.m_142278_(tag);
        Bucketable.m_148825_((Mob)this, (CompoundTag)tag);
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
    }

    @Override
    public void setVariant(ResourceLocation resourceLocation) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)resourceLocation.toString());
    }

    @Override
    public ResourceLocation getVariant() {
        return ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(DATA_VARIANT)));
    }

    @Override
    public ResourceLocation getDefaultVariant() {
        return new ResourceLocation("spawn", "olive");
    }

    @Override
    public void setVariantScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    @Override
    public float getVariantScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }
}

