/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity;

import com.google.common.collect.Lists;
import com.ninni.spawn.registry.SpawnBlockEntityTypes;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.registry.SpawnTags;
import com.ninni.spawn.server.block.entity.AnthillBlockEntity;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.common.JsonVariantHolder;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Ant
extends TamableAnimal
implements NeutralMob,
JsonVariantHolder {
    private static final EntityDataAccessor<Boolean> DATA_HAS_RESOURCE = SynchedEntityData.m_135353_(Ant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ABDOMEN_COLOR = SynchedEntityData.m_135353_(Ant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Ant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.m_135353_(Ant.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(Ant.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final String TAG_CANNOT_ENTER_ANTHILL_TICKS = "CannotEnterAnthillTicks";
    public static final String TAG_TICKS_SINCE_GATHERING = "TicksSinceGathering";
    public static final String TAG_HAS_RESOURCE = "HasResource";
    public static final String TAG_VARIANT = "Variant";
    public static final String TAG_ABDOMEN_COLOR = "AbdomenColor";
    public static final String TAG_RESOURCE_POS = "ResourcePos";
    public static final String TAG_ANTHILL_POS = "AnthillPos";
    public static final String TAG_SCALE = "VariantScale";
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private @Nullable UUID persistentAngerTarget;
    int ticksWithoutResourceSinceExitingAnthill;
    private int stayOutOfAnthillCountdown;
    int remainingCooldownBeforeLocatingNewAnthill;
    int remainingCooldownBeforeLocatingNewResource;
    @Nullable BlockPos savedResourcePos;
    @Nullable BlockPos anthillPos;
    AntGatherGoal antGatherGoal;
    AntGoToAnthillGoal goToAnthillGoal;
    private int underWaterTicks;

    public Ant(EntityType<? extends Ant> entityType, Level level) {
        super(entityType, level);
        this.f_21365_ = new AntLookControl((Mob)this);
        this.remainingCooldownBeforeLocatingNewResource = Mth.m_216271_((RandomSource)this.f_19796_, (int)200, (int)600);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        AnimalVariantManager.getNaturallyOccurringVariant((LivingEntity)this);
        int health = Mth.m_216271_((RandomSource)this.m_217043_(), (int)12, (int)20);
        this.m_21051_(Attributes.f_22276_).m_22100_((double)health);
        this.m_21153_(health);
        this.m_21051_(Attributes.f_22281_).m_22100_((double)Mth.m_216271_((RandomSource)this.m_217043_(), (int)1, (int)3));
        this.m_21051_(Attributes.f_22279_).m_22100_(Mth.m_216263_((RandomSource)this.m_217043_(), (double)0.2, (double)0.25));
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_HAS_RESOURCE, (Object)false);
        this.f_19804_.m_135372_(DATA_ABDOMEN_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)this.getDefaultVariant().toString());
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
    }

    public static float[] getColorArray(DyeColor dyeColor) {
        if (dyeColor == DyeColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] fs = dyeColor.m_41068_();
        return new float[]{fs[0] * 0.75f, fs[1] * 0.75f, fs[2] * 0.75f};
    }

    public DyeColor getAbdomenColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_ABDOMEN_COLOR)));
    }

    public void setAbdomenColor(DyeColor dyeColor) {
        this.f_19804_.m_135381_(DATA_ABDOMEN_COLOR, (Object)dyeColor.m_41060_());
    }

    public float m_5610_(BlockPos blockPos, LevelReader levelReader) {
        if (levelReader.m_8055_(blockPos).m_60795_()) {
            return 10.0f;
        }
        return 0.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new AntAttackGoal((PathfinderMob)this, 1.4f, true));
        this.f_21345_.m_25352_(1, (Goal)new AntEnterAnthillGoal());
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_(SpawnTags.ANT_TEMPTS), false));
        this.antGatherGoal = new AntGatherGoal();
        this.f_21345_.m_25352_(4, (Goal)this.antGatherGoal);
        this.f_21345_.m_25352_(5, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new AntLocateAnthillGoal());
        this.goToAnthillGoal = new AntGoToAnthillGoal();
        this.f_21345_.m_25352_(5, (Goal)this.goToAnthillGoal);
        this.f_21345_.m_25352_(6, (Goal)new AntGoToKnownResourceGoal());
        this.f_21345_.m_25352_(7, (Goal)new AntWanderGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Ant.class, false, this::getTerritorialTarget));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new AntHurtByOtherGoal(this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new AntBecomeAngryTargetGoal(this));
        this.f_21346_.m_25352_(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    private boolean getTerritorialTarget(LivingEntity livingEntity) {
        Ant ant;
        return livingEntity instanceof Ant && (ant = (Ant)livingEntity).m_21824_() && !ant.m_21825_() && !this.m_21825_() && this.m_21824_() && ant.getAbdomenColor() != this.getAbdomenColor() && !this.m_6162_() && !ant.m_6162_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22276_, 10.0);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (this.m_6898_(itemStack) && this.m_21223_() < this.m_21233_()) {
                Level level;
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(6.0f);
                }
                if ((level = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
                }
                this.m_216990_((SoundEvent)SpawnSoundEvents.ANT_EAT.get());
                ItemStack finshedStack = itemStack.m_41720_().m_5922_(itemStack, this.m_9236_(), (LivingEntity)this);
                if (finshedStack != itemStack) {
                    this.m_19983_(finshedStack);
                }
                this.m_142075_(player, interactionHand, itemStack);
                return InteractionResult.SUCCESS;
            }
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                DyeColor dyeColor = dyeItem.m_41089_();
                if (dyeColor == this.getAbdomenColor()) {
                    return super.m_6071_(player, interactionHand);
                }
                this.setAbdomenColor(dyeColor);
                this.m_142075_(player, interactionHand, itemStack);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionResult = super.m_6071_(player, interactionHand);
            if (interactionResult.m_19077_()) {
                return interactionResult;
            }
            this.m_21839_(!this.m_21827_());
            this.f_20899_ = false;
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, interactionHand);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.hasAnthill()) {
            compoundTag.m_128365_(TAG_ANTHILL_POS, (Tag)NbtUtils.m_129224_((BlockPos)this.getAnthillPos()));
        }
        if (this.hasSavedResourcePos() && !this.m_21824_()) {
            compoundTag.m_128365_(TAG_RESOURCE_POS, (Tag)NbtUtils.m_129224_((BlockPos)this.getSavedResourcePos()));
        }
        compoundTag.m_128344_(TAG_ABDOMEN_COLOR, (byte)this.getAbdomenColor().m_41060_());
        if (this.getVariantScale() != 1.0f) {
            compoundTag.m_128350_(TAG_SCALE, this.getVariantScale());
        }
        compoundTag.m_128379_(TAG_HAS_RESOURCE, this.hasResource());
        compoundTag.m_128405_(TAG_TICKS_SINCE_GATHERING, this.ticksWithoutResourceSinceExitingAnthill);
        compoundTag.m_128405_(TAG_CANNOT_ENTER_ANTHILL_TICKS, this.stayOutOfAnthillCountdown);
        compoundTag.m_128359_(TAG_VARIANT, this.getVariant().toString());
        this.m_21678_(compoundTag);
    }

    public void m_7378_(CompoundTag tag) {
        if (tag.m_128425_(TAG_ABDOMEN_COLOR, 99)) {
            this.setAbdomenColor(DyeColor.m_41053_((int)tag.m_128451_(TAG_ABDOMEN_COLOR)));
        }
        if (tag.m_128441_(TAG_SCALE)) {
            this.setVariantScale(tag.m_128457_(TAG_SCALE));
        }
        this.anthillPos = null;
        if (tag.m_128441_(TAG_ANTHILL_POS)) {
            this.anthillPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(TAG_ANTHILL_POS));
        }
        this.savedResourcePos = null;
        if (tag.m_128441_(TAG_RESOURCE_POS) && !this.m_21824_()) {
            this.savedResourcePos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(TAG_RESOURCE_POS));
        }
        super.m_7378_(tag);
        this.setHasResource(tag.m_128471_(TAG_HAS_RESOURCE));
        this.loadOrAssignVariant((Mob)this, tag, TAG_VARIANT);
        this.ticksWithoutResourceSinceExitingAnthill = tag.m_128451_(TAG_TICKS_SINCE_GATHERING);
        this.stayOutOfAnthillCountdown = tag.m_128451_(TAG_CANNOT_ENTER_ANTHILL_TICKS);
        this.m_147285_(this.m_9236_(), tag);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasResource() && this.f_19796_.m_188501_() < 0.05f) {
            for (int i = 0; i < this.f_19796_.m_188503_(2) + 1; ++i) {
                this.spawnFluidParticle(this.m_9236_(), this.m_20185_() - (double)0.3f, this.m_20185_() + (double)0.3f, this.m_20189_() - (double)0.3f, this.m_20189_() + (double)0.3f, this.m_20227_(0.5));
            }
        }
    }

    private void spawnFluidParticle(Level level, double d, double e, double f, double g, double h) {
        level.m_7106_((ParticleOptions)ParticleTypes.f_123782_, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)d, (double)e), h, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)f, (double)g), 0.0, 0.0, 0.0);
    }

    @Override
    public void setVariantScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    @Override
    public float getVariantScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    public @Nullable BlockPos getSavedResourcePos() {
        return this.savedResourcePos;
    }

    public boolean hasSavedResourcePos() {
        return this.savedResourcePos != null;
    }

    public void setSavedResourcePos(BlockPos blockPos) {
        this.savedResourcePos = blockPos;
    }

    private boolean isTiredOfLookingForResource() {
        return this.ticksWithoutResourceSinceExitingAnthill > 3600;
    }

    boolean wantsToEnterAnthill() {
        if (this.stayOutOfAnthillCountdown > 0 || this.antGatherGoal.isGathering() || this.m_5448_() != null) {
            return false;
        }
        return this.isTiredOfLookingForResource() || this.hasResource() || this.m_9236_().m_46462_();
    }

    public void setStayOutOfAnthillCountdown(int i) {
        this.stayOutOfAnthillCountdown = i;
    }

    protected void m_8024_() {
        int n = this.underWaterTicks = this.m_20072_() ? (this.underWaterTicks = this.underWaterTicks + 1) : 0;
        if (this.underWaterTicks > 20) {
            this.m_6469_(this.m_269291_().m_269063_(), 1.0f);
        }
        if (!this.hasResource()) {
            ++this.ticksWithoutResourceSinceExitingAnthill;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), false);
        }
    }

    public void resetTicksWithoutResourceSinceExitingAnthill() {
        this.ticksWithoutResourceSinceExitingAnthill = 0;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int i) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)i);
    }

    public @Nullable UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    private boolean doesAnthillHaveSpace(BlockPos blockPos) {
        BlockEntity blockEntity = this.m_9236_().m_7702_(blockPos);
        if (blockEntity instanceof AnthillBlockEntity) {
            return !((AnthillBlockEntity)blockEntity).isFullOfAnts();
        }
        return false;
    }

    @VisibleForDebug
    public boolean hasAnthill() {
        return this.anthillPos != null;
    }

    @VisibleForDebug
    public @Nullable BlockPos getAnthillPos() {
        return this.anthillPos;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.stayOutOfAnthillCountdown > 0) {
                --this.stayOutOfAnthillCountdown;
            }
            if (this.remainingCooldownBeforeLocatingNewAnthill > 0) {
                --this.remainingCooldownBeforeLocatingNewAnthill;
            }
            if (this.remainingCooldownBeforeLocatingNewResource > 0) {
                --this.remainingCooldownBeforeLocatingNewResource;
            }
            if (this.f_19797_ % 20 == 0 && !this.isAnthillValid()) {
                this.anthillPos = null;
            }
        }
    }

    boolean isAnthillValid() {
        if (!this.hasAnthill()) {
            return false;
        }
        if (this.isTooFarAway(this.anthillPos)) {
            return false;
        }
        BlockEntity blockEntity = this.m_9236_().m_7702_(this.anthillPos);
        return blockEntity != null && blockEntity.m_58903_() == SpawnBlockEntityTypes.ANTHILL.get();
    }

    public boolean hasResource() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HAS_RESOURCE);
    }

    public void setHasResource(boolean bl) {
        if (bl) {
            this.resetTicksWithoutResourceSinceExitingAnthill();
        }
        this.f_19804_.m_135381_(DATA_HAS_RESOURCE, (Object)bl);
    }

    boolean isTooFarAway(BlockPos blockPos) {
        return !this.closerThan(blockPos, 64);
    }

    protected PathNavigation m_6037_(Level level) {
        GroundPathNavigation groundPathNavigation = new GroundPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos blockPos) {
                return !this.f_26495_.m_8055_(blockPos.m_7495_()).m_60795_();
            }

            public void m_7638_() {
                if (Ant.this.antGatherGoal.isGathering()) {
                    return;
                }
                super.m_7638_();
            }
        };
        groundPathNavigation.m_26477_(false);
        groundPathNavigation.m_7008_(false);
        groundPathNavigation.m_148214_(true);
        return groundPathNavigation;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(SpawnTags.ANT_FEEDS);
    }

    boolean isResourceValid(BlockPos blockPos) {
        return this.m_9236_().m_46749_(blockPos) && this.m_9236_().m_8055_(blockPos).m_204336_(SpawnTags.ANT_RESOURCE);
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_((SoundEvent)SpawnSoundEvents.ANT_STEP.get(), 0.15f, 1.0f);
    }

    protected @Nullable SoundEvent m_7515_() {
        return (SoundEvent)SpawnSoundEvents.ANT_AMBIENT.get();
    }

    protected @Nullable SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpawnSoundEvents.ANT_HURT.get();
    }

    protected @Nullable SoundEvent m_5592_() {
        return (SoundEvent)SpawnSoundEvents.ANT_DEATH.get();
    }

    public @Nullable AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        Ant child = (Ant)((EntityType)SpawnEntityType.ANT.get()).m_20615_((Level)serverLevel);
        if (child == null || !(ageableMob instanceof Ant)) {
            return child;
        }
        Ant otherParent = (Ant)ageableMob;
        RandomSource random = serverLevel.m_213780_();
        child.setVariant(random.m_188499_() ? this.getVariant() : otherParent.getVariant());
        child.setVariantScale(random.m_188499_() ? this.getVariantScale() : otherParent.getVariantScale());
        child.setAbdomenColor(random.m_188499_() ? this.getAbdomenColor() : otherParent.getAbdomenColor());
        double ad = Ant.averageWithMutation(this.m_21051_(Attributes.f_22281_).m_22115_(), otherParent.m_21051_(Attributes.f_22281_).m_22115_(), 0.5, 1.0, 4.0, random);
        child.m_21051_(Attributes.f_22281_).m_22100_(ad);
        double hp = Ant.averageWithMutation(this.m_21051_(Attributes.f_22276_).m_22115_(), otherParent.m_21051_(Attributes.f_22276_).m_22115_(), 1.0, 6.0, 24.0, random);
        child.m_21051_(Attributes.f_22276_).m_22100_(hp);
        child.m_21153_((float)hp);
        double speed = Ant.averageWithMutation(this.m_21051_(Attributes.f_22279_).m_22115_(), otherParent.m_21051_(Attributes.f_22279_).m_22115_(), 0.02, 0.1, 0.3, random);
        child.m_21051_(Attributes.f_22279_).m_22100_(speed);
        if (this.m_21824_()) {
            child.m_21816_(this.m_21805_());
            child.m_7105_(true);
        } else if (otherParent.m_21824_()) {
            child.m_21816_(otherParent.m_21805_());
            child.m_7105_(true);
        }
        return child;
    }

    private static double averageWithMutation(double a, double b, double mutationRange, double min, double max, RandomSource random) {
        double base = (a + b) / 2.0;
        double mutated = base + Mth.m_216263_((RandomSource)random, (double)(-mutationRange), (double)mutationRange);
        return Mth.m_14008_((double)mutated, (double)min, (double)max);
    }

    protected void m_7840_(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            this.antGatherGoal.stopGathering();
        }
        return super.m_6469_(damageSource, f);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_203347_(TagKey<Fluid> tagKey) {
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
    }

    boolean closerThan(BlockPos blockPos, int i) {
        return blockPos.m_123314_((Vec3i)this.m_20183_(), (double)i);
    }

    @Override
    public void setVariant(ResourceLocation resourceLocation) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)resourceLocation.toString());
    }

    @Override
    public ResourceLocation getVariant() {
        return ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(DATA_VARIANT)));
    }

    @Override
    public ResourceLocation getDefaultVariant() {
        return new ResourceLocation("spawn", "red");
    }

    public static boolean canSpawn(EntityType<Ant> ant, ServerLevelAccessor world, MobSpawnType mobSpawnType, BlockPos pos, RandomSource randomSource) {
        return world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) && Animal.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    class AntLookControl
    extends LookControl {
        AntLookControl(Mob mob) {
            super(mob);
        }

        public void m_8128_() {
            super.m_8128_();
        }

        protected boolean m_8106_() {
            return !Ant.this.antGatherGoal.isGathering();
        }
    }

    class AntAttackGoal
    extends MeleeAttackGoal {
        AntAttackGoal(PathfinderMob pathfinderMob, double d, boolean bl) {
            super(pathfinderMob, d, bl);
        }

        public boolean m_8036_() {
            return super.m_8036_() && Ant.this.m_21660_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && Ant.this.m_21660_();
        }
    }

    class AntEnterAnthillGoal
    extends BaseAntGoal {
        AntEnterAnthillGoal() {
        }

        @Override
        public boolean canAntUse() {
            BlockEntity blockEntity;
            if (Ant.this.hasAnthill() && Ant.this.wantsToEnterAnthill() && Ant.this.anthillPos.m_203195_((Position)Ant.this.m_20182_(), 2.0) && (blockEntity = Ant.this.m_9236_().m_7702_(Ant.this.anthillPos)) instanceof AnthillBlockEntity) {
                AnthillBlockEntity antanthillBlockEntity = (AnthillBlockEntity)blockEntity;
                if (antanthillBlockEntity.isFullOfAnts()) {
                    Ant.this.anthillPos = null;
                } else {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canAntContinueToUse() {
            return false;
        }

        public void m_8056_() {
            BlockEntity blockEntity = Ant.this.m_9236_().m_7702_(Ant.this.anthillPos);
            if (blockEntity instanceof AnthillBlockEntity) {
                AnthillBlockEntity antanthillBlockEntity = (AnthillBlockEntity)blockEntity;
                antanthillBlockEntity.tryEnterAnthill((Entity)Ant.this, Ant.this.hasResource());
            }
        }
    }

    class AntGatherGoal
    extends BaseAntGoal {
        private final Predicate<BlockState> VALID_GATHERING_BLOCKS;
        private int successfulGatheringTicks;
        private int lastSoundPlayedTick;
        private boolean gathering;
        private @Nullable Vec3 hoverPos;
        private int gatheringTicks;

        AntGatherGoal() {
            this.VALID_GATHERING_BLOCKS = blockState -> {
                if (blockState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                    return false;
                }
                if (blockState.m_204336_(SpawnTags.ANT_RESOURCE)) {
                    if (blockState.m_60734_() instanceof DoublePlantBlock) {
                        return blockState.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.LOWER;
                    }
                    return true;
                }
                return false;
            };
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canAntUse() {
            if (Ant.this.remainingCooldownBeforeLocatingNewResource > 0) {
                return false;
            }
            if (Ant.this.hasResource()) {
                return false;
            }
            if (Ant.this.m_21824_()) {
                return false;
            }
            Optional<BlockPos> optional = this.findNearbyResource();
            if (optional.isPresent()) {
                Ant.this.savedResourcePos = optional.get();
                Ant.this.f_21344_.m_26519_((double)Ant.this.savedResourcePos.m_123341_() + 0.5, (double)Ant.this.savedResourcePos.m_123342_(), (double)Ant.this.savedResourcePos.m_123343_() + 0.5, (double)1.2f);
                return true;
            }
            Ant.this.remainingCooldownBeforeLocatingNewResource = Mth.m_216271_((RandomSource)Ant.this.f_19796_, (int)200, (int)600);
            return false;
        }

        @Override
        public boolean canAntContinueToUse() {
            if (!this.gathering) {
                return false;
            }
            if (Ant.this.m_21824_()) {
                return false;
            }
            if (!Ant.this.hasSavedResourcePos()) {
                return false;
            }
            if (Ant.this.m_9236_().m_46471_()) {
                return false;
            }
            if (this.hasGatherdLongEnough()) {
                return Ant.this.f_19796_.m_188501_() < 0.2f;
            }
            if (Ant.this.f_19797_ % 20 == 0 && !Ant.this.isResourceValid(Ant.this.savedResourcePos)) {
                Ant.this.savedResourcePos = null;
                return false;
            }
            return true;
        }

        private boolean hasGatherdLongEnough() {
            return this.successfulGatheringTicks > 200;
        }

        boolean isGathering() {
            return this.gathering;
        }

        void stopGathering() {
            this.gathering = false;
        }

        public void m_8056_() {
            this.successfulGatheringTicks = 0;
            this.gatheringTicks = 0;
            this.lastSoundPlayedTick = 0;
            this.gathering = true;
            Ant.this.resetTicksWithoutResourceSinceExitingAnthill();
        }

        public void m_8041_() {
            if (this.hasGatherdLongEnough()) {
                Ant.this.m_216990_((SoundEvent)SpawnSoundEvents.ANT_COLLECT_RESOURCE.get());
                Ant.this.setHasResource(true);
            }
            this.gathering = false;
            Ant.this.f_21344_.m_26573_();
            Ant.this.remainingCooldownBeforeLocatingNewResource = 200;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            ++this.gatheringTicks;
            if (this.gatheringTicks > 400) {
                Ant.this.savedResourcePos = null;
                return;
            }
            Vec3 vec3 = Vec3.m_82539_((Vec3i)Ant.this.savedResourcePos);
            if (vec3.m_82554_(Ant.this.m_20182_()) > 1.0) {
                this.hoverPos = vec3;
                this.setWantedPos();
                return;
            }
            if (this.hoverPos == null) {
                this.hoverPos = vec3;
            }
            boolean bl = Ant.this.m_20182_().m_82554_(this.hoverPos) <= 0.1;
            boolean bl2 = true;
            if (!bl && this.gatheringTicks > 400) {
                Ant.this.savedResourcePos = null;
                return;
            }
            if (bl) {
                boolean bl3;
                boolean bl4 = bl3 = Ant.this.f_19796_.m_188503_(25) == 0;
                if (bl3) {
                    this.hoverPos = new Vec3(vec3.m_7096_() + (double)this.getOffset(), vec3.m_7098_(), vec3.m_7094_() + (double)this.getOffset());
                    Ant.this.f_21344_.m_26573_();
                } else {
                    bl2 = false;
                }
                Ant.this.m_21563_().m_24946_(vec3.m_7096_(), vec3.m_7098_() + 0.5, vec3.m_7094_());
            }
            if (bl2) {
                this.setWantedPos();
            }
            ++this.successfulGatheringTicks;
            if (Ant.this.f_19796_.m_188501_() < 0.05f && this.successfulGatheringTicks > this.lastSoundPlayedTick + 60) {
                this.lastSoundPlayedTick = this.successfulGatheringTicks;
            }
        }

        private void setWantedPos() {
            Ant.this.m_21566_().m_6849_(this.hoverPos.m_7096_(), this.hoverPos.m_7098_(), this.hoverPos.m_7094_(), (double)0.7f);
        }

        private float getOffset() {
            return (Ant.this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPos> findNearbyResource() {
            return this.findNearestBlock(this.VALID_GATHERING_BLOCKS);
        }

        private Optional<BlockPos> findNearestBlock(Predicate<BlockState> predicate) {
            BlockPos blockPos = Ant.this.m_20183_();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            int i = 0;
            while ((double)i <= 5.0) {
                int j = 0;
                while ((double)j < 5.0) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            mutableBlockPos.m_122154_((Vec3i)blockPos, k, i - 1, l);
                            if (blockPos.m_123314_((Vec3i)mutableBlockPos, 5.0) && predicate.test(Ant.this.m_9236_().m_8055_((BlockPos)mutableBlockPos))) {
                                return Optional.of(mutableBlockPos);
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                    ++j;
                }
                i = i > 0 ? -i : 1 - i;
            }
            return Optional.empty();
        }
    }

    class AntLocateAnthillGoal
    extends BaseAntGoal {
        AntLocateAnthillGoal() {
        }

        @Override
        public boolean canAntUse() {
            return Ant.this.remainingCooldownBeforeLocatingNewAnthill == 0 && !Ant.this.hasAnthill() && Ant.this.wantsToEnterAnthill();
        }

        @Override
        public boolean canAntContinueToUse() {
            return false;
        }

        public void m_8056_() {
            Ant.this.remainingCooldownBeforeLocatingNewAnthill = 200;
            List<BlockPos> list = this.findNearbyAnthillsWithSpace();
            if (list.isEmpty()) {
                return;
            }
            for (BlockPos blockPos : list) {
                if (Ant.this.goToAnthillGoal.isTargetBlacklisted(blockPos)) continue;
                Ant.this.anthillPos = blockPos;
                return;
            }
            Ant.this.goToAnthillGoal.clearBlacklist();
            Ant.this.anthillPos = list.get(0);
        }

        private List<BlockPos> findNearbyAnthillsWithSpace() {
            BlockPos blockPos = Ant.this.m_20183_();
            PoiManager poiManager = ((ServerLevel)Ant.this.m_9236_()).m_8904_();
            Stream stream = poiManager.m_27181_(holder -> holder.m_203656_(SpawnTags.ANT_HOME), blockPos, 20, PoiManager.Occupancy.ANY);
            return stream.map(PoiRecord::m_27257_).filter(Ant.this::doesAnthillHaveSpace).sorted(Comparator.comparingDouble(blockPos2 -> blockPos2.m_123331_((Vec3i)blockPos))).collect(Collectors.toList());
        }
    }

    @VisibleForDebug
    public class AntGoToAnthillGoal
    extends BaseAntGoal {
        int travellingTicks;
        final List<BlockPos> blacklistedTargets;
        private @Nullable Path lastPath;
        private int ticksStuck;

        AntGoToAnthillGoal() {
            this.travellingTicks = Ant.this.m_9236_().f_46441_.m_188503_(10);
            this.blacklistedTargets = Lists.newArrayList();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canAntUse() {
            return Ant.this.anthillPos != null && !Ant.this.m_21536_() && Ant.this.wantsToEnterAnthill() && !this.hasReachedTarget(Ant.this.anthillPos) && Ant.this.m_9236_().m_8055_(Ant.this.anthillPos).m_204336_(SpawnTags.ANTHILLS);
        }

        @Override
        public boolean canAntContinueToUse() {
            return this.canAntUse();
        }

        public void m_8056_() {
            this.travellingTicks = 0;
            this.ticksStuck = 0;
            super.m_8056_();
        }

        public void m_8041_() {
            this.travellingTicks = 0;
            this.ticksStuck = 0;
            Ant.this.f_21344_.m_26573_();
            Ant.this.f_21344_.m_26566_();
        }

        public void m_8037_() {
            if (Ant.this.anthillPos == null) {
                return;
            }
            ++this.travellingTicks;
            if (this.travellingTicks > this.m_183277_(600)) {
                this.dropAndBlacklistAnthill();
                return;
            }
            if (Ant.this.f_21344_.m_26572_()) {
                return;
            }
            if (Ant.this.closerThan(Ant.this.anthillPos, 16)) {
                boolean bl = this.pathfindDirectlyTowards(Ant.this.anthillPos);
                if (!bl) {
                    this.dropAndBlacklistAnthill();
                } else if (this.lastPath != null && Ant.this.f_21344_.m_26570_().m_77385_(this.lastPath)) {
                    ++this.ticksStuck;
                    if (this.ticksStuck > 60) {
                        this.dropAnthill();
                        this.ticksStuck = 0;
                    }
                } else {
                    this.lastPath = Ant.this.f_21344_.m_26570_();
                }
                return;
            }
            if (Ant.this.isTooFarAway(Ant.this.anthillPos)) {
                this.dropAnthill();
                return;
            }
            Ant.this.m_21573_().m_26519_((double)Ant.this.anthillPos.m_123341_(), (double)Ant.this.anthillPos.m_123342_(), (double)Ant.this.anthillPos.m_123343_(), 1.0);
        }

        private boolean pathfindDirectlyTowards(BlockPos blockPos) {
            Ant.this.f_21344_.m_26529_(10.0f);
            Ant.this.f_21344_.m_26519_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 1.0);
            return Ant.this.f_21344_.m_26570_() != null && Ant.this.f_21344_.m_26570_().m_77403_();
        }

        boolean isTargetBlacklisted(BlockPos blockPos) {
            return this.blacklistedTargets.contains(blockPos);
        }

        private void blacklistTarget(BlockPos blockPos) {
            this.blacklistedTargets.add(blockPos);
            while (this.blacklistedTargets.size() > 3) {
                this.blacklistedTargets.remove(0);
            }
        }

        void clearBlacklist() {
            this.blacklistedTargets.clear();
        }

        private void dropAndBlacklistAnthill() {
            if (Ant.this.anthillPos != null) {
                this.blacklistTarget(Ant.this.anthillPos);
            }
            this.dropAnthill();
        }

        private void dropAnthill() {
            Ant.this.anthillPos = null;
            Ant.this.remainingCooldownBeforeLocatingNewAnthill = 200;
        }

        private boolean hasReachedTarget(BlockPos blockPos) {
            if (Ant.this.closerThan(blockPos, 2)) {
                return true;
            }
            Path path = Ant.this.f_21344_.m_26570_();
            return path != null && path.m_77406_().equals((Object)blockPos) && path.m_77403_() && path.m_77392_();
        }
    }

    public class AntGoToKnownResourceGoal
    extends BaseAntGoal {
        private final Ant ant;

        AntGoToKnownResourceGoal() {
            this.ant = Ant.this;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canAntUse() {
            if (this.ant.savedResourcePos == null) {
                return false;
            }
            if (!this.ant.isResourceValid(this.ant.savedResourcePos)) {
                this.ant.savedResourcePos = null;
                return false;
            }
            return !this.ant.m_21824_() && this.wantsToGoToKnownResource();
        }

        @Override
        public boolean canAntContinueToUse() {
            return !Ant.this.m_21824_() && this.canAntUse();
        }

        public void m_8041_() {
            Ant.this.f_21344_.m_26573_();
            Ant.this.f_21344_.m_26566_();
        }

        public void m_8037_() {
            BlockPos targetPos = this.ant.savedResourcePos;
            if (targetPos != null && this.ant.isResourceValid(targetPos)) {
                Ant.this.m_21573_().m_26519_((double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_(), 1.0);
            }
        }

        private boolean wantsToGoToKnownResource() {
            return Ant.this.ticksWithoutResourceSinceExitingAnthill > 2400;
        }
    }

    class AntWanderGoal
    extends WaterAvoidingRandomStrollGoal {
        AntWanderGoal(Ant ant) {
            super((PathfinderMob)ant, 0.8, 1.0000001E-5f);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        protected @Nullable Vec3 m_7037_() {
            if (Ant.this.hasAnthill() && !Ant.this.m_21824_()) {
                Vec3 vec32;
                if (Ant.this.isAnthillValid() && !Ant.this.closerThan(Ant.this.anthillPos, 22)) {
                    Vec3 vec3 = Vec3.m_82512_((Vec3i)Ant.this.anthillPos);
                    vec32 = vec3.m_82546_(Ant.this.m_20182_()).m_82541_();
                } else {
                    vec32 = Ant.this.m_20252_(0.0f);
                }
                Vec3 vec33 = LandRandomPos.m_148492_((PathfinderMob)Ant.this, (int)8, (int)7, (Vec3)vec32);
                if (vec33 != null) {
                    return vec33;
                }
            }
            return super.m_7037_();
        }
    }

    class AntHurtByOtherGoal
    extends HurtByTargetGoal {
        AntHurtByOtherGoal(Ant ant) {
            super((PathfinderMob)ant, new Class[0]);
        }

        public boolean m_8045_() {
            return Ant.this.m_21660_() && super.m_8045_();
        }

        protected void m_5766_(Mob mob, LivingEntity livingEntity) {
            if (mob instanceof Ant && this.f_26135_.m_142582_((Entity)livingEntity)) {
                mob.m_6710_(livingEntity);
            }
        }
    }

    static class AntBecomeAngryTargetGoal
    extends NearestAttackableTargetGoal<Player> {
        AntBecomeAngryTargetGoal(Ant ant) {
            super((Mob)ant, Player.class, 10, true, false, arg_0 -> ((Ant)ant).m_21674_(arg_0));
        }

        public boolean m_8036_() {
            return this.antCanTarget() && super.m_8036_();
        }

        public boolean m_8045_() {
            boolean bl = this.antCanTarget();
            if (!bl || this.f_26135_.m_5448_() == null) {
                this.f_26137_ = null;
                return false;
            }
            return super.m_8045_();
        }

        private boolean antCanTarget() {
            Ant ant = (Ant)this.f_26135_;
            return ant.m_21660_();
        }
    }

    abstract class BaseAntGoal
    extends Goal {
        BaseAntGoal() {
        }

        public abstract boolean canAntUse();

        public abstract boolean canAntContinueToUse();

        public boolean m_8036_() {
            return this.canAntUse() && !Ant.this.m_21660_() && !Ant.this.m_21824_();
        }

        public boolean m_8045_() {
            return this.canAntContinueToUse() && !Ant.this.m_21660_() && !Ant.this.m_21824_();
        }
    }
}

