/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity;

import com.ninni.spawn.client.inventory.HamsterInventoryMenu;
import com.ninni.spawn.mixin.accessor.SimpleContainerAccessor;
import com.ninni.spawn.registry.SpawnBlocks;
import com.ninni.spawn.registry.SpawnCriteriaTriggers;
import com.ninni.spawn.registry.SpawnDamageTypes;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnNetwork;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.registry.SpawnTags;
import com.ninni.spawn.server.block.DriedHamsterBlock;
import com.ninni.spawn.server.block.HamsterWheelBlock;
import com.ninni.spawn.server.block.entity.DriedHamsterBlockEntity;
import com.ninni.spawn.server.block.entity.HamsterWheelBlockEntity;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.common.JsonVariantHolder;
import com.ninni.spawn.server.network.OpenHamsterScreenPacket;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Hamster
extends TamableAnimal
implements InventoryCarrier,
ContainerListener,
HasCustomInventoryScreen,
JsonVariantHolder {
    public static final EntityDataAccessor<String> VARIANT = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> PUFF_TICKS = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> HAS_EATEN_TNT = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TNT_TIMER = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> YAWNING_TIMER = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IN_WHEEL = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> WHEEL_COOLDOWN = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HYDRATION = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean convertingToDriedBlock = false;
    static final Predicate<ItemEntity> ALLOWED_ITEMS = itemEntity -> !itemEntity.m_32063_() && itemEntity.m_6084_();
    public final SimpleContainer inventory = new SimpleContainer(12);
    private int standingTicks;

    public Hamster(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new HamsterMoveControl();
        this.m_21553_(true);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        AnimalVariantManager.getNaturallyOccurringVariant((LivingEntity)this);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Hamster.class, false, this::getTerritorialTarget));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HamsterEatPrimedTntGoal(16.0, 1.35));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 24.0f, 1.1, 1.3));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 24.0f, 1.1, 1.3));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 7.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(SpawnTags.HAMSTER_TEMPTS), false));
        this.f_21345_.m_25352_(0, (Goal)new HamsterRunInWheelGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new HamsterSearchForItemsGoal());
        this.f_21345_.m_25352_(1, (Goal)new HamsterSeekWheelGoal(1.0, 12, 4));
        this.f_21345_.m_25352_(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(13, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(14, (Goal)new StandGoal());
    }

    private boolean getTerritorialTarget(LivingEntity livingEntity) {
        Hamster hamster;
        return livingEntity instanceof Hamster && (hamster = (Hamster)livingEntity).m_21824_() && !hamster.m_21825_() && !this.m_21825_() && this.m_21824_() && hamster.m_21805_() == this.m_21805_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22276_, 6.0);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(SpawnTags.HAMSTER_TEMPTS);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (!this.m_9236_().f_46443_ && player.m_36341_() && this.m_21830_((LivingEntity)player) && !this.m_6162_()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SpawnCriteriaTriggers.OPEN_HAMSTER_INVENTORY.trigger(serverPlayer);
            }
            this.m_213583_(player);
            return InteractionResult.SUCCESS;
        }
        if (this.m_9236_().f_46443_) {
            boolean bl = this.m_21830_((LivingEntity)player) || this.m_21824_() || itemStack.m_204117_(SpawnTags.HAMSTER_FEEDS) && !this.m_21824_();
            return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemStack) && this.m_21223_() < this.m_21233_()) {
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                this.m_5634_(4.0f);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionResult = super.m_6071_(player, interactionHand);
            if (interactionResult.m_19077_() && !this.m_6162_() || !this.m_21830_((LivingEntity)player)) {
                return interactionResult;
            }
            this.m_21839_(!this.m_21827_());
            this.f_20899_ = false;
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        if (!itemStack.m_204117_(SpawnTags.HAMSTER_FEEDS)) {
            return super.m_6071_(player, interactionHand);
        }
        if (!player.m_150110_().f_35937_) {
            this.m_5496_((SoundEvent)SpawnSoundEvents.HAMSTER_EAT.get(), 1.0f, 1.0f);
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            this.m_5496_((SoundEvent)SpawnSoundEvents.HAMSTER_EAT.get(), 1.0f, 1.0f);
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.m_21839_(true);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            return InteractionResult.SUCCESS;
        }
        this.m_9236_().m_7605_((Entity)this, (byte)6);
        return InteractionResult.SUCCESS;
    }

    public float getPuffTicks() {
        return ((Float)this.f_19804_.m_135370_(PUFF_TICKS)).floatValue();
    }

    public void m_8119_() {
        if (this.getWheelCooldown() > 0) {
            this.setWheelCooldown(this.getWheelCooldown() - 1);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.m_9236_().m_46472_() == Level.f_46429_ && this.f_19797_ % 20 == 0) {
                this.setHydration(this.getHydration() - 1);
            }
            if (this.getHydration() <= 0) {
                this.convertToDriedBlock();
                return;
            }
            if (this.standingTicks > 0) {
                --this.standingTicks;
            }
            if (this.standingTicks == 0 && this.isStanding()) {
                this.setStanding(false);
            }
            if (this.getYawningTimer() > 0) {
                this.setYawningTimer(this.getYawningTimer() - 1);
            } else if (this.m_9236_().m_46461_() && this.f_19796_.m_188501_() < 0.001f) {
                this.m_5496_((SoundEvent)SpawnSoundEvents.HAMSTER_YAWN.get(), 1.0f, 1.0f);
                this.setYawningTimer(30);
            }
            if (this.hasEatenTnt()) {
                this.f_19804_.m_135381_(PUFF_TICKS, (Object)Float.valueOf(0.8f + (float)this.getTntTimer() / 300.0f));
                int t = this.getTntTimer() + 1;
                this.setTntTimer(t);
                if (t >= 100 || this.m_21224_()) {
                    Level level = this.m_9236_();
                    if (!level.f_46443_) {
                        level.m_254849_((Entity)this, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 2.0f, Level.ExplosionInteraction.MOB);
                        this.m_6469_(this.m_269291_().m_269036_((Entity)this, null), Float.MAX_VALUE);
                        this.m_146870_();
                    }
                }
            } else {
                float amount = 0.0f;
                for (ItemStack itemStack : ((SimpleContainerAccessor)this.m_35311_()).getItems()) {
                    if (itemStack.m_41619_()) {
                        amount -= 0.1f;
                    }
                    amount += 0.1f;
                }
                if (amount > 0.8f) {
                    amount = 0.8f;
                }
                this.f_19804_.m_135381_(PUFF_TICKS, (Object)Float.valueOf(amount));
            }
        }
        super.m_8119_();
    }

    private void convertToDriedBlock() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        this.convertingToDriedBlock = true;
        BlockPos pos = this.m_20183_();
        Direction facing = this.m_6350_().m_122424_();
        BlockState newState = (BlockState)((BlockState)((Block)SpawnBlocks.DRIED_HAMSTER.get()).m_49966_().m_61124_((Property)DriedHamsterBlock.FACING, (Comparable)facing)).m_61124_((Property)DriedHamsterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(this.m_5842_()));
        CompoundTag hamsterNbt = new CompoundTag();
        this.m_20240_(hamsterNbt);
        hamsterNbt = Hamster.sanitizeForStorage(hamsterNbt);
        server.m_7731_(pos, newState, 3);
        BlockEntity be = server.m_7702_(pos);
        if (be instanceof DriedHamsterBlockEntity) {
            DriedHamsterBlockEntity dh = (DriedHamsterBlockEntity)be;
            dh.setHamsterData(hamsterNbt);
            dh.m_6596_();
        }
        this.m_6469_(this.m_269291_().m_269079_(SpawnDamageTypes.DRY_UP), Float.MAX_VALUE);
        this.m_146870_();
        this.convertingToDriedBlock = false;
    }

    public static CompoundTag sanitizeForStorage(CompoundTag in) {
        CompoundTag nbt = in.m_6426_();
        nbt.m_128473_("Pos");
        nbt.m_128473_("Motion");
        nbt.m_128473_("Rotation");
        nbt.m_128473_("FallDistance");
        nbt.m_128473_("OnGround");
        nbt.m_128473_("UUIDLeast");
        nbt.m_128473_("PortalCooldown");
        nbt.m_128473_("Dimension");
        nbt.m_128473_("Fire");
        nbt.m_128473_("TicksFrozen");
        nbt.m_128473_("HurtByTimestamp");
        nbt.m_128473_("LeftHanded");
        nbt.m_128473_("NoGravity");
        nbt.m_128473_("Invulnerable");
        nbt.m_128473_("Hydration");
        return nbt;
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    protected void m_7581_(ItemEntity itemEntity) {
        if (this.m_35311_().m_19183_(itemEntity.m_32055_())) {
            this.m_5496_((SoundEvent)SpawnSoundEvents.HAMSTER_EAT.get(), 1.0f, 1.0f);
        }
        InventoryCarrier.m_219611_((Mob)this, (InventoryCarrier)this, (ItemEntity)itemEntity);
    }

    protected void m_5907_() {
        if (this.convertingToDriedBlock) {
            return;
        }
        super.m_5907_();
        this.inventory.m_19195_().forEach(arg_0 -> ((Hamster)this).m_19983_(arg_0));
    }

    protected int m_5639_(float f, float g) {
        return super.m_5639_(f, g) - 10;
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.hasEatenTnt();
    }

    boolean canMove() {
        return !this.isStanding() && !this.m_21825_() && !this.m_6107_() && !this.isInWheel();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)this.getDefaultVariant().toString());
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(PUFF_TICKS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(HAS_EATEN_TNT, (Object)false);
        this.f_19804_.m_135372_(TNT_TIMER, (Object)0);
        this.f_19804_.m_135372_(YAWNING_TIMER, (Object)0);
        this.f_19804_.m_135372_(WHEEL_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(IN_WHEEL, (Object)false);
        this.f_19804_.m_135372_(HYDRATION, (Object)20);
    }

    public void m_7105_(boolean bl) {
        super.m_7105_(bl);
        if (bl) {
            this.m_21051_(Attributes.f_22276_).m_22100_(12.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(6.0);
        }
    }

    public boolean isStanding() {
        return this.getFlag(1);
    }

    public void setStanding(boolean bl) {
        this.setFlag(1, bl);
    }

    public boolean isInWheel() {
        return (Boolean)this.f_19804_.m_135370_(IN_WHEEL);
    }

    public void setInWheel(boolean v) {
        this.m_20242_(v);
        this.f_19804_.m_135381_(IN_WHEEL, (Object)v);
    }

    private void setFlag(int i, boolean bl) {
        if (bl) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) | i)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & ~i)));
        }
    }

    private boolean getFlag(int i) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & i) != 0;
    }

    @Override
    public void setVariant(ResourceLocation resourceLocation) {
        this.f_19804_.m_135381_(VARIANT, (Object)resourceLocation.toString());
    }

    @Override
    public ResourceLocation getVariant() {
        return ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(VARIANT)));
    }

    @Override
    public ResourceLocation getDefaultVariant() {
        return new ResourceLocation("spawn", "russian");
    }

    public void m_5757_(Container container) {
    }

    public void m_213583_(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.f_36096_ != serverPlayer.f_36095_) {
                serverPlayer.m_6915_();
            }
            serverPlayer.m_9217_();
            SpawnNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new OpenHamsterScreenPacket(serverPlayer.f_8940_, this.m_35311_().m_6643_(), this.m_19879_()));
            serverPlayer.f_36096_ = new HamsterInventoryMenu(serverPlayer.f_8940_, serverPlayer.m_150109_(), (Container)this.inventory, this);
            serverPlayer.m_143399_(serverPlayer.f_36096_);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)serverPlayer, serverPlayer.f_36096_));
        }
    }

    protected @Nullable SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpawnSoundEvents.HAMSTER_HURT.get();
    }

    protected @Nullable SoundEvent m_7515_() {
        return this.isStanding() ? (SoundEvent)SpawnSoundEvents.HAMSTER_AMBIENT_CALL.get() : (SoundEvent)SpawnSoundEvents.HAMSTER_AMBIENT.get();
    }

    protected @Nullable SoundEvent m_5592_() {
        return (SoundEvent)SpawnSoundEvents.HAMSTER_DEATH.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_((SoundEvent)SpawnSoundEvents.HAMSTER_STEP.get(), 0.15f, 1.0f);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.m_252802_(tag);
        tag.m_128359_("Variant", this.getVariant().toString());
        tag.m_128379_("Standing", this.isStanding());
        if (this.getVariantScale() != 1.0f) {
            tag.m_128350_("VariantScale", this.getVariantScale());
        }
        tag.m_128379_("HasEatenTnt", this.hasEatenTnt());
        tag.m_128405_("TntTimer", this.getTntTimer());
        tag.m_128405_("YawningTimer", this.getYawningTimer());
        tag.m_128379_("InWheel", this.isInWheel());
        tag.m_128405_("WheelCooldown", this.getWheelCooldown());
        tag.m_128405_("Hydration", this.getHydration());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_253224_(tag);
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
        this.setStanding(tag.m_128471_("Standing"));
        if (tag.m_128441_("HasEatenTnt")) {
            this.setHasEatenTnt(tag.m_128471_("HasEatenTnt"));
        }
        if (tag.m_128441_("TntTimer")) {
            this.setTntTimer(tag.m_128451_("TntTimer"));
        }
        if (tag.m_128441_("YawningTimer")) {
            this.setYawningTimer(tag.m_128451_("YawningTimer"));
        }
        if (tag.m_128441_("InWheel")) {
            this.setInWheel(tag.m_128471_("InWheel"));
        }
        if (tag.m_128441_("WheelCooldown")) {
            this.setWheelCooldown(tag.m_128451_("WheelCooldown"));
        }
        if (tag.m_128441_("Hydration")) {
            this.setHydration(tag.m_128451_("Hydration"));
        }
    }

    public int getHydration() {
        return (Integer)this.f_19804_.m_135370_(HYDRATION);
    }

    public void setHydration(int v) {
        this.f_19804_.m_135381_(HYDRATION, (Object)Math.max(0, Math.min(20, v)));
    }

    public boolean hasEatenTnt() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EATEN_TNT);
    }

    public void setHasEatenTnt(boolean value) {
        this.f_19804_.m_135381_(HAS_EATEN_TNT, (Object)value);
    }

    public int getTntTimer() {
        return (Integer)this.f_19804_.m_135370_(TNT_TIMER);
    }

    public void setTntTimer(int ticks) {
        this.f_19804_.m_135381_(TNT_TIMER, (Object)ticks);
    }

    public int getYawningTimer() {
        return (Integer)this.f_19804_.m_135370_(YAWNING_TIMER);
    }

    public void setYawningTimer(int ticks) {
        this.f_19804_.m_135381_(YAWNING_TIMER, (Object)ticks);
    }

    public int getWheelCooldown() {
        return (Integer)this.f_19804_.m_135370_(WHEEL_COOLDOWN);
    }

    public void setWheelCooldown(int ticks) {
        this.f_19804_.m_135381_(WHEEL_COOLDOWN, (Object)ticks);
    }

    public float getSwelling(float partialTick) {
        if (!this.hasEatenTnt()) {
            return 0.0f;
        }
        int fuseTicksTotal = 100;
        float t = ((float)this.getTntTimer() + partialTick) / 100.0f;
        t = Mth.m_14036_((float)t, (float)0.0f, (float)1.0f);
        return t;
    }

    @Override
    public void setVariantScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    @Override
    public float getVariantScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    public static boolean canSpawn(EntityType<Hamster> hamsterEntityType, ServerLevelAccessor world, MobSpawnType mobSpawnType, BlockPos pos, RandomSource randomSource) {
        return world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) && Animal.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public @Nullable Hamster getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        Hamster hamster = (Hamster)((EntityType)SpawnEntityType.HAMSTER.get()).m_20615_((Level)serverLevel);
        if (hamster != null && ageableMob instanceof Hamster) {
            Hamster hamster2 = (Hamster)ageableMob;
            if (this.f_19796_.m_188499_()) {
                hamster.setVariant(this.getVariant());
            } else {
                hamster.setVariant(hamster2.getVariant());
            }
            if (this.m_21824_()) {
                hamster.m_21816_(this.m_21805_());
                hamster.m_7105_(true);
            }
        }
        return hamster;
    }

    class HamsterMoveControl
    extends MoveControl {
        public HamsterMoveControl() {
            super((Mob)Hamster.this);
        }

        public void m_8126_() {
            if (Hamster.this.canMove()) {
                super.m_8126_();
            }
        }
    }

    class HamsterEatPrimedTntGoal
    extends Goal {
        private final double followRange;
        private final double speed;
        private PrimedTnt target;

        HamsterEatPrimedTntGoal(double followRange, double speed) {
            this.followRange = followRange;
            this.speed = speed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (Hamster.this.hasEatenTnt() || !Hamster.this.canMove()) {
                return false;
            }
            if (Hamster.this.m_5448_() != null) {
                return false;
            }
            List list = Hamster.this.m_9236_().m_45976_(PrimedTnt.class, Hamster.this.m_20191_().m_82377_(this.followRange, 6.0, this.followRange));
            if (list.isEmpty()) {
                return false;
            }
            list.sort(Comparator.comparingDouble(a -> a.m_20280_((Entity)Hamster.this)));
            this.target = (PrimedTnt)list.get(0);
            return this.target != null && this.target.m_6084_();
        }

        public boolean m_8045_() {
            return !Hamster.this.hasEatenTnt() && this.target != null && this.target.m_6084_() && Hamster.this.canMove();
        }

        public void m_8056_() {
            if (this.target != null) {
                Hamster.this.m_21573_().m_5624_((Entity)this.target, this.speed);
            }
        }

        public void m_8041_() {
            this.target = null;
            Hamster.this.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (this.target == null) {
                return;
            }
            Hamster.this.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            Hamster.this.m_21573_().m_5624_((Entity)this.target, this.speed);
            double distSqr = Hamster.this.m_20280_((Entity)this.target);
            if (distSqr <= 2.25 && !Hamster.this.m_9236_().f_46443_) {
                this.target.m_146870_();
                Hamster.this.m_5496_((SoundEvent)SpawnSoundEvents.HAMSTER_EAT.get(), 1.0f, 0.9f + Hamster.this.m_217043_().m_188501_() * 0.2f);
                Hamster.this.m_9236_().m_5594_(null, Hamster.this.m_20183_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 0.5f);
                Hamster.this.setHasEatenTnt(true);
                Hamster.this.setTntTimer(0);
                Hamster.this.f_19804_.m_135381_(PUFF_TICKS, (Object)Float.valueOf(0.8f));
                Hamster.this.m_21573_().m_26573_();
            }
        }
    }

    public static class HamsterRunInWheelGoal
    extends Goal {
        private final Hamster hamster;
        private @Nullable HamsterWheelBlockEntity targetWheel;
        private BlockPos wheelPos;
        private boolean running;

        public HamsterRunInWheelGoal(Hamster hamster) {
            this.hamster = hamster;
        }

        public boolean m_8036_() {
            if (!this.hamster.canMove() || this.hamster.getWheelCooldown() > 0) {
                return false;
            }
            BlockPos origin = this.hamster.m_20183_();
            HamsterWheelBlockEntity best = null;
            double bestDist = 1.44;
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)origin.m_7918_(-1, -1, -1), (BlockPos)origin.m_7918_(1, 1, 1))) {
                double distance;
                BlockEntity blockEntity = this.hamster.m_9236_().m_7702_(pos);
                if (!(blockEntity instanceof HamsterWheelBlockEntity)) continue;
                HamsterWheelBlockEntity wheel = (HamsterWheelBlockEntity)blockEntity;
                BlockState state = this.hamster.m_9236_().m_8055_(pos);
                if (((Boolean)state.m_61143_((Property)HamsterWheelBlock.POWERED)).booleanValue() || !wheel.isFree() || !((distance = pos.m_252807_().m_82557_(this.hamster.m_20182_())) <= bestDist)) continue;
                best = wheel;
                bestDist = distance;
            }
            if (best != null) {
                this.targetWheel = best;
                this.wheelPos = best.m_58899_();
                return true;
            }
            return false;
        }

        public void m_8056_() {
            this.running = false;
            this.hamster.setInWheel(true);
            this.snapToCenter();
            if (!this.hamster.m_9236_().f_46443_ && this.targetWheel != null) {
                this.running = this.targetWheel.tryBeginRun((Animal)this.hamster, 120 + this.hamster.m_217043_().m_188503_(400));
            }
            this.hamster.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (this.targetWheel == null) {
                return;
            }
            this.snapToCenter();
        }

        public boolean m_8045_() {
            if (this.targetWheel == null || !this.hamster.m_6084_() || this.hamster.getWheelCooldown() > 0) {
                return false;
            }
            if (this.hamster.m_9236_().m_7702_(this.wheelPos) != this.targetWheel) {
                return false;
            }
            return !this.targetWheel.isFree() && this.hamster.m_20238_(this.wheelPos.m_252807_()) < 2.25;
        }

        public void m_8041_() {
            this.targetWheel = null;
            this.hamster.setInWheel(false);
            this.hamster.setWheelCooldown(100 + this.hamster.m_9236_().f_46441_.m_188503_(1100));
        }

        private void snapToCenter() {
            if (this.wheelPos == null || this.targetWheel == null) {
                return;
            }
            Vec3 center = this.wheelPos.m_252807_();
            Direction direction = (Direction)this.targetWheel.m_58900_().m_61143_((Property)HamsterWheelBlock.FACING);
            double inset = 0.1;
            double px = center.f_82479_ + (double)direction.m_122427_().m_122431_() * inset;
            double py = center.f_82480_ - 0.25;
            double pz = center.f_82481_ - (double)direction.m_122427_().m_122429_() * inset - (double)((float)direction.m_122427_().m_122431_() * 0.025f);
            this.hamster.m_20334_(0.0, 0.0, 0.0);
            this.hamster.m_146922_(direction.m_122428_().m_122435_());
            this.hamster.m_5616_(this.hamster.m_146908_());
            this.hamster.m_5618_(this.hamster.m_146908_());
            this.hamster.m_6027_(px, py, pz);
            this.hamster.m_21563_().m_24946_(px + (double)direction.m_122428_().m_122429_(), center.f_82480_ + 0.25, pz + (double)direction.m_122428_().m_122431_());
        }
    }

    class HamsterSearchForItemsGoal
    extends Goal {
        public HamsterSearchForItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (Hamster.this.m_5448_() != null || Hamster.this.m_21188_() != null) {
                return false;
            }
            if (!Hamster.this.canMove()) {
                return false;
            }
            if (Hamster.this.m_217043_().m_188503_(HamsterSearchForItemsGoal.m_186073_((int)10)) != 0) {
                return false;
            }
            List list = Hamster.this.m_9236_().m_6443_(ItemEntity.class, Hamster.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            return !list.isEmpty() && Hamster.this.m_35311_().m_19183_(((ItemEntity)list.get(0)).m_32055_());
        }

        public void m_8037_() {
            List list = Hamster.this.m_9236_().m_6443_(ItemEntity.class, Hamster.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (Hamster.this.m_35311_().m_19183_(((ItemEntity)list.get(0)).m_32055_()) && !list.isEmpty()) {
                Hamster.this.m_21573_().m_5624_((Entity)list.get(0), 1.0);
            }
        }

        public void m_8056_() {
            List list = Hamster.this.m_9236_().m_6443_(ItemEntity.class, Hamster.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                Hamster.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    public class HamsterSeekWheelGoal
    extends MoveToBlockGoal {
        private @Nullable BlockPos targetWheelPos;

        public HamsterSeekWheelGoal(double speedModifier, int searchRange, int verticalSearchRange) {
            super((PathfinderMob)Hamster.this, speedModifier, searchRange, verticalSearchRange);
        }

        public boolean m_8036_() {
            if (!Hamster.this.canMove() || Hamster.this.getWheelCooldown() > 0) {
                return false;
            }
            if (Hamster.this.m_217043_().m_188501_() > 0.02f) {
                return false;
            }
            return super.m_8036_();
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof HamsterWheelBlockEntity)) {
                return false;
            }
            HamsterWheelBlockEntity wheel = (HamsterWheelBlockEntity)blockEntity;
            BlockState state = level.m_8055_(pos);
            if (!state.m_60713_((Block)SpawnBlocks.HAMSTER_WHEEL.get())) {
                return false;
            }
            if (((Boolean)state.m_61143_((Property)HamsterWheelBlock.POWERED)).booleanValue()) {
                return false;
            }
            if (!wheel.isFree()) {
                return false;
            }
            this.targetWheelPos = pos.m_7949_();
            return true;
        }

        protected boolean m_25625_() {
            return this.f_25602_.m_252807_().m_82520_(0.0, 0.75, 0.0).m_82509_((Position)Hamster.this.m_20182_(), 0.9);
        }

        protected void m_25624_() {
            Hamster.this.m_21573_().m_26519_((double)this.f_25602_.m_123341_() + 0.5, (double)this.f_25602_.m_123342_() + 0.75, (double)this.f_25602_.m_123343_() + 0.5, this.f_25599_);
        }

        public boolean m_8045_() {
            if (!super.m_8045_() || Hamster.this.getWheelCooldown() > 0 || Hamster.this.canMove()) {
                return false;
            }
            if (this.targetWheelPos == null) {
                return false;
            }
            BlockEntity be = Hamster.this.m_9236_().m_7702_(this.targetWheelPos);
            if (!(be instanceof HamsterWheelBlockEntity)) {
                return false;
            }
            HamsterWheelBlockEntity wheel = (HamsterWheelBlockEntity)be;
            return wheel.isFree() && (Boolean)Hamster.this.m_9236_().m_8055_(this.targetWheelPos).m_61143_((Property)HamsterWheelBlock.POWERED) == false;
        }

        public void m_8041_() {
            super.m_8041_();
            this.targetWheelPos = null;
        }
    }

    class StandGoal
    extends Goal {
        public StandGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return Hamster.this.m_21188_() == null && Hamster.this.m_217043_().m_188501_() < 0.02f && Hamster.this.standingTicks == 0 && Hamster.this.m_5448_() == null && !Hamster.this.isInWheel() && Hamster.this.m_21573_().m_26571_();
        }

        public boolean m_8045_() {
            return Hamster.this.standingTicks > 0 && !Hamster.this.isInWheel();
        }

        public void m_8056_() {
            Hamster.this.standingTicks = 20 * (10 + Hamster.this.m_217043_().m_188503_(5));
            Hamster.this.setStanding(true);
            Hamster.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            Hamster.this.setStanding(false);
        }
    }
}

