/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity;

import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.ai.goal.BoidFishSchoolingGoal;
import com.ninni.spawn.server.entity.ai.goal.HeightBoundsGoal;
import com.ninni.spawn.server.entity.ai.goal.LimitSpeedAndLookInVelocityDirectionGoal;
import com.ninni.spawn.server.entity.ai.goal.OrganizeBoidSchoolingGoal;
import com.ninni.spawn.server.entity.common.BoidFishEntity;
import com.ninni.spawn.server.entity.common.JsonVariantHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Herring
extends BoidFishEntity
implements JsonVariantHolder {
    private static final EntityDataAccessor<Integer> SCHOOL_SIZE = SynchedEntityData.m_135353_(Herring.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.m_135353_(Herring.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(Herring.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public Herring(EntityType<? extends BoidFishEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    @Override
    public @Nullable SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (mobSpawnType != MobSpawnType.BUCKET) {
            if (spawnGroupData == null) {
                int size = this.f_19796_.m_188503_(20) + 10;
                this.setSchoolSize(size);
                this.SetMaxSchoolSize(size);
            }
            AnimalVariantManager.getNaturallyOccurringVariant((LivingEntity)this);
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new OrganizeBoidSchoolingGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new BoidFishSchoolingGoal(this, 0.2f, 0.4f, 0.4f, 0.05f));
        this.f_21345_.m_25352_(2, (Goal)new HeightBoundsGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LimitSpeedAndLookInVelocityDirectionGoal(this, 0.65f));
        this.f_21345_.m_25352_(6, (Goal)new BoidFishEntity.FishSwimGoal(this));
    }

    public static AttributeSupplier.Builder m_27495_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getMaxSchoolSize() != this.getSchoolSize()) {
            this.SetMaxSchoolSize(this.getSchoolSize());
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SCHOOL_SIZE, (Object)0);
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)this.getDefaultVariant().toString());
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("SchoolSize", this.getSchoolSize());
        tag.m_128359_("Variant", this.getVariant().toString());
        if (this.getVariantScale() != 1.0f) {
            tag.m_128350_("VariantScale", this.getVariantScale());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setSchoolSize(tag.m_128451_("SchoolSize"));
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
    }

    public void m_6872_(ItemStack itemStack) {
        super.m_6872_(itemStack);
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_("SchoolSize", this.getSchoolSize());
        tag.m_128359_("Variant", this.getVariant().toString());
        if (this.getVariantScale() != 1.0f) {
            tag.m_128350_("VariantScale", this.getVariantScale());
        }
    }

    public void m_142278_(CompoundTag tag) {
        super.m_142278_(tag);
        if (tag.m_128441_("SchoolSize")) {
            this.setSchoolSize(tag.m_128451_("SchoolSize"));
        } else {
            int size = this.f_19796_.m_188503_(20) + 30;
            this.setSchoolSize(size);
            this.SetMaxSchoolSize(size);
        }
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
    }

    @Override
    public void setVariantScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    @Override
    public float getVariantScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    @Override
    public void setVariant(ResourceLocation resourceLocation) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)resourceLocation.toString());
    }

    @Override
    public ResourceLocation getVariant() {
        return ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(DATA_VARIANT)));
    }

    @Override
    public ResourceLocation getDefaultVariant() {
        return new ResourceLocation("spawn", "blue");
    }

    public void setSchoolSize(int i) {
        this.f_19804_.m_135381_(SCHOOL_SIZE, (Object)i);
        this.SetMaxSchoolSize(i);
    }

    public int getSchoolSize() {
        return (Integer)this.f_19804_.m_135370_(SCHOOL_SIZE);
    }

    public int m_5792_() {
        return 50;
    }

    @Override
    public int getMaxSchoolSize() {
        return this.getSchoolSize();
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)SpawnItems.HERRING_BUCKET.get());
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_271165_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SpawnSoundEvents.FISH_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpawnSoundEvents.FISH_HURT.get();
    }

    protected SoundEvent m_5699_() {
        return (SoundEvent)SpawnSoundEvents.FISH_FLOP.get();
    }
}

