/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity;

import com.ninni.spawn.registry.SpawnBlocks;
import com.ninni.spawn.registry.SpawnCriteriaTriggers;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.registry.SpawnTags;
import com.ninni.spawn.server.block.OctoductBlock;
import com.ninni.spawn.server.block.entity.OctoductBlockEntity;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.common.Catchable;
import com.ninni.spawn.server.entity.common.CustomInventoryPose;
import com.ninni.spawn.server.entity.common.JsonVariantHolder;
import com.ninni.spawn.server.entity.common.PathFindingFavors;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Octopus
extends PathfinderMob
implements JsonVariantHolder,
Catchable,
CustomInventoryPose,
PathFindingFavors {
    private static final EntityDataAccessor<Boolean> HAS_BEEN_CAUGHT = SynchedEntityData.m_135353_(Octopus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> LOCKED_CHEST = SynchedEntityData.m_135353_(Octopus.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.m_135353_(Octopus.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> IS_WALKING_SEAFLOOR = SynchedEntityData.m_135353_(Octopus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SEAFLOOR_TOGGLE_COOLDOWN = SynchedEntityData.m_135353_(Octopus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(Octopus.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public boolean isRenderedInTooltip = false;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState waterIdleAnimationState = new AnimationState();
    public final AnimationState enterDuctAnimationState = new AnimationState();
    public final AnimationState exitDuctAnimationState = new AnimationState();
    public int enterExitCooldown = 0;
    private int idleAnimationTimeout = 0;
    private int waterIdleAnimationTimeout = 0;
    public static final byte EVENT_PLAY_ENTER_ANIMATION = 8;
    public static final byte EVENT_PLAY_EXIT_ANIMATION = 9;
    public static final byte EVENT_STOP_ENTER_ANIMATION = 10;

    public Octopus(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_274367_(1.0f);
        this.f_21342_ = new OctopusMoveControl(this);
        this.f_21365_ = new OctopusLookControl(this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new OctopusEnterDuctGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new OctopusSeekDuctGoal(1.0, 12, 12));
        this.f_21345_.m_25352_(6, (Goal)new OctopusRandomStroll(this));
        this.f_21345_.m_25352_(6, (Goal)new OctopusRandomSwim(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public @Nullable SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (mobSpawnType != MobSpawnType.BUCKET) {
            AnimalVariantManager.getNaturallyOccurringVariant((LivingEntity)this);
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    public void m_7822_(byte id) {
        if (id == 8) {
            this.enterDuctAnimationState.m_216977_(this.f_19797_);
            return;
        }
        if (id == 9) {
            this.exitDuctAnimationState.m_216977_(this.f_19797_);
            return;
        }
        if (id == 10) {
            this.enterDuctAnimationState.m_216973_();
            return;
        }
        super.m_7822_(id);
    }

    public InteractionResult m_7111_(Player player, Vec3 vec3, InteractionHand hand) {
        ItemStack handStack = player.m_21120_(hand);
        if (this.m_6084_() && this.canBeCatched(handStack)) {
            ItemStack usedStack;
            if (handStack.m_150930_(Items.f_42715_) && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SpawnCriteriaTriggers.CATCH_OCTOPUS_IN_NAUTILUS_SHELL.trigger(serverPlayer);
            }
            boolean hadMultiple = handStack.m_41613_() > 1;
            ItemStack cleanRemaining = ItemStack.f_41583_;
            if (hadMultiple) {
                cleanRemaining = handStack.m_41777_();
                cleanRemaining.m_41764_(handStack.m_41613_() - 1);
                usedStack = handStack.m_41777_();
                usedStack.m_41764_(1);
                handStack.m_41774_(1);
            } else {
                usedStack = handStack;
            }
            CompoundTag tag = new CompoundTag();
            CompoundTag innerTag = new CompoundTag();
            usedStack.m_41739_(innerTag);
            tag.m_128365_("Item", (Tag)innerTag);
            InteractionResult result = Catchable.catchWithItem(player, hand, this, tag).orElse(super.m_7111_(player, vec3, hand));
            if (hadMultiple && !cleanRemaining.m_41619_() && !player.m_36356_(cleanRemaining)) {
                player.m_36176_(cleanRemaining, false);
            }
            return result;
        }
        return super.m_7111_(player, vec3, hand);
    }

    @Override
    public @Nullable ItemStack getCaughtItem(ItemStack capturingItem) {
        if (capturingItem.m_204117_(ItemTags.f_13158_)) {
            return ((Item)SpawnItems.MUSIC_DISC_JAMMED.get()).m_7968_();
        }
        return ((Item)SpawnItems.CAPTURED_OCTOPUS.get()).m_7968_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.enterExitCooldown > 0) {
            --this.enterExitCooldown;
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
            if (!this.m_20072_() && this.f_19796_.m_188503_(10) == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123804_, this.m_20208_(0.6), this.m_20186_() + this.f_19796_.m_188500_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
            }
        } else {
            this.m_20242_(this.isLocking());
            if (this.m_20072_() && !this.isLocking()) {
                if (this.getSeafloorToggleCooldown() > 0) {
                    this.setSeafloorToggleCooldown(this.getSeafloorToggleCooldown() - 1);
                }
                if (this.getSeafloorToggleCooldown() == 0 && this.f_19796_.m_188501_() < 0.02f) {
                    boolean currentlyWalking = this.isWalkingSeafloor();
                    this.setWalkingSeafloor(!currentlyWalking);
                    this.setSeafloorToggleCooldown(this.f_19796_.m_188503_(400) + 400);
                }
                if (this.isWalkingSeafloor() && this.getSeafloorToggleCooldown() > 20) {
                    this.m_246865_(new Vec3(0.0, -0.025, 0.0));
                } else {
                    this.m_246865_(new Vec3(0.0, 0.0015, 0.0));
                }
            }
            if (this.isLocking()) {
                BlockState state = this.m_9236_().m_8055_(this.getLockingPos());
                BlockPos pos = new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_());
                if (!(state.m_60734_() instanceof ChestBlock) || state.m_60734_() instanceof ChestBlock && state.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE) {
                    this.stopLocking();
                } else {
                    if (!pos.equals((Object)this.getLockingPos())) {
                        this.m_6034_((float)this.getLockingPos().m_123341_() + 0.5f, this.getLockingPos().m_123342_(), (float)this.getLockingPos().m_123343_() + 0.5f);
                    }
                    if (this.m_6080_() != ((Direction)state.m_61143_((Property)ChestBlock.f_51478_)).m_122435_()) {
                        this.m_5616_(((Direction)state.m_61143_((Property)ChestBlock.f_51478_)).m_122435_());
                    }
                }
            }
        }
    }

    private void setupAnimationStates() {
        if (!this.m_20072_() || this.m_20072_() && this.isWalkingSeafloor()) {
            if (this.idleAnimationTimeout == 0) {
                this.idleAnimationTimeout = 160;
                this.idleAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.idleAnimationTimeout;
            }
        } else {
            this.idleAnimationState.m_216973_();
        }
        if (this.m_20072_() && !this.m_20096_()) {
            if (this.waterIdleAnimationTimeout == 0) {
                this.waterIdleAnimationTimeout = 160;
                this.waterIdleAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.waterIdleAnimationTimeout;
            }
        } else {
            this.waterIdleAnimationState.m_216973_();
        }
    }

    public void m_7023_(Vec3 vec3) {
        if (!this.isLocking() && this.enterExitCooldown == 0) {
            if (this.m_21515_() && this.m_20069_()) {
                this.m_19920_(this.m_6113_(), vec3);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (!this.isWalkingSeafloor()) {
                    this.m_20256_(this.m_20184_().m_82490_(0.9));
                } else {
                    this.m_20256_(this.m_20184_().m_82490_(0.5));
                }
            } else {
                super.m_7023_(vec3);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float f) {
        if (this.isLocking() && !source.m_269533_(DamageTypeTags.f_268745_) && !source.m_269533_(DamageTypeTags.f_268725_) && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        if (this.m_20072_()) {
            this.setWalkingSeafloor(false);
            this.setSeafloorToggleCooldown(400);
            for (int i = 0; i < 30; ++i) {
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123765_, this.m_20182_().f_82479_ + this.f_19796_.m_188583_() * 0.5, this.m_20182_().f_82480_ - 0.5 + this.f_19796_.m_188583_() * 0.5, this.m_20182_().f_82481_ + this.f_19796_.m_188583_() * 0.5, 0, 0.0, 0.0, 0.0, (double)0.1f);
            }
            this.m_5496_((SoundEvent)SpawnSoundEvents.OCTOPUS_SQUIRT.get(), 1.0f, 1.0f);
        }
        return super.m_6469_(source, f);
    }

    public float m_5610_(BlockPos blockPos, LevelReader levelReader) {
        return !this.isWalkingSeafloor() && this.m_20072_() ? this.getDepthPathfindingFavor(blockPos, levelReader) : super.m_5610_(blockPos, levelReader);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_BEEN_CAUGHT, (Object)false);
        this.f_19804_.m_135372_(LOCKED_CHEST, Optional.empty());
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)this.getDefaultVariant().toString());
        this.f_19804_.m_135372_(IS_WALKING_SEAFLOOR, (Object)false);
        this.f_19804_.m_135372_(SEAFLOOR_TOGGLE_COOLDOWN, (Object)this.f_19796_.m_188503_(400));
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("HasBeenCaught", this.hasBeenCaught());
        if (this.isLocking()) {
            tag.m_128365_("LockedChestPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getLockingPos()));
        }
        tag.m_128359_("Variant", this.getVariant().toString());
        tag.m_128379_("WalkingSeafloor", this.isWalkingSeafloor());
        tag.m_128405_("SeafloorToggleCooldown", this.getSeafloorToggleCooldown());
        if (this.getVariantScale() != 1.0f) {
            tag.m_128350_("VariantScale", this.getVariantScale());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setHasBeenCaught(tag.m_128471_("HasBeenCaught"));
        this.setWalkingSeafloor(tag.m_128471_("WalkingSeafloor"));
        this.setSeafloorToggleCooldown(tag.m_128451_("SeafloorToggleCooldown"));
        if (tag.m_128425_("LockedChestPos", 10)) {
            this.setLockingPos(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("LockedChestPos")));
        }
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
    }

    @Override
    public void saveDataToTag(Mob mob, CompoundTag tag) {
        Catchable.super.saveDataToTag(mob, tag);
        tag.m_128362_("UUID", this.m_20148_());
        tag.m_128359_("Variant", this.getVariant().toString());
        if (this.getVariantScale() != 1.0f) {
            tag.m_128350_("VariantScale", this.getVariantScale());
        }
    }

    @Override
    public void loadDataFromTag(Mob mob, CompoundTag tag) {
        Catchable.super.loadDataFromTag(mob, tag);
        if (tag.m_128441_("UUID")) {
            this.m_20084_(tag.m_128342_("UUID"));
        }
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
    }

    @Override
    public void setVariantScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    @Override
    public float getVariantScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    @Override
    public void setVariant(ResourceLocation resourceLocation) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)resourceLocation.toString());
    }

    @Override
    public ResourceLocation getVariant() {
        return ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(DATA_VARIANT)));
    }

    @Override
    public ResourceLocation getDefaultVariant() {
        return new ResourceLocation("spawn", "beetroot");
    }

    public boolean isWalkingSeafloor() {
        return (Boolean)this.f_19804_.m_135370_(IS_WALKING_SEAFLOOR);
    }

    public void setWalkingSeafloor(boolean bl) {
        this.f_19804_.m_135381_(IS_WALKING_SEAFLOOR, (Object)bl);
    }

    public int getSeafloorToggleCooldown() {
        return (Integer)this.f_19804_.m_135370_(SEAFLOOR_TOGGLE_COOLDOWN);
    }

    public void setSeafloorToggleCooldown(int cooldown) {
        this.f_19804_.m_135381_(SEAFLOOR_TOGGLE_COOLDOWN, (Object)cooldown);
    }

    @Override
    public boolean hasBeenCaught() {
        return (Boolean)this.f_19804_.m_135370_(HAS_BEEN_CAUGHT);
    }

    @Override
    public void setHasBeenCaught(boolean bl) {
        this.f_19804_.m_135381_(HAS_BEEN_CAUGHT, (Object)bl);
    }

    @Override
    public boolean isRenderedInTooltip() {
        return this.isRenderedInTooltip;
    }

    @Override
    public void setIsRenderedInTooltip(boolean bl) {
        this.isRenderedInTooltip = bl;
    }

    @Override
    public boolean canBeCatched(@Nullable ItemStack stack) {
        return !this.isLocking() && (stack == null || stack.m_204117_(SpawnTags.CATCHES_OCTOPUS) || stack.m_204117_(ItemTags.f_13158_));
    }

    public boolean isLocking() {
        return ((Optional)this.f_19804_.m_135370_(LOCKED_CHEST)).isPresent();
    }

    public void stopLocking() {
        this.f_19804_.m_135381_(LOCKED_CHEST, Optional.empty());
    }

    public void setLockingPos(@Nullable BlockPos blockPos) {
        this.m_20088_().m_135381_(LOCKED_CHEST, Optional.ofNullable(blockPos));
    }

    public @Nullable BlockPos getLockingPos() {
        return ((Optional)this.m_20088_().m_135370_(LOCKED_CHEST)).orElse(null);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.5f;
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6914_(LevelReader levelReader) {
        return levelReader.m_45784_((Entity)this);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.hasBeenCaught() || this.isLocking();
    }

    public int m_21529_() {
        return this.m_20072_() ? 35 : 10;
    }

    public int m_8085_() {
        return this.m_20072_() ? 5 : 75;
    }

    public int m_8132_() {
        return this.m_20072_() ? 1 : 40;
    }

    public int m_8100_() {
        return 120;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)SpawnSoundEvents.OCTOPUS_STEP.get(), 0.15f, 1.0f);
    }

    protected @Nullable SoundEvent m_7515_() {
        return this.isLocking() ? null : (SoundEvent)SpawnSoundEvents.OCTOPUS_AMBIENT.get();
    }

    protected @Nullable SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpawnSoundEvents.OCTOPUS_HURT.get();
    }

    protected @Nullable SoundEvent m_5592_() {
        return (SoundEvent)SpawnSoundEvents.OCTOPUS_DEATH.get();
    }

    @Override
    public SoundEvent getPickupSound() {
        return (SoundEvent)SpawnSoundEvents.OCTOPUS_COLLECT.get();
    }

    @Override
    public SoundEvent getReleaseSound() {
        return (SoundEvent)SpawnSoundEvents.OCTOPUS_PLACE.get();
    }

    protected PathNavigation m_6037_(Level world) {
        return new AmphibiousPathNavigation((Mob)this, world);
    }

    public static boolean checkSurfaceWaterAnimalSpawnRules(EntityType<Octopus> mobEntityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        int i = levelAccessor.m_5736_();
        int j = i - 13;
        return blockPos.m_123342_() >= j && blockPos.m_123342_() <= i && levelAccessor.m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_) && levelAccessor.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    static class OctopusMoveControl
    extends SmoothSwimmingMoveControl {
        private final Octopus octopus;

        public OctopusMoveControl(Octopus octopus) {
            super((Mob)octopus, 85, 10, 0.4f, 1.0f, false);
            this.octopus = octopus;
        }

        public void m_8126_() {
            if (!this.octopus.isLocking() && this.octopus.enterExitCooldown == 0) {
                super.m_8126_();
            }
        }
    }

    static class OctopusLookControl
    extends SmoothSwimmingLookControl {
        private final Octopus octopus;

        public OctopusLookControl(Octopus octopus) {
            super((Mob)octopus, 20);
            this.octopus = octopus;
        }

        public void m_8128_() {
            if (!this.octopus.isLocking() && this.octopus.enterExitCooldown == 0) {
                super.m_8128_();
            }
        }
    }

    public static class OctopusEnterDuctGoal
    extends Goal {
        private final Octopus octopus;
        private OctoductBlockEntity targetDuct;

        public OctopusEnterDuctGoal(Octopus octopus) {
            this.octopus = octopus;
        }

        public boolean m_8036_() {
            if (!this.octopus.m_6084_()) {
                return false;
            }
            BlockPos origin = this.octopus.m_20183_();
            this.targetDuct = null;
            double closestDist = Double.MAX_VALUE;
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)origin.m_7918_(-1, -1, -1), (BlockPos)origin.m_7918_(1, 1, 1))) {
                double dist;
                BlockEntity blockEntity = this.octopus.m_9236_().m_7702_(pos);
                if (!(blockEntity instanceof OctoductBlockEntity)) continue;
                OctoductBlockEntity duct = (OctoductBlockEntity)blockEntity;
                BlockState state = this.octopus.m_9236_().m_8055_(pos);
                if (!((Boolean)state.m_61143_((Property)OctoductBlock.ENABLED)).booleanValue() || ((Boolean)state.m_61143_((Property)OctoductBlock.EXPELLING)).booleanValue() || !duct.hasSpaceFor(this.octopus.getCaughtItem(ItemStack.f_41583_)) || !((dist = pos.m_123331_((Vec3i)this.octopus.m_20183_())) < closestDist)) continue;
                this.targetDuct = duct;
                closestDist = dist;
            }
            return this.targetDuct != null && this.octopus.enterExitCooldown <= 0;
        }

        public void m_8056_() {
            this.octopus.enterExitCooldown = 30;
            this.octopus.m_20219_(this.targetDuct.m_58899_().m_252807_().m_82520_(0.0, 0.5, 0.0));
            if (this.octopus.m_20072_()) {
                this.octopus.setWalkingSeafloor(true);
            }
            this.octopus.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.octopus.m_20219_(this.targetDuct.m_58899_().m_252807_().m_82520_(0.0, 0.5, 0.0));
            if (this.octopus.enterExitCooldown == 20) {
                this.octopus.m_9236_().m_7605_((Entity)this.octopus, (byte)8);
                this.octopus.m_5496_((SoundEvent)SpawnSoundEvents.OCTOPUS_FLUSH.get(), 1.0f, 1.0f);
            }
            if (this.octopus.enterExitCooldown <= 2) {
                ItemStack item = this.octopus.getCaughtItem(ItemStack.f_41583_).m_41777_();
                CompoundTag tag = new CompoundTag();
                this.octopus.saveDataToTag((Mob)this.octopus, tag);
                item.m_41751_(tag);
                if (this.targetDuct.addItem(item) != -1) {
                    this.octopus.m_9236_().m_5594_(null, this.octopus.m_20183_(), this.octopus.getPickupSound(), this.octopus.m_5720_(), 1.0f, 1.0f);
                    this.octopus.m_146870_();
                } else {
                    this.octopus.m_9236_().m_7605_((Entity)this.octopus, (byte)10);
                }
            }
        }

        public boolean m_8045_() {
            return this.octopus.enterExitCooldown > 0 && this.octopus.m_6084_();
        }
    }

    public class OctopusSeekDuctGoal
    extends MoveToBlockGoal {
        public OctopusSeekDuctGoal(double speedModifier, int searchRange, int verticalSearchRange) {
            super((PathfinderMob)Octopus.this, speedModifier, searchRange, verticalSearchRange);
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            BlockState state = level.m_8055_(pos);
            if (!state.m_60713_((Block)SpawnBlocks.OCTODUCT.get())) {
                return false;
            }
            if (!((Boolean)state.m_61143_((Property)OctoductBlock.ENABLED)).booleanValue() || ((Boolean)state.m_61143_((Property)OctoductBlock.EXPELLING)).booleanValue()) {
                return false;
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof OctoductBlockEntity) {
                OctoductBlockEntity duct = (OctoductBlockEntity)blockEntity;
                ItemStack dummy = Octopus.this.getCaughtItem(ItemStack.f_41583_).m_41777_();
                CompoundTag tag = new CompoundTag();
                Octopus.this.saveDataToTag((Mob)Octopus.this, tag);
                dummy.m_41751_(tag);
                return duct.hasSpaceFor(dummy);
            }
            return false;
        }
    }

    public class OctopusRandomStroll
    extends RandomStrollGoal {
        public OctopusRandomStroll(PathfinderMob pathfinderMob) {
            super(pathfinderMob, 1.0);
        }

        public boolean m_8036_() {
            if (Octopus.this.m_20072_() && !Octopus.this.m_20096_()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (Octopus.this.m_20072_() && !Octopus.this.m_20096_()) {
                return false;
            }
            return super.m_8045_();
        }
    }

    public class OctopusRandomSwim
    extends RandomSwimmingGoal {
        public OctopusRandomSwim(PathfinderMob pathfinderMob) {
            super(pathfinderMob, 1.0, 2);
        }

        public boolean m_8036_() {
            if (Octopus.this.m_20072_() && !Octopus.this.m_20096_() && !Octopus.this.isWalkingSeafloor()) {
                return super.m_8036_();
            }
            return false;
        }

        public boolean m_8045_() {
            if (Octopus.this.m_20072_() && !Octopus.this.m_20096_()) {
                return super.m_8045_();
            }
            return false;
        }
    }
}

