/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity;

import com.ninni.spawn.registry.SpawnBlocks;
import com.ninni.spawn.registry.SpawnParticles;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.registry.SpawnTags;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.ai.goal.EatSeagrassGoal;
import com.ninni.spawn.server.entity.common.JsonVariantHolder;
import com.ninni.spawn.server.entity.common.PathFindingFavors;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SeaCow
extends WaterAnimal
implements Shearable,
PathFindingFavors,
JsonVariantHolder {
    public static final ResourceLocation LOOT_COMMON = new ResourceLocation("spawn", "archaeology/sea_cow_common");
    public static final ResourceLocation LOOT_RARE = new ResourceLocation("spawn", "archaeology/sea_cow_rare");
    private static final EntityDataAccessor<Integer> ALGAE = SynchedEntityData.m_135353_(SeaCow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FULLNESS = SynchedEntityData.m_135353_(SeaCow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MUNCHING_COOLDOWN = SynchedEntityData.m_135353_(SeaCow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.m_135353_(SeaCow.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(SeaCow.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private EatSeagrassGoal eatBlockGoal;
    private int eatAnimationTick;
    public int maxFullness = 40;
    public int maxAlgaeAmount = 48000;

    public SeaCow(EntityType<? extends WaterAnimal> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.m_274367_(1.0f);
    }

    protected void m_8099_() {
        this.eatBlockGoal = new EatSeagrassGoal(this);
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)this.eatBlockGoal);
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guardian.class, 8.0f, 1.0, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(3, (Goal)new MoveToSeagrassGoal(1.2f, 12, 1));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public @Nullable SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        AnimalVariantManager.getNaturallyOccurringVariant((LivingEntity)this);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, (double)1.2f).m_22268_(Attributes.f_22278_, (double)0.6f);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_150930_(Items.f_42446_) && this.m_20072_()) {
            player.m_5496_((SoundEvent)SpawnSoundEvents.SEA_COW_MILK.get(), 1.0f, 1.0f);
            ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)Items.f_42455_.m_7968_());
            player.m_21008_(interactionHand, itemStack2);
            this.m_21530_();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if ((itemStack.m_204117_(SpawnTags.SEA_COW_LIKES) || itemStack.m_204117_(SpawnTags.SEA_COW_LOVES)) && this.m_20072_() && this.getFullness() < this.maxFullness) {
            this.feed(itemStack, player);
            this.m_21530_();
            if (this.getFullness() > this.maxFullness) {
                this.setFullness(this.maxFullness);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemStack.m_150930_(Items.f_42574_)) {
            if (!this.m_9236_().f_46443_ && this.m_6220_()) {
                this.m_5851_(SoundSource.PLAYERS);
                this.m_146852_(GameEvent.f_157781_, (Entity)player);
                itemStack.m_41622_(1, (LivingEntity)player, player2 -> player2.m_21190_(interactionHand));
                this.m_21530_();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, interactionHand);
    }

    public void m_8107_() {
        if (this.getMunchingCooldown() > 0) {
            this.addMunchingCooldown(-1);
        }
        if (this.getAlgaeAmount() < this.maxAlgaeAmount && this.m_20072_()) {
            this.setAlgaeAmount(this.getAlgaeAmount() + 1);
        }
        if (this.getAlgaeAmount() > this.maxAlgaeAmount) {
            this.setAlgaeAmount(this.maxAlgaeAmount);
        }
        if (this.m_9236_().f_46443_) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        if (this.eatAnimationTick > 0) {
            if (this.getMunchingCooldown() > 0) {
                this.eatAnimationTick = 0;
            }
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.005f, 0.0));
            if (this.f_19796_.m_188501_() <= 0.4f) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_49992_.m_49966_()), this.getHeadPos((boolean)true, (float)0.4f).f_82479_, (double)((float)this.getHeadBlockPos().m_123342_() + 0.5f), this.getHeadPos((boolean)true, (float)0.4f).f_82481_, 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)SpawnParticles.SAND_CLOUD.get(), this.getHeadPos((boolean)true, (float)0.8f).f_82479_, (double)((float)this.getHeadBlockPos().m_123342_() + 0.5f), this.getHeadPos((boolean)true, (float)0.8f).f_82481_, 0.0, 0.0, 0.0);
            }
        }
        super.m_8107_();
    }

    public void m_8035_() {
        super.m_8035_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams.Builder builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)this.getHeadPos(false, 0.0f)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_);
            LootParams lootParams = builder.m_287286_(LootContextParams.f_81461_, (Object)serverLevel.m_8055_(this.getHeadBlockPos())).m_287235_(LootContextParamSets.f_81421_);
            if (this.getFullness() >= this.maxFullness / 2 && this.getFullness() < this.maxFullness) {
                LootTable lootTable = lootParams.m_287182_().m_7654_().m_278653_().m_278676_(LOOT_COMMON);
                ObjectArrayList list = lootTable.m_287195_(lootParams);
                for (ItemStack stack : list) {
                    this.spawnAtHeadLocation(stack);
                }
                this.addMunchingCooldown(this.f_19796_.m_188503_(300) + 200);
                this.setFullness(0);
                this.m_5496_((SoundEvent)SpawnSoundEvents.SEA_COW_FIND.get(), 1.0f, 1.0f);
            } else if (this.getFullness() == this.maxFullness) {
                LootTable lootTable = lootParams.m_287182_().m_7654_().m_278653_().m_278676_(LOOT_RARE);
                ObjectArrayList list = lootTable.m_287195_(lootParams);
                for (ItemStack stack : list) {
                    this.spawnAtHeadLocation(stack);
                }
                this.addMunchingCooldown(this.f_19796_.m_188503_(300) + 400);
                this.setFullness(0);
                this.m_5496_((SoundEvent)SpawnSoundEvents.SEA_COW_FIND.get(), 1.0f, 1.0f);
            }
        }
    }

    public void feed(ItemStack food, Player player) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player.m_7500_() || food.m_41613_() != 1 && !player.m_7500_()) {
                serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, food), this.getHeadPos((boolean)false, (float)0.0f).f_82479_, this.getHeadPos((boolean)false, (float)0.0f).f_82480_, this.getHeadPos((boolean)false, (float)0.0f).f_82481_, 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
            }
        }
        int amount = 0;
        if (food.m_204117_(SpawnTags.SEA_COW_LIKES)) {
            amount = 1;
        } else if (food.m_204117_(SpawnTags.SEA_COW_LOVES)) {
            this.m_216990_((SoundEvent)SpawnSoundEvents.SEA_COW_EAT_YUMMY.get());
            amount = 5;
        }
        this.m_5496_(food.m_41616_(), 1.0f, 1.0f);
        this.addMunchingCooldown(10);
        this.setFullness(this.getFullness() + amount);
        food.m_41774_(1);
    }

    public void m_5851_(SoundSource soundSource) {
        this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)SpawnSoundEvents.SEA_COW_SHEAR.get(), soundSource, 1.0f, 1.0f);
        if (this.getAlgaeAmount() > 35000) {
            int i = this.f_19796_.m_188503_(10) + 10;
            for (int j = 0; j < i; ++j) {
                ItemEntity itemEntity = this.m_20000_((ItemLike)Items.f_41867_, 1);
                if (itemEntity == null) continue;
                itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
            }
        }
        this.setAlgaeAmount(0);
    }

    public float m_5610_(BlockPos blockPos, LevelReader levelReader) {
        if (this.getFullness() >= this.maxFullness / 2) {
            return this.getDepthPathfindingFavor(blockPos, levelReader);
        }
        return super.m_5610_(blockPos, levelReader);
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ALGAE, (Object)0);
        this.f_19804_.m_135372_(FULLNESS, (Object)0);
        this.f_19804_.m_135372_(MUNCHING_COOLDOWN, (Object)(this.f_19796_.m_188503_(200) + 30));
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)this.getDefaultVariant().toString());
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("AlgaeAmount", this.getAlgaeAmount());
        tag.m_128405_("Fullness", this.getFullness());
        tag.m_128405_("MunchingCooldown", this.getMunchingCooldown());
        tag.m_128359_("Variant", this.getVariant().toString());
        if (this.getVariantScale() != 1.0f) {
            tag.m_128350_("VariantScale", this.getVariantScale());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setAlgaeAmount(tag.m_128451_("AlgaeAmount"));
        this.setFullness(tag.m_128451_("Fullness"));
        this.setMunchingCooldown(tag.m_128451_("MunchingCooldown"));
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
    }

    @Override
    public void setVariantScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    @Override
    public float getVariantScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    @Override
    public void setVariant(ResourceLocation resourceLocation) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)resourceLocation.toString());
    }

    @Override
    public ResourceLocation getVariant() {
        return ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(DATA_VARIANT)));
    }

    @Override
    public ResourceLocation getDefaultVariant() {
        return new ResourceLocation("spawn", "gravel");
    }

    public int getAlgaeAmount() {
        return (Integer)this.f_19804_.m_135370_(ALGAE);
    }

    public void setAlgaeAmount(int amount) {
        this.f_19804_.m_135381_(ALGAE, (Object)amount);
    }

    public int getMunchingCooldown() {
        return (Integer)this.f_19804_.m_135370_(MUNCHING_COOLDOWN);
    }

    public void addMunchingCooldown(int amount) {
        this.f_19804_.m_135381_(MUNCHING_COOLDOWN, (Object)(this.getMunchingCooldown() + amount));
    }

    public void setMunchingCooldown(int amount) {
        this.f_19804_.m_135381_(MUNCHING_COOLDOWN, (Object)amount);
    }

    public int getFullness() {
        return (Integer)this.f_19804_.m_135370_(FULLNESS);
    }

    public void setFullness(int amount) {
        this.f_19804_.m_135381_(FULLNESS, (Object)amount);
    }

    public boolean m_6220_() {
        return this.getAlgaeAmount() > 14000;
    }

    protected void m_8024_() {
        this.eatAnimationTick = this.eatBlockGoal.getEatAnimationTick();
        super.m_8024_();
    }

    public void m_7822_(byte b) {
        if (b == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.m_7822_(b);
        }
    }

    public float getHeadEatPositionScale(float f) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        if (this.eatAnimationTick < 4) {
            return ((float)this.eatAnimationTick - f) / 4.0f;
        }
        return -((float)(this.eatAnimationTick - 40) - f) / 4.0f;
    }

    public float getHeadEatAngleScale(float f) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float g = ((float)(this.eatAnimationTick - 4) - f) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.m_14031_((float)(g * 28.7f));
        }
        if (this.eatAnimationTick > 0) {
            return 0.62831855f;
        }
        return this.m_146909_() * ((float)Math.PI / 180);
    }

    public void spawnAtHeadLocation(ItemStack itemStack) {
        if (!itemStack.m_41619_() && !this.m_9236_().f_46443_) {
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.getHeadPos((boolean)false, (float)0.0f).f_82479_, this.getHeadPos((boolean)false, (float)0.0f).f_82480_, this.getHeadPos((boolean)false, (float)0.0f).f_82481_, itemStack);
            itemEntity.m_32060_();
            this.m_9236_().m_7967_((Entity)itemEntity);
        }
    }

    public Vec3 getHeadPos(boolean random, float randomValue) {
        float angle = (float)Math.PI / 180 * this.f_20883_;
        float headX = 1.5f * this.m_6134_() * Mth.m_14031_((float)((float)Math.PI + angle));
        float headZ = 1.5f * this.m_6134_() * Mth.m_14089_((float)angle);
        if (random) {
            return new Vec3(this.m_20208_(randomValue) + (double)headX, this.m_20187_(), this.m_20262_(randomValue) + (double)headZ);
        }
        return new Vec3(this.m_20185_() + (double)headX, (double)this.m_146904_(), this.m_20189_() + (double)headZ);
    }

    public BlockPos getHeadBlockPos() {
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double headX = 1.5f * this.m_6134_() * Mth.m_14031_((float)((float)Math.PI + angle));
        double headZ = 1.5f * this.m_6134_() * Mth.m_14089_((float)angle);
        return new BlockPos((int)(this.m_20185_() + headX), this.m_146904_(), (int)(this.m_20189_() + headZ));
    }

    protected void m_6229_(int i) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(i - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(4800);
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new AmphibiousPathNavigation((Mob)this, level);
    }

    public boolean m_6785_(double d) {
        return !this.m_21532_();
    }

    public boolean m_6573_(Player player) {
        return true;
    }

    public static boolean checkSurfaceWaterAnimalSpawnRules(EntityType<Mob> mobEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        int i = serverLevelAccessor.m_5736_();
        int j = i - 13;
        return blockPos.m_123342_() >= j && blockPos.m_123342_() <= i && serverLevelAccessor.m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_) && serverLevelAccessor.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    protected SoundEvent m_5501_() {
        return (SoundEvent)SpawnSoundEvents.BIG_FISH_SWIM.get();
    }

    public void m_8038_(ServerLevel level, LightningBolt lightning) {
        if (ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20557_, timer -> {})) {
            Cow cow = (Cow)EntityType.f_20557_.m_20615_((Level)level);
            if (cow != null) {
                cow.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
                cow.m_21557_(this.m_21525_());
                if (this.m_8077_()) {
                    cow.m_6593_(this.m_7770_());
                    cow.m_20340_(this.m_20151_());
                }
                ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)cow);
                level.m_7967_((Entity)cow);
                cow.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200, 1, false, false));
                this.m_146870_();
            } else {
                super.m_8038_(level, lightning);
            }
        } else {
            super.m_8038_(level, lightning);
        }
    }

    protected @Nullable SoundEvent m_7515_() {
        return this.m_20072_() ? (SoundEvent)SpawnSoundEvents.SEA_COW_AMBIENT.get() : (SoundEvent)SpawnSoundEvents.SEA_COW_AMBIENT_LAND.get();
    }

    protected @Nullable SoundEvent m_7975_(DamageSource damageSource) {
        return this.m_20072_() ? (SoundEvent)SpawnSoundEvents.SEA_COW_HURT.get() : (SoundEvent)SpawnSoundEvents.SEA_COW_HURT_LAND.get();
    }

    protected @Nullable SoundEvent m_5592_() {
        return this.m_20072_() ? (SoundEvent)SpawnSoundEvents.SEA_COW_DEATH.get() : (SoundEvent)SpawnSoundEvents.SEA_COW_DEATH_LAND.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)SpawnSoundEvents.SEA_COW_STEP.get(), 0.15f, 1.0f);
    }

    public class MoveToSeagrassGoal
    extends MoveToBlockGoal {
        public MoveToSeagrassGoal(double d, int i, int j) {
            super((PathfinderMob)SeaCow.this, d, i, j);
        }

        public boolean m_8036_() {
            return super.m_8036_() && SeaCow.this.getMunchingCooldown() == 0;
        }

        protected boolean m_6465_(LevelReader levelReader, BlockPos blockPos) {
            BlockPos blockPos1 = SeaCow.this.getHeadBlockPos();
            return levelReader.m_8055_(blockPos1).m_60713_(Blocks.f_50038_) && levelReader.m_8055_(blockPos1.m_7495_()).m_60713_((Block)SpawnBlocks.ALGAL_SAND.get());
        }
    }
}

