/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity;

import com.ninni.spawn.registry.SpawnCriteriaTriggers;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnPose;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.registry.SpawnTags;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.common.JsonVariantHolder;
import com.ninni.spawn.server.entity.common.PathFindingFavors;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Sunfish
extends PathfinderMob
implements Bucketable,
JsonVariantHolder,
PathFindingFavors {
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(Sunfish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BASKING_COOLDOWN = SynchedEntityData.m_135353_(Sunfish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(Sunfish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.m_135353_(Sunfish.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(Sunfish.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_BASKING = SynchedEntityData.m_135353_(Sunfish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState landAnimationState = new AnimationState();
    public float baskingProgress = 0.0f;
    private int idleAnimationTimeout = 0;
    private int landAnimationTimeout = 0;
    private int inLove;
    private int lastAgeCategory = Integer.MIN_VALUE;
    private @Nullable UUID loveCause;

    public Sunfish(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new SunfishMoveControl(this);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 0.7, Ingredient.m_204132_(SpawnTags.SUNFISH_TEMPTS), false));
        this.f_21345_.m_25352_(5, (Goal)new SunfishBaskingGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 0.5, 10));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, (double)0.8f);
    }

    public @Nullable SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (mobSpawnType == MobSpawnType.BUCKET) {
            this.growUpIfNeeded();
            return spawnGroupData;
        }
        AnimalVariantManager.getNaturallyOccurringVariant((LivingEntity)this);
        this.growUpIfNeeded();
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        Optional interactionResult;
        Level level;
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_150930_((Item)SpawnItems.SUNFISH_SPAWN_EGG.get()) && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            Sunfish baby = (Sunfish)((EntityType)SpawnEntityType.SUNFISH.get()).m_20615_(this.m_9236_());
            baby.setAge(-48000);
            baby.setVariant(this.getVariant());
            baby.growUpIfNeeded();
            baby.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            serverLevel.m_47205_((Entity)baby);
            return InteractionResult.SUCCESS;
        }
        if (this.m_6162_() && (interactionResult = Bucketable.m_148828_((Player)player, (InteractionHand)interactionHand, (LivingEntity)this)).isPresent() && ((InteractionResult)interactionResult.get()).m_19077_()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SpawnCriteriaTriggers.CATCH_BABY_MOB.trigger(serverPlayer);
            }
            return (InteractionResult)interactionResult.get();
        }
        if (itemStack.m_204117_(SpawnTags.SUNFISH_FEEDS)) {
            int i = this.getAge();
            if (!this.m_9236_().f_46443_ && i == 0 && this.canFallInLove()) {
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                this.setInLove(player);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                this.setAge(this.getAge() + 300);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6071_(player, interactionHand);
    }

    public float m_5610_(BlockPos blockPos, LevelReader levelReader) {
        if (this.m_9236_().m_46462_()) {
            return this.getDepthPathfindingFavor(blockPos, levelReader);
        }
        return this.getSurfacePathfindingFavor(blockPos, levelReader);
    }

    public void spawnChildFromBreeding(ServerLevel serverLevel, Sunfish partner) {
        Sunfish baby = (Sunfish)((EntityType)SpawnEntityType.SUNFISH.get()).m_20615_((Level)serverLevel);
        if (baby == null) {
            return;
        }
        ServerPlayer serverPlayer = this.getLoveCause();
        if (serverPlayer == null && partner.getLoveCause() != null) {
            serverPlayer = partner.getLoveCause();
        }
        if (serverPlayer != null) {
            serverPlayer.m_36220_(Stats.f_12937_);
            SpawnCriteriaTriggers.BREED_SUNFISH.trigger(serverPlayer);
        }
        this.setAge(6000);
        partner.setAge(6000);
        this.resetLove();
        partner.resetLove();
        baby.setVariant(this.m_9236_().f_46441_.m_188501_() > 0.5f ? this.getVariant() : partner.getVariant());
        baby.m_21530_();
        baby.setAge(-48000);
        baby.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
        serverLevel.m_7967_((Entity)baby);
        serverLevel.m_7605_((Entity)this, (byte)18);
        baby.growUpIfNeeded();
        if (serverLevel.m_46469_().m_46207_(GameRules.f_46135_)) {
            serverLevel.m_7967_((Entity)new ExperienceOrb((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_217043_().m_188503_(7) + 1));
        }
    }

    protected void m_8024_() {
        if (this.getAge() != 0) {
            this.inLove = 0;
        }
        if (!this.m_20069_() && this.m_20096_() && this.f_19863_ && this.m_6162_()) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), this.getSunfishAge() == -2 ? (double)0.3f : 0.5, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_((SoundEvent)SpawnSoundEvents.FISH_FLOP.get(), this.m_6121_(), this.m_6100_());
        }
        super.m_8024_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getAge() != 0) {
            this.inLove = 0;
        }
        if (this.inLove > 0) {
            --this.inLove;
            if (this.inLove % 10 == 0) {
                double d = this.f_19796_.m_188583_() * 0.02;
                double e = this.f_19796_.m_188583_() * 0.02;
                double f = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, e, f);
            }
        }
        if (this.getBaskingCooldown() > 0) {
            this.setBaskingCooldown(this.getBaskingCooldown() - 1);
        }
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        this.inLove = 0;
        if (this.isBasking()) {
            this.setBasking(false);
            this.setBaskingCooldown(400);
        }
        return super.m_6469_(damageSource, f);
    }

    public boolean canFallInLove() {
        return this.inLove <= 0;
    }

    public void setInLove(@Nullable Player player) {
        this.inLove = 600;
        if (player != null) {
            this.loveCause = player.m_20148_();
        }
        this.m_9236_().m_7605_((Entity)this, (byte)18);
    }

    public @Nullable ServerPlayer getLoveCause() {
        if (this.loveCause == null) {
            return null;
        }
        Player player = this.m_9236_().m_46003_(this.loveCause);
        if (player instanceof ServerPlayer) {
            return (ServerPlayer)player;
        }
        return null;
    }

    public boolean isInLove() {
        return this.inLove > 0;
    }

    public void resetLove() {
        this.inLove = 0;
    }

    public boolean canMate(Sunfish sunfish) {
        if (sunfish == this || sunfish.getClass() != this.getClass()) {
            return false;
        }
        return this.isInLove() && sunfish.isInLove();
    }

    public void m_7822_(byte b) {
        if (b == 18) {
            for (int i = 0; i < 7; ++i) {
                double d = this.f_19796_.m_188583_() * 0.02;
                double e = this.f_19796_.m_188583_() * 0.02;
                double f = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, e, f);
            }
        } else {
            super.m_7822_(b);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_6162_()) {
            if (this.m_20072_()) {
                if (this.m_20089_() != Pose.SWIMMING && !this.isBasking()) {
                    this.m_20124_(Pose.SWIMMING);
                }
                if (this.m_20089_() != SpawnPose.BREACHING.get() && this.isBasking()) {
                    this.m_20124_(SpawnPose.BREACHING.get());
                }
            } else if (this.m_20089_() != Pose.STANDING) {
                this.m_20124_(Pose.STANDING);
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    public void growUpIfNeeded() {
        int currentCategory = this.getSunfishAge();
        if (currentCategory != this.lastAgeCategory) {
            this.lastAgeCategory = currentCategory;
            switch (currentCategory) {
                case -2: {
                    this.m_21051_(Attributes.f_22276_).m_22100_(2.0);
                    this.m_21153_(6.0f);
                    break;
                }
                case -1: {
                    this.m_21051_(Attributes.f_22276_).m_22100_(12.0);
                    this.m_21153_(12.0f);
                    break;
                }
                case 0: {
                    this.m_21051_(Attributes.f_22276_).m_22100_(30.0);
                    this.m_21153_(30.0f);
                }
            }
            this.m_6210_();
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        int age = this.getSunfishAge();
        if (age == -2) {
            return EntityDimensions.m_20395_((float)0.3f, (float)0.3f);
        }
        if (age == -1) {
            return EntityDimensions.m_20395_((float)0.6f, (float)0.6f);
        }
        if (pose == Pose.STANDING || pose == SpawnPose.BREACHING.get()) {
            return EntityDimensions.m_20395_((float)2.2f, (float)0.5f);
        }
        return EntityDimensions.m_20395_((float)1.5f, (float)2.2f);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.5f;
    }

    private void setupAnimationStates() {
        if (!this.m_6162_()) {
            float target = this.isBasking() ? 1.0f : 0.0f;
            this.baskingProgress += (target - this.baskingProgress) * 0.05f;
            if (this.m_20072_()) {
                if (this.idleAnimationTimeout <= 0) {
                    this.idleAnimationTimeout = 80;
                    this.idleAnimationState.m_216977_(this.f_19797_);
                } else {
                    --this.idleAnimationTimeout;
                }
            } else if (this.landAnimationTimeout <= 0) {
                this.landAnimationTimeout = 40;
                this.landAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.landAnimationTimeout;
            }
        }
    }

    public int getSunfishAge() {
        if (this.m_6162_()) {
            return this.getAge() < -24000 ? -2 : -1;
        }
        return 0;
    }

    public boolean m_6162_() {
        return this.getAge() < 0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AGE, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)this.getDefaultVariant().toString());
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(IS_BASKING, (Object)false);
        this.f_19804_.m_135372_(BASKING_COOLDOWN, (Object)(this.f_19796_.m_188503_(200) + 200));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("FromBucket", this.m_27487_());
        tag.m_128379_("IsBasking", this.isBasking());
        tag.m_128405_("Age", this.getAge());
        tag.m_128405_("BaskingCooldown", this.getBaskingCooldown());
        tag.m_128405_("InLove", this.inLove);
        tag.m_128359_("Variant", this.getVariant().toString());
        if (this.loveCause != null) {
            tag.m_128362_("LoveCause", this.loveCause);
        }
        if (this.getVariantScale() != 1.0f) {
            tag.m_128350_("VariantScale", this.getVariantScale());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_27497_(tag.m_128471_("FromBucket"));
        this.setBasking(tag.m_128471_("IsBasking"));
        this.setBaskingCooldown(tag.m_128451_("BaskingCooldown"));
        this.setAge(tag.m_128451_("Age"));
        this.inLove = tag.m_128451_("InLove");
        this.loveCause = tag.m_128403_("LoveCause") ? tag.m_128342_("LoveCause") : null;
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
    }

    public int getAge() {
        return (Integer)this.f_19804_.m_135370_(AGE);
    }

    public void setAge(int i) {
        this.f_19804_.m_135381_(AGE, (Object)i);
    }

    public int getBaskingCooldown() {
        return (Integer)this.f_19804_.m_135370_(BASKING_COOLDOWN);
    }

    public void setBaskingCooldown(int i) {
        this.f_19804_.m_135381_(BASKING_COOLDOWN, (Object)i);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean bl) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)bl);
    }

    public void m_6872_(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_("Age", this.getAge());
        tag.m_128405_("BaskingCooldown", this.getBaskingCooldown());
        Bucketable.m_148822_((Mob)this, (ItemStack)itemStack);
        tag.m_128359_("Variant", this.getVariant().toString());
        if (this.getVariantScale() != 1.0f) {
            tag.m_128350_("VariantScale", this.getVariantScale());
        }
    }

    public void m_142278_(CompoundTag tag) {
        if (tag.m_128441_("Age")) {
            this.setAge(tag.m_128451_("Age"));
        } else {
            this.setAge(-48000);
        }
        if (tag.m_128441_("BaskingCooldown")) {
            this.setBaskingCooldown(tag.m_128451_("BaskingCooldown"));
        }
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
        Bucketable.m_148825_((Mob)this, (CompoundTag)tag);
    }

    @Override
    public void setVariantScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    @Override
    public float getVariantScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    @Override
    public void setVariant(ResourceLocation resourceLocation) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)resourceLocation.toString());
    }

    public void setBasking(boolean basking) {
        this.f_19804_.m_135381_(IS_BASKING, (Object)basking);
    }

    public boolean isBasking() {
        return (Boolean)this.f_19804_.m_135370_(IS_BASKING);
    }

    @Override
    public ResourceLocation getVariant() {
        return ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(DATA_VARIANT)));
    }

    @Override
    public ResourceLocation getDefaultVariant() {
        return new ResourceLocation("spawn", "earl");
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public void m_7023_(Vec3 vec3) {
        if (this.isBasking()) {
            this.m_20256_(Vec3.f_82478_);
            return;
        }
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(0.01f, vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            Vec3 motion = this.m_20184_().m_82490_(0.9);
            if ((!this.m_5842_() || this.m_9236_().m_6425_(this.m_20183_().m_6630_(2)).m_76178_()) && this.m_21573_().m_26571_()) {
                motion = motion.m_82520_(0.0, -0.02, 0.0);
            }
            this.m_20256_(motion);
        } else {
            super.m_7023_(vec3);
        }
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        int age = this.getAge();
        this.growUpIfNeeded();
        if (age < 0) {
            this.setAge(age + 1);
        }
        this.handleAirSupply(i);
    }

    protected void handleAirSupply(int i) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(i - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public boolean m_6785_(double d) {
        return !this.m_27487_() && !this.m_8077_();
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6914_(LevelReader levelReader) {
        return levelReader.m_45784_((Entity)this);
    }

    public int m_8100_() {
        return 120;
    }

    public int m_213860_() {
        return 1 + this.m_9236_().f_46441_.m_188503_(3);
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6573_(Player player) {
        return true;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public ItemStack m_28282_() {
        return ((Item)SpawnItems.BABY_SUNFISH_BUCKET.get()).m_7968_();
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    protected @Nullable SoundEvent m_5592_() {
        return (SoundEvent)SpawnSoundEvents.FISH_DEATH.get();
    }

    protected SoundEvent m_5501_() {
        return (SoundEvent)SpawnSoundEvents.BIG_FISH_SWIM.get();
    }

    protected @Nullable SoundEvent m_7515_() {
        return SoundEvents.f_271165_;
    }

    protected @Nullable SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpawnSoundEvents.FISH_HURT.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
    }

    public static boolean checkSurfaceWaterAnimalSpawnRules(EntityType<Sunfish> mobEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        int i = serverLevelAccessor.m_5736_();
        int j = i - 13;
        return blockPos.m_123342_() >= j && blockPos.m_123342_() <= i && serverLevelAccessor.m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_) && serverLevelAccessor.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    static class SunfishMoveControl
    extends SmoothSwimmingMoveControl {
        private final Sunfish sunfish;

        public SunfishMoveControl(Sunfish sunfish) {
            super((Mob)sunfish, 85, 10, 0.02f, 0.1f, false);
            this.sunfish = sunfish;
        }

        public void m_8126_() {
            if (!this.sunfish.isBasking()) {
                super.m_8126_();
            }
        }
    }

    public static class BreedGoal
    extends Goal {
        private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
        protected final Sunfish sunfish;
        private final Class<? extends Sunfish> partnerClass;
        protected final Level level;
        protected @Nullable Sunfish partner;
        private int loveTime;
        private final double speedModifier;

        public BreedGoal(Sunfish sunfish, double d) {
            this(sunfish, d, sunfish.getClass());
        }

        public BreedGoal(Sunfish sunfish, double d, Class<? extends Sunfish> class_) {
            this.sunfish = sunfish;
            this.level = sunfish.m_9236_();
            this.partnerClass = class_;
            this.speedModifier = d;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (!this.sunfish.isInLove()) {
                return false;
            }
            this.partner = this.getFreePartner();
            return this.partner != null;
        }

        public boolean m_8045_() {
            return this.partner.m_6084_() && this.partner.isInLove() && this.loveTime < 60;
        }

        public void m_8041_() {
            this.partner = null;
            this.loveTime = 0;
        }

        public void m_8037_() {
            this.sunfish.m_21563_().m_24960_((Entity)this.partner, 10.0f, (float)this.sunfish.m_8132_());
            this.sunfish.m_21573_().m_5624_((Entity)this.partner, this.speedModifier);
            ++this.loveTime;
            if (this.loveTime >= this.m_183277_(60) && this.sunfish.m_20280_((Entity)this.partner) < 9.0) {
                this.breed();
            }
        }

        private @Nullable Sunfish getFreePartner() {
            List list = this.level.m_45971_(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.sunfish, this.sunfish.m_20191_().m_82400_(8.0));
            double d = Double.MAX_VALUE;
            Sunfish sunfish1 = null;
            for (Sunfish animal2 : list) {
                if (!this.sunfish.canMate(animal2) || !(this.sunfish.m_20280_((Entity)animal2) < d)) continue;
                sunfish1 = animal2;
                d = this.sunfish.m_20280_((Entity)animal2);
            }
            return sunfish1;
        }

        protected void breed() {
            for (int i = 0; i <= this.sunfish.f_19796_.m_216339_(0, 5) + 1; ++i) {
                this.sunfish.spawnChildFromBreeding((ServerLevel)this.level, this.partner);
            }
        }
    }

    public static class SunfishBaskingGoal
    extends Goal {
        private final Sunfish sunfish;
        private int baskDuration;
        private int failureGracePeriod;

        public SunfishBaskingGoal(Sunfish sunfish) {
            this.sunfish = sunfish;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.sunfish.getBaskingCooldown() == 0 && this.sunfish.m_5842_() && !this.sunfish.isInLove() && this.sunfish.m_9236_().m_46461_() && !this.sunfish.m_6162_() && this.sunfish.m_21573_().m_26571_() && this.sunfish.m_9236_().m_45517_(LightLayer.SKY, this.sunfish.m_20183_()) > 7;
        }

        public void m_8056_() {
            this.baskDuration = 1000 + this.sunfish.f_19796_.m_188503_(200);
            this.failureGracePeriod = 20;
            this.sunfish.setBasking(true);
            this.sunfish.m_21573_().m_26573_();
        }

        public boolean m_8045_() {
            boolean valid;
            boolean bl = valid = this.sunfish.m_5842_() && !this.sunfish.isInLove() && this.sunfish.m_9236_().m_46461_() && !this.sunfish.m_6162_() && this.sunfish.m_9236_().m_45517_(LightLayer.SKY, this.sunfish.m_20183_()) > 7;
            this.failureGracePeriod = !valid ? --this.failureGracePeriod : 20;
            return this.failureGracePeriod > 0 && this.baskDuration > 0;
        }

        public void m_8037_() {
            --this.baskDuration;
        }

        public void m_8041_() {
            this.sunfish.setBasking(false);
            this.sunfish.setBaskingCooldown(1000 + this.sunfish.f_19796_.m_188503_(1000));
        }
    }
}

