/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity;

import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.registry.SpawnTags;
import com.ninni.spawn.server.entity.TunaEgg;
import com.ninni.spawn.server.entity.ai.goal.WaterJumpGoal;
import com.ninni.spawn.server.entity.common.JsonVariantHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Tuna
extends Animal
implements JsonVariantHolder {
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.m_135353_(Tuna.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(Tuna.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public Tuna(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.8));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.4, Ingredient.m_204132_(SpawnTags.TUNA_TEMPTS), false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(7, (Goal)new WaterJumpGoal((PathfinderMob)this, 300));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(SpawnTags.TUNA_FEEDS);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult interactionresult = super.m_6071_(player, hand);
        if (interactionresult.m_19077_()) {
            this.m_21530_();
        }
        return interactionresult;
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(vec3);
        }
    }

    public @Nullable AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)SpawnEntityType.TUNA.get()).m_20615_((Level)serverLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.m_20069_() && this.m_20184_().m_82556_() > 0.03) {
            Vec3 vec3 = this.m_20252_(0.0f);
            float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
            float g = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
            float h = 1.2f - this.f_19796_.m_188501_() * 0.7f;
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vec3.f_82479_ * (double)h + (double)f, this.m_20186_() + (double)0.4f, this.m_20189_() - vec3.f_82481_ * (double)h + (double)g, 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vec3.f_82479_ * (double)h - (double)f, this.m_20186_() + (double)0.4f, this.m_20189_() - vec3.f_82481_ * (double)h - (double)g, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    public void m_8107_() {
        if (!this.m_20069_() && this.m_20096_() && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.6f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        super.m_8107_();
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.5f;
    }

    protected void handleAirSupply(int i) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(i - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_21532_();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.m_21532_() && !this.m_8077_();
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6914_(LevelReader levelReader) {
        return levelReader.m_45784_((Entity)this);
    }

    public int m_8100_() {
        return 120;
    }

    public int m_213860_() {
        return 1 + this.m_9236_().f_46441_.m_188503_(3);
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    protected @Nullable SoundEvent m_5592_() {
        return (SoundEvent)SpawnSoundEvents.FISH_DEATH.get();
    }

    protected SoundEvent m_5501_() {
        return (SoundEvent)SpawnSoundEvents.BIG_FISH_SWIM.get();
    }

    protected @Nullable SoundEvent m_7515_() {
        return SoundEvents.f_271165_;
    }

    protected @Nullable SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpawnSoundEvents.FISH_HURT.get();
    }

    protected SoundEvent getFlopSound() {
        return (SoundEvent)SpawnSoundEvents.FISH_FLOP.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
    }

    public static boolean checkSurfaceWaterAnimalSpawnRules(EntityType<Tuna> mobEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        int i = serverLevelAccessor.m_5736_();
        int j = i - 13;
        return blockPos.m_123342_() >= j && blockPos.m_123342_() <= i && serverLevelAccessor.m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_) && serverLevelAccessor.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    public void m_27563_(ServerLevel serverLevel, Animal animal) {
        TunaEgg egg = (TunaEgg)((EntityType)SpawnEntityType.TUNA_EGG.get()).m_20615_((Level)serverLevel);
        if (egg == null) {
            return;
        }
        ServerPlayer serverPlayer = this.m_27592_();
        if (serverPlayer == null && animal.m_27592_() != null) {
            serverPlayer = animal.m_27592_();
        }
        if (serverPlayer != null) {
            serverPlayer.m_36220_(Stats.f_12937_);
            CriteriaTriggers.f_10581_.m_147278_(serverPlayer, (Animal)this, animal, null);
        }
        this.m_146762_(6000);
        animal.m_146762_(6000);
        this.m_27594_();
        animal.m_27594_();
        if (animal instanceof Tuna) {
            Tuna tuna = (Tuna)animal;
            egg.setVariant(serverLevel.f_46441_.m_188499_() ? this.getVariant() : tuna.getVariant());
        }
        egg.m_21530_();
        egg.setHatchTicks(6000);
        egg.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
        serverLevel.m_7967_((Entity)egg);
        serverLevel.m_7605_((Entity)this, (byte)18);
        if (serverLevel.m_46469_().m_46207_(GameRules.f_46135_)) {
            serverLevel.m_7967_((Entity)new ExperienceOrb((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_217043_().m_188503_(7) + 1));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)this.getDefaultVariant().toString());
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Variant", this.getVariant().toString());
        tag.m_128350_("VariantScale", this.getVariantScale());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
    }

    @Override
    public void setVariantScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    @Override
    public float getVariantScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    @Override
    public void setVariant(ResourceLocation resourceLocation) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)resourceLocation.toString());
    }

    @Override
    public ResourceLocation getVariant() {
        return ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(DATA_VARIANT)));
    }

    @Override
    public ResourceLocation getDefaultVariant() {
        return new ResourceLocation("spawn", "bluefin");
    }
}

