/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity.ai.goal;

import com.ninni.spawn.registry.SpawnBlocks;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.server.entity.SeaCow;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class EatSeagrassGoal
extends Goal {
    private static final Predicate<BlockState> IS_TALL_GRASS = BlockStatePredicate.m_61287_((Block)Blocks.f_50038_);
    private final SeaCow seaCow;
    private final Level level;
    private int eatAnimationTick;

    public EatSeagrassGoal(SeaCow seaCow) {
        this.seaCow = seaCow;
        this.level = seaCow.m_9236_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        BlockPos blockPos = this.seaCow.getHeadBlockPos();
        if (IS_TALL_GRASS.test(this.level.m_8055_(blockPos)) && this.seaCow.getMunchingCooldown() == 0 && this.seaCow.m_20072_()) {
            return this.level.m_8055_(blockPos).m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.LOWER && this.level.m_8055_(blockPos.m_7495_()).m_60713_((Block)SpawnBlocks.ALGAL_SAND.get()) || this.level.m_8055_(blockPos).m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER && this.level.m_8055_(blockPos.m_7495_().m_7495_()).m_60713_((Block)SpawnBlocks.ALGAL_SAND.get());
        }
        return false;
    }

    public void m_8056_() {
        this.eatAnimationTick = this.m_183277_(40);
        this.level.m_7605_((Entity)this.seaCow, (byte)10);
        this.seaCow.m_5496_((SoundEvent)SpawnSoundEvents.SEA_COW_MUNCH.get(), 1.0f, 1.0f);
        this.seaCow.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.eatAnimationTick = 0;
    }

    public boolean m_8045_() {
        return this.eatAnimationTick > 0 && this.seaCow.getMunchingCooldown() == 0;
    }

    public int getEatAnimationTick() {
        return this.eatAnimationTick;
    }

    public void m_8037_() {
        BlockPos blockPos = this.seaCow.getHeadBlockPos();
        this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        if (this.eatAnimationTick != this.m_183277_(4)) {
            return;
        }
        if (IS_TALL_GRASS.test(this.level.m_8055_(blockPos))) {
            if (this.level.m_8055_(blockPos).m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.LOWER && this.level.m_8055_(blockPos.m_7495_()).m_60713_((Block)SpawnBlocks.ALGAL_SAND.get())) {
                this.level.m_7731_(blockPos, ((Block)SpawnBlocks.TRIMMED_SEAGRASS.get()).m_49966_(), 3);
                this.seaCow.m_8035_();
            } else if (this.level.m_8055_(blockPos).m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER && this.level.m_8055_(blockPos.m_7495_().m_7495_()).m_60713_((Block)SpawnBlocks.ALGAL_SAND.get())) {
                this.level.m_7731_(blockPos.m_7495_(), ((Block)SpawnBlocks.TRIMMED_SEAGRASS.get()).m_49966_(), 3);
                this.seaCow.m_8035_();
            }
        }
    }
}

