/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity.ai.goal;

import com.ninni.spawn.registry.SpawnSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.phys.Vec3;

public class WaterJumpGoal
extends JumpGoal {
    private static final int[] STEPS_TO_CHECK = new int[]{0, 1, 4, 5, 6, 7};
    private final PathfinderMob entity;
    private final int interval;
    private boolean breached;

    public WaterJumpGoal(PathfinderMob entity, int i) {
        this.entity = entity;
        this.interval = WaterJumpGoal.m_186073_((int)i);
    }

    public boolean m_8036_() {
        if (this.entity.m_217043_().m_188503_(this.interval) != 0) {
            return false;
        }
        Direction direction = this.entity.m_6374_();
        int i = direction.m_122429_();
        int j = direction.m_122431_();
        BlockPos blockPos = this.entity.m_20183_();
        for (int k : STEPS_TO_CHECK) {
            if (this.waterIsClear(blockPos, i, j, k) && this.surfaceIsClear(blockPos, i, j, k)) continue;
            return false;
        }
        return true;
    }

    private boolean waterIsClear(BlockPos blockPos, int i, int j, int k) {
        BlockPos blockPos2 = blockPos.m_7918_(i * k, 0, j * k);
        return this.entity.m_9236_().m_6425_(blockPos2).m_205070_(FluidTags.f_13131_) && !this.entity.m_9236_().m_8055_(blockPos2).m_280555_();
    }

    private boolean surfaceIsClear(BlockPos blockPos, int i, int j, int k) {
        return this.entity.m_9236_().m_8055_(blockPos.m_7918_(i * k, 1, j * k)).m_60795_() && this.entity.m_9236_().m_8055_(blockPos.m_7918_(i * k, 2, j * k)).m_60795_();
    }

    public boolean m_8045_() {
        double d = this.entity.m_20184_().f_82480_;
        return !(d * d < (double)0.03f && this.entity.m_146909_() != 0.0f && Math.abs(this.entity.m_146909_()) < 10.0f && this.entity.m_20069_() || this.entity.m_20096_());
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        Direction direction = this.entity.m_6374_();
        this.entity.m_20256_(this.entity.m_20184_().m_82520_((double)direction.m_122429_() * 0.8, 0.7, (double)direction.m_122431_() * 0.8));
        this.entity.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.entity.m_146926_(0.0f);
        this.breached = false;
    }

    public void m_8037_() {
        Vec3 vec3 = this.entity.m_20184_();
        if (vec3.f_82480_ * vec3.f_82480_ < (double)0.03f && this.entity.m_146909_() != 0.0f) {
            this.entity.m_146926_(Mth.m_14189_((float)0.2f, (float)this.entity.m_146909_(), (float)0.0f));
        } else if (vec3.m_82553_() > (double)1.0E-5f) {
            if (!this.breached) {
                this.entity.m_5496_((SoundEvent)SpawnSoundEvents.FISH_JUMP.get(), 1.0f, 1.0f);
                this.breached = true;
            }
            double d = vec3.m_165924_();
            double e = Math.atan2(-vec3.f_82480_, d) * 57.2957763671875;
            this.entity.m_146926_((float)e);
        }
    }
}

