/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity.common;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Catchable {
    public boolean canBeCatched(@Nullable ItemStack var1);

    default public @Nullable ItemStack getCaughtItem(ItemStack capturingItem) {
        return ItemStack.f_41583_;
    }

    default public @Nullable Component cantBeCatchedReason() {
        return null;
    }

    public boolean hasBeenCaught();

    public void setHasBeenCaught(boolean var1);

    public SoundEvent getPickupSound();

    public SoundEvent getReleaseSound();

    default public void saveDataToTag(Mob mob, CompoundTag tag) {
        Catchable.saveDefaultDataToTag(mob, tag);
    }

    default public void loadDataFromTag(Mob mob, CompoundTag tag) {
        Catchable.loadDefaultDataFromTag(mob, tag);
    }

    public static void saveDefaultDataToTag(Mob mob, CompoundTag tag) {
        if (mob.m_8077_()) {
            tag.m_128359_("CustomName", mob.m_7770_().getString());
        }
        if (mob.m_21525_()) {
            tag.m_128379_("NoAI", mob.m_21525_());
        }
        if (mob.m_20067_()) {
            tag.m_128379_("Silent", mob.m_20067_());
        }
        if (mob.m_20068_()) {
            tag.m_128379_("NoGravity", mob.m_20068_());
        }
        if (mob.m_146886_()) {
            tag.m_128379_("Glowing", mob.m_146886_());
        }
        if (mob.m_20147_()) {
            tag.m_128379_("Invulnerable", mob.m_20147_());
        }
        tag.m_128359_("id", mob.self().m_20078_());
        tag.m_128350_("Health", mob.m_21223_());
    }

    public static void loadDefaultDataFromTag(Mob mob, CompoundTag tag) {
        if (tag.m_128441_("CustomName")) {
            mob.m_6593_((Component)Component.m_237113_((String)tag.m_128461_("CustomName")));
        }
        if (tag.m_128441_("NoAI")) {
            mob.m_21557_(tag.m_128471_("NoAI"));
        }
        if (tag.m_128441_("Silent")) {
            mob.m_20225_(tag.m_128471_("Silent"));
        }
        if (tag.m_128441_("NoGravity")) {
            mob.m_20242_(tag.m_128471_("NoGravity"));
        }
        if (tag.m_128441_("Glowing")) {
            mob.m_146915_(tag.m_128471_("Glowing"));
        }
        if (tag.m_128441_("Invulnerable")) {
            mob.m_20331_(tag.m_128471_("Invulnerable"));
        }
        if (tag.m_128441_("Health")) {
            mob.m_21153_(tag.m_128457_("Health"));
        }
    }

    public static <T extends Mob> Optional<InteractionResult> catchWithItem(Player player, InteractionHand hand, T mob, @Nullable CompoundTag extraData) {
        ItemStack stack = player.m_21120_(hand);
        if (mob.m_6084_()) {
            if (((Catchable)mob).canBeCatched(stack)) {
                mob.m_5496_(((Catchable)mob).getPickupSound(), 1.0f, 1.0f);
                if (!stack.m_41619_() && ((Catchable)mob).getCaughtItem(stack).m_41619_()) {
                    CompoundTag tag = stack.m_41784_();
                    ((Catchable)mob).saveDataToTag(mob, tag);
                    if (extraData != null) {
                        tag.m_128391_(extraData);
                    }
                    stack.m_41751_(tag);
                    mob.m_146870_();
                } else if (!((Catchable)mob).getCaughtItem(stack).m_41619_()) {
                    ItemStack capturedStack = ((Catchable)mob).getCaughtItem(stack);
                    CompoundTag tag = !stack.m_41619_() ? stack.m_41784_() : new CompoundTag();
                    ((Catchable)mob).saveDataToTag(mob, tag);
                    if (extraData != null) {
                        tag.m_128391_(extraData);
                    }
                    capturedStack.m_41751_(tag);
                    player.m_21008_(hand, capturedStack);
                    mob.m_146870_();
                } else if (stack.m_41619_() && ((Catchable)mob).getCaughtItem(stack).m_41619_()) {
                    return Optional.empty();
                }
                return Optional.of(InteractionResult.m_19078_((boolean)mob.m_9236_().f_46443_));
            }
            if (((Catchable)mob).cantBeCatchedReason() != null) {
                player.m_5661_(((Catchable)mob).cantBeCatchedReason(), true);
            }
        }
        return Optional.empty();
    }

    public static Mob releaseFromTag(CompoundTag tag, ServerLevel level, Vec3 vec, float yRot, float xRot, @Nullable EntityType<?> fallbackType) {
        Catchable catchable;
        EntityType type;
        if (tag != null && tag.m_128441_("id") && (type = (EntityType)EntityType.m_20632_((String)tag.m_128461_("id")).orElse(null)) != null) {
            Catchable catchable2;
            Entity entity = type.m_20615_((Level)level);
            if (!(entity instanceof Mob)) {
                return null;
            }
            Mob mob = (Mob)entity;
            mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(BlockPos.m_274446_((Position)vec)), MobSpawnType.BUCKET, null, tag);
            mob.m_7678_(vec.f_82479_, vec.f_82480_, vec.f_82481_, yRot, xRot);
            if (mob instanceof Catchable) {
                catchable2 = (Catchable)mob;
                catchable2.loadDataFromTag(mob, tag);
                catchable2.setHasBeenCaught(true);
                level.m_5594_(null, BlockPos.m_274446_((Position)vec), catchable2.getReleaseSound(), mob.m_5720_(), 1.0f, 1.0f);
            }
            level.m_7967_((Entity)mob);
            if (mob instanceof Catchable) {
                catchable2 = (Catchable)mob;
                mob.m_5496_(catchable2.getReleaseSound(), 1.0f, 1.0f);
            }
            return mob;
        }
        Entity entity = fallbackType.m_20615_((Level)level);
        if (!(entity instanceof Mob)) {
            return null;
        }
        Mob mob = (Mob)entity;
        mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(BlockPos.m_274446_((Position)vec)), MobSpawnType.MOB_SUMMONED, null, tag);
        mob.m_7678_(vec.f_82479_, vec.f_82480_, vec.f_82481_, yRot, xRot);
        if (mob instanceof Catchable) {
            catchable = (Catchable)mob;
            catchable.setHasBeenCaught(true);
        }
        level.m_7967_((Entity)mob);
        if (mob instanceof Catchable) {
            catchable = (Catchable)mob;
            mob.m_5496_(catchable.getReleaseSound(), 1.0f, 1.0f);
        }
        return mob;
    }
}

