/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.item;

import com.ninni.spawn.registry.SpawnCriteriaTriggers;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.server.entity.Sunfish;
import com.ninni.spawn.server.entity.common.Catchable;
import com.ninni.spawn.server.item.tooltip.CapturedMobsTooltipData;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CastingNetItem
extends Item {
    public int MAX_CAPACITY = 16;

    public CastingNetItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_().m_121945_(context.m_43719_());
        boolean releasedMob = false;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128425_("CapturedMobs", 9)) {
                ListTag captured = tag.m_128437_("CapturedMobs", 10);
                for (int i = 0; i < captured.size(); ++i) {
                    CompoundTag mobTag = captured.m_128728_(i);
                    EntityType type = EntityType.m_20632_((String)mobTag.m_128461_("id")).orElse(null);
                    if (type == null) continue;
                    mobTag.m_128473_("id");
                    float x = (float)pos.m_123341_() + 0.5f;
                    float y = (float)pos.m_123342_() + 0.5f;
                    float z = (float)pos.m_123343_() + 0.5f;
                    BlockPos.MutableBlockPos spawnPos = new BlockPos.MutableBlockPos((double)x, (double)y, (double)z);
                    LivingEntity entity = (LivingEntity)type.m_262455_(serverLevel, mobTag, null, (BlockPos)spawnPos, MobSpawnType.BUCKET, true, false);
                    if (entity instanceof Bucketable) {
                        Bucketable bucketable = (Bucketable)entity;
                        if (mobTag.m_128441_("CustomName")) {
                            entity.m_6593_((Component)Component.m_237113_((String)mobTag.m_128461_("CustomName")));
                            mobTag.m_128473_("CustomName");
                        }
                        bucketable.m_27497_(true);
                        bucketable.m_142278_(mobTag);
                    }
                    if (entity instanceof Catchable) {
                        Catchable catchable = (Catchable)entity;
                        if (entity instanceof Mob) {
                            Mob mob = (Mob)entity;
                            catchable.setHasBeenCaught(true);
                            catchable.loadDataFromTag(mob, mobTag);
                        }
                    }
                    serverLevel.m_142346_((Entity)context.m_43723_(), GameEvent.f_157810_, pos);
                    releasedMob = true;
                    double particleOffset = (double)captured.size() / 10.0;
                    if (!level.m_6425_((BlockPos)spawnPos).m_205070_(FluidTags.f_13131_)) continue;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5, particleOffset, 0.2, particleOffset, 0.01);
                }
                if (releasedMob) {
                    stack.m_41749_("CapturedMobs");
                    stack.m_41784_().m_128379_("Released", true);
                    level.m_5594_(null, pos, (SoundEvent)SpawnSoundEvents.CASTING_NET_RELEASE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5, 0.2, 0.2, 0.2, 0.01);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack netStack = player.m_21120_(hand);
        CompoundTag netTag = netStack.m_41783_();
        int range = 4;
        if (netTag != null && netTag.m_128441_("Released")) {
            netTag.m_128473_("Released");
            return InteractionResultHolder.m_19098_((Object)netStack);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (netTag == null || !netTag.m_128425_("CapturedMobs", 9)) {
                Entity target = this.getLookAtEntity(player, range);
                List<Mob> mobsInRange = serverLevel.m_6443_(Mob.class, new AABB(player.m_20183_()).m_82400_((double)range), mob -> {
                    Catchable catchable;
                    return mob.m_6084_() && (mob instanceof Bucketable || mob instanceof Catchable && (catchable = (Catchable)mob).canBeCatched(null)) && mob.m_6087_();
                });
                Mob closestMob = null;
                double closestAngle = 0.9;
                Vec3 lookVec = player.m_20154_();
                Vec3 eyePos = player.m_146892_();
                for (Mob mob2 : mobsInRange) {
                    Vec3 toMob = mob2.m_20182_().m_82520_(0.0, (double)(mob2.m_20206_() / 2.0f), 0.0).m_82546_(eyePos).m_82541_();
                    double dot = lookVec.m_82526_(toMob);
                    if (!(dot > closestAngle)) continue;
                    closestAngle = dot;
                    closestMob = mob2;
                }
                if (closestMob != null) {
                    targetType = closestMob.m_6095_();
                    mobsInRange = mobsInRange.stream().filter(mob -> mob.m_6095_() == targetType).toList();
                } else if (target instanceof Mob) {
                    Mob targetMob = (Mob)target;
                    targetType = targetMob.m_6095_();
                    mobsInRange = mobsInRange.stream().filter(mob -> mob.m_6095_() == targetType).toList();
                } else {
                    return InteractionResultHolder.m_19098_((Object)netStack);
                }
                if (mobsInRange.size() >= 2) {
                    ListTag capturedMobs = new ListTag();
                    for (Mob mob3 : mobsInRange) {
                        Sunfish sunfish;
                        if (capturedMobs.size() >= this.MAX_CAPACITY) break;
                        if (mob3 instanceof Sunfish && !(sunfish = (Sunfish)mob3).m_6162_() || !mob3.m_6084_()) continue;
                        CompoundTag tag = null;
                        if (mob3 instanceof Bucketable) {
                            Bucketable bucketable = (Bucketable)mob3;
                            mob3.m_5496_(bucketable.m_142623_(), 1.0f, 1.0f);
                            ItemStack tempBucket = new ItemStack((ItemLike)Items.f_42447_);
                            bucketable.m_6872_(tempBucket);
                            tag = tempBucket.m_41783_();
                        }
                        if (mob3 instanceof Catchable) {
                            Catchable catchable = (Catchable)mob3;
                            tag = new CompoundTag();
                            mob3.m_5496_(catchable.getPickupSound(), 1.0f, 1.0f);
                            catchable.saveDataToTag(mob3, tag);
                        }
                        if (tag != null) {
                            CompoundTag mobTag = tag.m_6426_();
                            mobTag.m_128359_("id", EntityType.m_20613_((EntityType)mob3.m_6095_()).toString());
                            if (mob3.m_8077_()) {
                                mobTag.m_128359_("CustomName", mob3.m_7770_().getString());
                            }
                            capturedMobs.add((Object)mobTag);
                        }
                        mob3.m_146870_();
                    }
                    if (!capturedMobs.isEmpty()) {
                        ServerPlayer serverPlayer;
                        netTag = netStack.m_41784_();
                        netTag.m_128365_("CapturedMobs", (Tag)capturedMobs);
                        level.m_5594_(null, player.m_20183_(), (SoundEvent)SpawnSoundEvents.CASTING_NET_COLLECT.get(), player.m_5720_(), 1.0f, 1.0f);
                        if (!capturedMobs.isEmpty() && player instanceof ServerPlayer) {
                            serverPlayer = (ServerPlayer)player;
                            SpawnCriteriaTriggers.CATCH_WITH_NET.trigger(serverPlayer);
                        }
                        if (capturedMobs.size() == this.MAX_CAPACITY && player instanceof ServerPlayer) {
                            serverPlayer = (ServerPlayer)player;
                            SpawnCriteriaTriggers.CATCH_16_MOBS_WITH_NET.trigger(serverPlayer);
                        }
                        return InteractionResultHolder.m_19090_((Object)netStack);
                    }
                } else if (target instanceof Bucketable || target instanceof Catchable) {
                    Sunfish sunfish;
                    if (target instanceof Sunfish && !(sunfish = (Sunfish)target).m_6162_()) {
                        return InteractionResultHolder.m_19098_((Object)netStack);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"item.spawn.casting_net.only_one_mob", (Object[])new Object[]{Component.m_237115_((String)String.valueOf(target.m_6095_()))}), true);
                    level.m_5594_(null, player.m_20183_(), (SoundEvent)SpawnSoundEvents.CASTING_NET_FAIL.get(), player.m_5720_(), 1.0f, 1.0f);
                    return InteractionResultHolder.m_19090_((Object)netStack);
                }
            }
        }
        return InteractionResultHolder.m_19098_((Object)netStack);
    }

    private @Nullable Entity getLookAtEntity(Player player, double range) {
        Vec3 eyePos = player.m_146892_();
        Vec3 lookVec = player.m_20154_();
        Vec3 reachVec = eyePos.m_82549_(lookVec.m_82490_(range));
        BlockHitResult hit = player.m_9236_().m_45547_(new ClipContext(eyePos, reachVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        double distance = hit.m_82450_().m_82554_(eyePos);
        Entity nearest = null;
        double closest = distance;
        List entities = player.m_9236_().m_6249_((Entity)player, new AABB(eyePos, reachVec).m_82400_(1.0), entity -> entity instanceof Mob && entity.m_6087_());
        for (Entity entity2 : entities) {
            double d;
            AABB aabb = entity2.m_20191_().m_82400_((double)0.3f);
            Optional intercept = aabb.m_82371_(eyePos, reachVec);
            if (!intercept.isPresent() || !((d = eyePos.m_82554_((Vec3)intercept.get())) < closest)) continue;
            nearest = entity2;
            closest = d;
        }
        return nearest;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_("CapturedMobs", 9)) {
            return Optional.empty();
        }
        return Optional.of(new CapturedMobsTooltipData(tag.m_128437_("CapturedMobs", 10)));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("CapturedMobs", 9)) {
            ListTag list = tag.m_128437_("CapturedMobs", 10);
            String id = list.m_128728_(0).m_128461_("id");
            EntityType.m_20632_((String)id).ifPresent(type -> tooltip.add((Component)Component.m_237115_((String)type.m_20675_()).m_130940_(ChatFormatting.BLUE)));
            tooltip.add((Component)Component.m_237113_((String)(list.size() + "/" + this.MAX_CAPACITY)).m_130940_(ChatFormatting.GRAY));
        }
    }
}

