/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.item;

import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.server.entity.Clam;
import com.ninni.spawn.server.entity.common.Catchable;
import com.ninni.spawn.server.entity.variant.ClamVariant;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClamItem
extends Item {
    public ClamItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        Level level = useOnContext.m_43725_();
        Player player = useOnContext.m_43723_();
        ItemStack itemStack = player.m_21120_(useOnContext.m_43724_());
        BlockHitResult blockHitResult = ClamItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockPos = blockHitResult.m_82425_();
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                CompoundTag tag = itemStack.m_41783_();
                Vec3 vec = blockPos.m_252807_().m_82520_(0.0, 0.5, 0.0);
                Catchable.releaseFromTag(tag, serverLevel, vec, useOnContext.m_7074_() - 180.0f, 0.0f, (EntityType)SpawnEntityType.CLAM.get());
                level.m_142346_((Entity)player, GameEvent.f_157810_, blockPos);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6225_(useOnContext);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag != null && compoundTag.m_128425_("ClamVariant", 3)) {
            int i = compoundTag.m_128451_("ClamVariant");
            MutableComponent color = Component.m_237115_((String)("color.minecraft." + Clam.getDyeColor(i)));
            MutableComponent patternName = Component.m_237115_((String)Clam.getPattern(i).patternDisplayName().getString());
            if (!patternName.equals((Object)color) && Clam.getPattern(i) != ClamVariant.Pattern.NO_PATTERN) {
                color.m_130946_(" ").m_7220_((Component)patternName);
                color.m_130948_(Style.f_131099_.m_178520_(Clam.getDyeColor(i).m_41070_()).m_131155_(Boolean.valueOf(true)));
                list.add((Component)color);
            }
            list.add((Component)Clam.getBaseColor(i).colorDisplayName().m_6879_().m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(Clam.getBaseColor(i).getTextColor())).m_130946_(" ").m_7220_((Component)Clam.getBaseColor(i).baseDisplayName().m_6879_().m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(Clam.getBaseColor(i).getTextColor()))));
        } else {
            list.add((Component)Component.m_237115_((String)"entity.spawn.clam.random").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
        super.m_7373_(itemStack, level, list, tooltipFlag);
    }
}

