/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.level;

import com.mojang.serialization.Codec;
import com.ninni.spawn.registry.SpawnBlocks;
import com.ninni.spawn.registry.SpawnTags;
import com.ninni.spawn.server.block.MorayCreviceBlock;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public class DeepReefRockFeature
extends Feature<NoneFeatureConfiguration> {
    public DeepReefRockFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource random = context.m_225041_();
        SimplexNoise noise = new SimplexNoise(random);
        this.createStoneBoulder((LevelAccessor)context.m_159774_(), context.m_159777_(), noise, random.m_188503_(8) + 4, random.m_188503_(32) + 4, random.m_188503_(8) + 4);
        return true;
    }

    private void createStoneBoulder(LevelAccessor level, BlockPos center, SimplexNoise random, int radiusX, int sizeY, int radiusZ) {
        for (int x = -radiusX; x <= radiusX; ++x) {
            for (int y = -3; y <= sizeY; ++y) {
                for (int z = -radiusZ; z <= radiusZ; ++z) {
                    double xx = (double)(x * x) / (double)(radiusX * radiusX);
                    double yy = (double)(y * y) / (double)(sizeY * sizeY);
                    double zz = (double)(z * z) / (double)(radiusZ * radiusZ);
                    BlockPos pos = center.m_7918_(x, y, z);
                    double noiseValue = random.m_75467_((double)pos.m_123341_() * 0.1, (double)pos.m_123342_() * 0.1, (double)pos.m_123343_() * 0.1);
                    if (!(xx + yy + zz <= 0.5 + 0.5 * noiseValue) || !level.m_8055_(pos).m_204336_(SpawnTags.REPLACEABLE_BY_BOULDER)) continue;
                    boolean neighbor = false;
                    for (Direction direction : Direction.values()) {
                        if (!level.m_8055_(pos.m_121945_(direction)).m_280296_()) continue;
                        neighbor = true;
                        break;
                    }
                    if (!neighbor) continue;
                    if ((double)y < (double)sizeY * 0.1 || (double)y < (double)sizeY * 0.3 && level.m_213780_().m_188499_()) {
                        level.m_7731_(pos, ((Block)SpawnBlocks.ALGAL_REEFSTONE.get()).m_49966_(), 3);
                    } else {
                        level.m_7731_(pos, ((Block)SpawnBlocks.REEFSTONE.get()).m_49966_(), 3);
                    }
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        BlockPos relativePos;
                        BlockPos relativePos2;
                        if (level.m_213780_().m_188501_() < 0.01f && (level.m_8055_(relativePos2 = pos.m_5484_(direction, 1)).m_60713_((Block)SpawnBlocks.REEFSTONE.get()) || level.m_8055_(relativePos2).m_60713_((Block)SpawnBlocks.ALGAL_REEFSTONE.get())) && level.m_8055_(pos.m_5484_(direction, 2)).m_60713_(Blocks.f_49990_)) {
                            level.m_7731_(relativePos2, (BlockState)((BlockState)((Block)SpawnBlocks.MORAY_CREVICE.get()).m_49966_().m_61124_((Property)MorayCreviceBlock.FACING, (Comparable)direction)).m_61124_((Property)MorayCreviceBlock.SUBMERGED, (Comparable)Boolean.valueOf(true)), 3);
                        }
                        if (level.m_213780_().m_188501_() < 0.002f) {
                            BlockPos relativePos3 = pos.m_5484_(direction, 2);
                            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                            int width = level.m_213780_().m_188503_(2) + 1;
                            Optional<Block> optional = BuiltInRegistries.f_256975_.m_203431_(SpawnTags.DEEP_CORAL_BLOCKS).flatMap(p_224980_ -> p_224980_.m_213653_(level.m_213780_())).map(Holder::m_203334_);
                            for (int coralX = -width; coralX <= width; ++coralX) {
                                for (int coralZ = -width; coralZ <= width; ++coralZ) {
                                    if (coralX * coralX + coralZ * coralZ > width * width) continue;
                                    mutablePos.m_122178_(relativePos3.m_123341_() + coralX, relativePos3.m_123342_(), relativePos3.m_123343_() + coralZ);
                                    if (!optional.isPresent() || !level.m_8055_((BlockPos)mutablePos).m_60713_(Blocks.f_49990_) && !level.m_8055_((BlockPos)mutablePos).m_60713_(Blocks.f_50037_) && !level.m_8055_((BlockPos)mutablePos).m_60713_(Blocks.f_50038_) && !level.m_8055_((BlockPos)mutablePos).m_60713_(Blocks.f_50567_)) continue;
                                    level.m_7731_((BlockPos)mutablePos, optional.get().m_49966_(), 3);
                                    if (!(level.m_213780_().m_188501_() < 0.1f) || !level.m_8055_(mutablePos.m_7494_()).m_60713_(Blocks.f_49990_) && !level.m_8055_(mutablePos.m_7494_()).m_60713_(Blocks.f_50037_) && !level.m_8055_(mutablePos.m_7494_()).m_60713_(Blocks.f_50038_) && !level.m_8055_(mutablePos.m_7494_()).m_60713_(Blocks.f_50567_)) continue;
                                    BuiltInRegistries.f_256975_.m_203431_(SpawnTags.DEEP_CORALS).flatMap(holders -> holders.m_213653_(level.m_213780_())).map(Holder::m_203334_).ifPresent(coralPlant -> level.m_7731_(mutablePos.m_7494_(), coralPlant.m_49966_(), 2));
                                }
                            }
                        }
                        if (!(level.m_213780_().m_188501_() < 0.02f) || !level.m_8055_(relativePos = pos.m_121945_(direction)).m_60713_(Blocks.f_49990_) && !level.m_8055_(relativePos).m_60713_(Blocks.f_50037_) && !level.m_8055_(relativePos).m_60713_(Blocks.f_50038_)) continue;
                        BuiltInRegistries.f_256975_.m_203431_(SpawnTags.DEEP_WALL_CORALS).flatMap(p_224965_ -> p_224965_.m_213653_(level.m_213780_())).map(Holder::m_203334_).ifPresent(p_204725_ -> {
                            BlockState blockstate1 = p_204725_.m_49966_();
                            if (blockstate1.m_61138_((Property)BaseCoralWallFanBlock.f_49192_)) {
                                blockstate1 = (BlockState)blockstate1.m_61124_((Property)BaseCoralWallFanBlock.f_49192_, (Comparable)direction);
                            }
                            level.m_7731_(relativePos, blockstate1, 2);
                        });
                    }
                    if (!level.m_8055_(pos.m_7494_()).m_247087_() || !level.m_213780_().m_188499_()) continue;
                    boolean waterlogged = level.m_6425_(pos.m_7494_()).m_205070_(FluidTags.f_13131_);
                    if ((double)level.m_213780_().m_188501_() < 0.1) {
                        level.m_7731_(pos.m_7494_(), (BlockState)((BlockState)Blocks.f_50567_.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(waterlogged))).m_61124_((Property)SeaPickleBlock.f_56074_, (Comparable)Integer.valueOf(1 + level.m_213780_().m_188503_(2))), 3);
                        continue;
                    }
                    level.m_7731_(pos.m_7494_(), (BlockState)((Block)SpawnBlocks.RED_ALGAE.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(waterlogged)), 3);
                }
            }
        }
    }
}

