/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.level;

import com.mojang.serialization.Codec;
import com.ninni.spawn.registry.SpawnBlocks;
import com.ninni.spawn.server.block.RedAlgaePlantBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class RockyShoreRockFeature
extends Feature<NoneFeatureConfiguration> {
    public RockyShoreRockFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel level = ctx.m_159774_();
        RandomSource random = ctx.m_225041_();
        BlockPos origin = ctx.m_159777_();
        int width = Mth.m_216271_((RandomSource)random, (int)3, (int)4);
        int depth = Mth.m_216271_((RandomSource)random, (int)2, (int)4);
        int height = Mth.m_216271_((RandomSource)random, (int)2, (int)3);
        float rx = (float)width / 2.0f;
        float rz = (float)depth / 2.0f;
        float ry = (float)height / 2.0f;
        float wobble = 0.25f;
        int wobbleSteps = 16;
        float[] wobbleTable = new float[wobbleSteps];
        for (int i = 0; i < wobbleSteps; ++i) {
            wobbleTable[i] = 1.0f + (random.m_188501_() * 2.0f - 1.0f) * wobble;
        }
        int minX = origin.m_123341_() - (int)Math.ceil(rx) - 1;
        int maxX = origin.m_123341_() + (int)Math.ceil(rx) + 1;
        int minZ = origin.m_123343_() - (int)Math.ceil(rz) - 1;
        int maxZ = origin.m_123343_() + (int)Math.ceil(rz) + 1;
        int minY = level.m_141937_() + 3;
        HashMap<BlockPos, Integer> floorY = new HashMap<BlockPos, Integer>();
        HashSet<BlockPos> underwaterCols = new HashSet<BlockPos>();
        boolean anyUnderwater = false;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                boolean colUnderwater;
                int startY;
                int y;
                if (!RockyShoreRockFeature.insideFootprint(origin, x, z, rx, rz, wobbleTable, wobbleSteps) || (y = this.findFloorY(level, x, startY = Math.min(origin.m_123342_(), level.m_151558_()), z, minY)) <= minY) continue;
                BlockPos base = new BlockPos(x, y + 1, z);
                floorY.put(new BlockPos(x, 0, z), y);
                boolean bl = colUnderwater = level.m_6425_(base).m_205070_(FluidTags.f_13131_) || level.m_6425_(base.m_7494_()).m_205070_(FluidTags.f_13131_);
                if (!colUnderwater) continue;
                anyUnderwater = true;
                underwaterCols.add(new BlockPos(x, 0, z));
            }
        }
        if (floorY.isEmpty()) {
            return false;
        }
        BlockState rock = anyUnderwater ? ((Block)SpawnBlocks.ALGAL_REEFSTONE.get()).m_49966_() : ((Block)SpawnBlocks.REEFSTONE.get()).m_49966_();
        boolean placedAny = false;
        ArrayList<BlockPos> placedRock = new ArrayList<BlockPos>();
        HashSet<BlockPos> footprintXZ = new HashSet<BlockPos>();
        for (Map.Entry entry : floorY.entrySet()) {
            int x = ((BlockPos)entry.getKey()).m_123341_();
            int z = ((BlockPos)entry.getKey()).m_123343_();
            int yFloor = (Integer)entry.getValue();
            float r2 = RockyShoreRockFeature.radialNorm2(origin, x, z, rx, rz, wobbleTable, wobbleSteps);
            int column = 1 + Mth.m_14143_((float)((1.0f - r2) * ry * 1.8f));
            column = Mth.m_14045_((int)column, (int)1, (int)height);
            BlockPos base = new BlockPos(x, yFloor + 1, z);
            if (!RockyShoreRockFeature.isGoodFloor(level.m_8055_(base.m_7495_()))) continue;
            for (int dy = 0; dy < column; ++dy) {
                BlockPos p = base.m_6630_(dy);
                if (!RockyShoreRockFeature.canOverwrite((LevelAccessor)level, p)) continue;
                level.m_7731_(p, rock, 2);
                placedAny = true;
                placedRock.add(p.m_7949_());
                footprintXZ.add(new BlockPos(x, 0, z));
            }
        }
        if (!placedAny) {
            return false;
        }
        RockyShoreRockFeature.spreadGravel(level, footprintXZ, floorY, random);
        RockyShoreRockFeature.sprinkleRedAlgae(level, random, placedRock);
        return true;
    }

    private int findFloorY(WorldGenLevel level, int x, int startY, int z, int minY) {
        BlockPos cur = new BlockPos(x, startY, z);
        while (cur.m_123342_() > minY) {
            BlockPos below = cur.m_7495_();
            BlockState s = level.m_8055_(below);
            if (!s.m_60795_() && !s.m_60819_().m_76178_() && s.m_60819_().m_205070_(FluidTags.f_13131_)) {
                cur = below;
                continue;
            }
            if (RockyShoreRockFeature.isGoodFloor(s)) {
                return below.m_123342_();
            }
            cur = below;
        }
        return minY;
    }

    private static boolean isGoodFloor(BlockState state) {
        return state.m_280296_();
    }

    private static boolean canOverwrite(LevelAccessor level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60795_() || state.m_60819_().m_205070_(FluidTags.f_13131_) || state.m_204336_(BlockTags.f_278394_);
    }

    private static boolean insideFootprint(BlockPos origin, int x, int z, float rx, float rz, float[] wobble, int steps) {
        float nz;
        double ang = Math.atan2(z - origin.m_123343_(), x - origin.m_123341_());
        int idx = (int)Math.floor((ang + Math.PI) / (Math.PI * 2) * (double)steps) % steps;
        float mul = wobble[(idx + steps) % steps];
        float nx = (float)(x - origin.m_123341_()) / (rx * mul);
        return nx * nx + (nz = (float)(z - origin.m_123343_()) / (rz * mul)) * nz <= 1.0f;
    }

    private static float radialNorm2(BlockPos origin, int x, int z, float rx, float rz, float[] wobble, int steps) {
        double ang = Math.atan2(z - origin.m_123343_(), x - origin.m_123341_());
        int idx = (int)Math.floor((ang + Math.PI) / (Math.PI * 2) * (double)steps) % steps;
        float mul = wobble[(idx + steps) % steps];
        float nx = (float)(x - origin.m_123341_()) / (rx * mul);
        float nz = (float)(z - origin.m_123343_()) / (rz * mul);
        return nx * nx + nz * nz;
    }

    private static void spreadGravel(WorldGenLevel level, Set<BlockPos> footprintXZ, Map<BlockPos, Integer> floorY, RandomSource random) {
        for (BlockPos fp : footprintXZ) {
            int x = fp.m_123341_();
            int z = fp.m_123343_();
            int yFloor = floorY.getOrDefault(fp, level.m_141937_());
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos p = new BlockPos(x + dx, yFloor, z + dz);
                    BlockState st = level.m_8055_(p);
                    if (!st.m_204336_(BlockTags.f_13029_) || !((double)random.m_188501_() > 0.2)) continue;
                    level.m_7731_(p, Blocks.f_49994_.m_49966_(), 2);
                }
            }
        }
    }

    private static void sprinkleRedAlgae(WorldGenLevel level, RandomSource random, List<BlockPos> rockBlocks) {
        if (rockBlocks.isEmpty() || (double)random.m_188501_() > 0.5) {
            return;
        }
        int tries = Math.min(6, 2 + rockBlocks.size() / 6);
        BlockState algae = ((Block)SpawnBlocks.RED_ALGAE.get()).m_49966_();
        for (int t = 0; t < tries; ++t) {
            BlockPos[] candidates;
            BlockPos base = rockBlocks.get(random.m_188503_(rockBlocks.size()));
            for (BlockPos pos : candidates = new BlockPos[]{base.m_7494_(), base.m_122012_(), base.m_122019_(), base.m_122029_(), base.m_122024_()}) {
                if (random.m_188501_() > 0.9f || !algae.m_60710_((LevelReader)level, pos) || !level.m_8055_(pos).m_60795_() && !level.m_8055_(pos).m_60819_().m_205070_(FluidTags.f_13131_)) continue;
                level.m_7731_(pos, (BlockState)algae.m_61124_((Property)RedAlgaePlantBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_205070_(FluidTags.f_13131_))), 2);
            }
        }
    }
}

