/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.network;

import com.google.common.collect.BiMap;
import com.ninni.spawn.Spawn;
import com.ninni.spawn.server.data.AnthillRotManager;
import com.ninni.spawn.server.network.SyncJsonResourcePacket;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class AnthillRotSyncPacket
extends SyncJsonResourcePacket<AnthillRotManager.AnthillRotData> {
    public AnthillRotSyncPacket(BiMap<ResourceLocation, AnthillRotManager.AnthillRotData> registryMap) {
        super(registryMap);
    }

    public AnthillRotSyncPacket() {
    }

    @Override
    protected AnthillRotManager.AnthillRotData readJsonObject(FriendlyByteBuf buf) {
        return AnthillRotManager.AnthillRotData.fromNetwork(buf);
    }

    @Override
    protected void writeJsonObject(FriendlyByteBuf buf, AnthillRotManager.AnthillRotData toWrite) {
        toWrite.toNetwork(buf);
    }

    public static AnthillRotSyncPacket read(FriendlyByteBuf buf) {
        AnthillRotSyncPacket message = new AnthillRotSyncPacket();
        message.readMap(buf);
        return message;
    }

    public static void write(AnthillRotSyncPacket message, FriendlyByteBuf buf) {
        message.writeMap(buf);
    }

    public static void handle(AnthillRotSyncPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                Spawn.PROXY.getAnthillRotManager().synchronizeRegistryForClient((BiMap<ResourceLocation, AnthillRotManager.AnthillRotData>)message.registryMap);
            }
        });
    }
}

