/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.network;

import com.ninni.spawn.Spawn;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class BlockEntitySyncPacket {
    final BlockPos pos;
    final CompoundTag tag;

    public BlockEntitySyncPacket(BlockPos pos, CompoundTag tag) {
        this.pos = pos;
        this.tag = tag;
    }

    public static void write(BlockEntitySyncPacket object, FriendlyByteBuf buffer) {
        buffer.m_130064_(object.pos);
        buffer.m_130079_(object.tag);
    }

    public static BlockEntitySyncPacket read(FriendlyByteBuf buffer) {
        return new BlockEntitySyncPacket(buffer.m_130135_(), buffer.m_130260_());
    }

    public static void handle(BlockEntitySyncPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level world;
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                world = Spawn.PROXY.getWorld();
            } else {
                if (sender == null) {
                    return;
                }
                world = sender.m_9236_();
            }
            BlockEntity t = world.m_7702_(packet.pos);
            if (t != null) {
                t.m_142466_(packet.tag);
                t.m_6596_();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

