/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.network;

import com.ninni.spawn.client.ClientEventsHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class OpenHamsterScreenPacket {
    private final int containerId;
    private final int size;
    private final int entityId;

    public OpenHamsterScreenPacket(int id, int size, int entityId) {
        this.containerId = id;
        this.size = size;
        this.entityId = entityId;
    }

    public static OpenHamsterScreenPacket read(FriendlyByteBuf buf) {
        short containerId = buf.readUnsignedByte();
        int size = buf.m_130242_();
        int entityId = buf.readInt();
        return new OpenHamsterScreenPacket(containerId, size, entityId);
    }

    public static void write(OpenHamsterScreenPacket packet, FriendlyByteBuf buf) {
        buf.writeByte(packet.containerId);
        buf.m_130130_(packet.size);
        buf.writeInt(packet.entityId);
    }

    public static void handle(OpenHamsterScreenPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientEventsHandler.openHamsterInventoryScreen(packet));
        ctx.get().setPacketHandled(true);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getSize() {
        return this.size;
    }

    public int getEntityId() {
        return this.entityId;
    }
}

