/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.network;

import com.ninni.spawn.Spawn;
import com.ninni.spawn.server.entity.Stickbug;
import com.ninni.spawn.server.entity.common.DancesToJukebox;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SetDancingPacket {
    private final int entityId;
    private final boolean dancing;
    private final BlockPos jukeboxPos;

    public SetDancingPacket(int entityUUID, boolean dancing, BlockPos jukeboxPos) {
        this.entityId = entityUUID;
        this.dancing = dancing;
        this.jukeboxPos = jukeboxPos;
    }

    public static SetDancingPacket read(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        boolean dancing = buf.readBoolean();
        BlockPos jukebocPos = buf.m_130135_();
        return new SetDancingPacket(entityId, dancing, jukebocPos);
    }

    public static void write(SetDancingPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.entityId);
        buf.writeBoolean(packet.dancing);
        buf.m_130064_(packet.jukeboxPos);
    }

    public static void handle(SetDancingPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> SetDancingPacket.lambda$handle$0((Supplier)ctx, packet)));
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$0(Supplier ctx, SetDancingPacket packet) {
        Entity entity;
        ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
        if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            player = Spawn.PROXY.getClientPlayer();
        }
        if (player != null && (entity = player.m_9236_().m_6815_(packet.entityId)) instanceof DancesToJukebox) {
            Stickbug stickbug;
            DancesToJukebox dancer = (DancesToJukebox)entity;
            if (entity instanceof Stickbug && !(stickbug = (Stickbug)entity).getItem().m_41619_()) {
                stickbug.stopHiding(null, false);
            }
            dancer.setDancing(packet.dancing);
            dancer.setJukeboxPos(packet.dancing ? packet.jukeboxPos : null);
        }
    }
}

