/*
 * Decompiled with CFR 0.152.
 */
package com.notcharrow.notcharrowutils.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.notcharrow.notcharrowutils.helper.TextFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class InventoryInfo {
    private static final class_310 client = class_310.method_1551();

    public static LiteralArgumentBuilder<FabricClientCommandSource> registerCommand() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"inventoryinfo").executes(InventoryInfo::execute);
    }

    private static int execute(CommandContext<FabricClientCommandSource> context) {
        HashMap<class_1792, Integer> items = new HashMap<class_1792, Integer>();
        class_1661 playerInventory = InventoryInfo.client.field_1724.method_31548();
        for (int slot = 0; slot < playerInventory.method_5439(); ++slot) {
            class_1799 stack = playerInventory.method_5438(slot);
            if (stack.method_7960()) continue;
            items.merge(stack.method_7909(), stack.method_7947(), Integer::sum);
        }
        List<Map.Entry> sortedItems = items.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue).reversed().thenComparing(entry -> ((class_1792)entry.getKey()).method_63680().getString())).toList();
        String result = sortedItems.stream().map(entry -> {
            int count = (Integer)entry.getValue();
            int stacks = count / 64;
            int remainder = count % 64;
            String formatted = ((class_1792)entry.getKey()).method_63680().getString() + " x " + count;
            if (stacks > 0 && remainder > 0) {
                formatted = formatted + " (" + stacks + "s + " + remainder + ")";
            } else if (stacks > 0) {
                formatted = formatted + " (" + stacks + "s)";
            }
            return formatted;
        }).collect(Collectors.joining("\n"));
        InventoryInfo.client.field_1724.method_7353(TextFormat.styledText("Inventory Contents:"), false);
        InventoryInfo.client.field_1724.method_7353(TextFormat.styledText(result), false);
        return 1;
    }
}

