/*
 * Decompiled with CFR 0.152.
 */
package com.notcharrow.notcharrowutils.commands;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.notcharrow.notcharrowutils.helper.TextFormat;
import com.notcharrow.notcharrowutils.mixin.BookEditScreenAccessor;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_473;
import net.minecraft.class_9262;
import net.minecraft.class_9301;

@Environment(value=EnvType.CLIENT)
public class Notes {
    private static final class_310 client = class_310.method_1551();
    private static boolean openBook = false;
    private static class_473 lastBookScreen = null;
    private static ArrayList<class_9262<String>> savedPages = new ArrayList();
    private static class_9301 currentBookContent = new class_9301(savedPages);
    private static final Gson GSON = new Gson();
    private static final Path NOTES_FILE = Path.of("config/notcharrowutils_notes.json", new String[0]);

    public static LiteralArgumentBuilder<FabricClientCommandSource> registerCommand() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"notes").executes(Notes::execute);
    }

    private static int execute(CommandContext<FabricClientCommandSource> context) {
        if (Notes.client.field_1724 != null) {
            if (Notes.client.field_1724.method_31548().method_5438(Notes.client.field_1724.method_31548().method_67532()).method_7909() == class_1802.field_8674) {
                Notes.client.field_1724.method_7353(TextFormat.styledText("Cannot open notes while holding a book."), false);
            }
            openBook = true;
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                if (client.field_1724 != null && client.field_1724.method_31548().method_5438(client.field_1724.method_31548().method_67532()).method_7909() != class_1802.field_8674) {
                    if (openBook) {
                        openBook = false;
                        currentBookContent = new class_9301(savedPages);
                        client.method_1507((class_437)new class_473((class_1657)client.field_1724, new class_1799((class_1935)class_1802.field_8674), class_1268.field_5808, currentBookContent));
                    }
                    if (client.field_1755 instanceof class_473) {
                        lastBookScreen = (class_473)client.field_1755;
                    } else if (lastBookScreen != null) {
                        BookEditScreenAccessor accessor = (BookEditScreenAccessor)lastBookScreen;
                        List<String> editedPages = accessor.getPages();
                        savedPages.clear();
                        for (String page : editedPages) {
                            savedPages.add((class_9262<String>)class_9262.method_57137((Object)page));
                        }
                        Notes.saveNotesToFile();
                        lastBookScreen = null;
                    }
                }
            });
        }
        return 1;
    }

    private static void saveNotesToFile() {
        try {
            List<String> pageStrings = savedPages.stream().map(class_9262::comp_2369).toList();
            String json = GSON.toJson(pageStrings);
            Files.writeString(NOTES_FILE, (CharSequence)json, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadNotesFromFile() {
        savedPages.clear();
        if (Files.exists(NOTES_FILE, new LinkOption[0])) {
            try {
                String json = Files.readString(NOTES_FILE);
                Type listType = new TypeToken<List<String>>(){}.getType();
                List pages = (List)GSON.fromJson(json, listType);
                for (String page : pages) {
                    savedPages.add((class_9262<String>)class_9262.method_57137((Object)page));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            savedPages.add((class_9262<String>)class_9262.method_57137((Object)"These notes persist across worlds, servers, and sessions. Store coordinates, build ideas, and more!"));
        }
    }

    static {
        Notes.loadNotesFromFile();
    }
}

