/*
 * Decompiled with CFR 0.152.
 */
package com.notcharrow.notcharrowutils.ticks;

import com.notcharrow.notcharrowutils.config.ConfigManager;
import com.notcharrow.notcharrowutils.config.NotchArrowUtilsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class OverlayTickHandler {
    private static final class_310 client = class_310.method_1551();
    private static final class_2960 OVERLAY_LAYER = class_2960.method_60655((String)"com.notcharrow.notcharrowutils", (String)"overlay");
    private static List<class_2561> overlayLines = new ArrayList<class_2561>();

    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null && client.field_1687 != null && client.field_1765 != null && client.method_1562() != null && ConfigManager.config.tickregistryOverlay) {
                overlayLines = new ArrayList<class_2561>();
                if (ConfigManager.config.tickregistryOverlayCoordinates) {
                    overlayLines.add(class_2561.method_30163((String)(client.field_1724.method_31477() + ", " + client.field_1724.method_31478() + ", " + client.field_1724.method_31479())));
                }
                if (ConfigManager.config.tickregistryOverlayHeldDurability) {
                    class_1799 itemStack = client.field_1724.method_6047();
                    int durability = itemStack.method_7936() - itemStack.method_7919();
                    overlayLines.add(class_2561.method_30163((String)("Durability: " + durability)));
                }
                if (ConfigManager.config.tickregistryOverlayFPS) {
                    overlayLines.add(class_2561.method_30163((String)("FPS: " + client.method_47599())));
                }
                if (ConfigManager.config.tickregistryOverlayPing) {
                    int ping = Objects.requireNonNull(client.method_1562().method_2871(client.field_1724.method_5667())).method_2959();
                    overlayLines.add(class_2561.method_30163((String)("Ping: " + ping + "ms")));
                }
                if (ConfigManager.config.tickregistryOverlaySpeed) {
                    double xVelocity = client.field_1724.method_18798().field_1352;
                    double zVelocity = client.field_1724.method_18798().field_1350;
                    double totalVelocity = Math.sqrt(Math.pow(xVelocity, 2.0) + Math.pow(zVelocity, 2.0)) * 20.0;
                    Object displayVelocity = String.valueOf(totalVelocity = (double)Math.round(totalVelocity * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0));
                    if (((String)displayVelocity).length() == 3) {
                        displayVelocity = (String)displayVelocity + "0";
                    }
                    overlayLines.add(class_2561.method_30163((String)("Speed: " + (String)displayVelocity + "m/s")));
                }
                if (ConfigManager.config.tickregistryOverlayFacing) {
                    float yaw = client.field_1724.method_36454() % 360.0f;
                    if (yaw < 0.0f) {
                        yaw += 360.0f;
                    }
                    String cardinal = (double)(yaw % 360.0f) >= 337.5 || (double)(yaw % 360.0f) < 22.5 ? "S" : ((double)yaw < 67.5 ? "SW" : ((double)yaw < 112.5 ? "W" : ((double)yaw < 157.5 ? "NW" : ((double)yaw < 202.5 ? "N" : ((double)yaw < 247.5 ? "NE" : ((double)yaw < 292.5 ? "E" : "SE"))))));
                    String coordChange = "";
                    class_2350 facing = class_2350.method_10150((double)client.field_1724.method_36454());
                    if (facing.method_10166() == class_2350.class_2351.field_11048) {
                        coordChange = facing.method_10171() == class_2350.class_2352.field_11056 ? "(+X)" : "(-X)";
                    } else if (facing.method_10166() == class_2350.class_2351.field_11051) {
                        coordChange = facing.method_10171() == class_2350.class_2352.field_11056 ? "(+Z)" : "(-Z)";
                    }
                    overlayLines.add(class_2561.method_30163((String)("Facing: " + cardinal + " " + coordChange)));
                }
                if (ConfigManager.config.tickregistryOverlayDay) {
                    long day = client.field_1687.method_8532() / 24000L;
                    overlayLines.add(class_2561.method_30163((String)("Day: " + day)));
                }
                if (ConfigManager.config.tickregistryOverlayTime) {
                    long time = client.field_1687.method_8532();
                    int hour = (int)(time / 1000L + 6L) % 24;
                    Object minute = String.valueOf((int)((double)time / 16.6666667 % 60.0));
                    if (((String)minute).length() == 1) {
                        minute = "0" + (String)minute;
                    }
                    overlayLines.add(class_2561.method_30163((String)("Time: " + hour + ":" + (String)minute)));
                }
                if (ConfigManager.config.tickregistryOverlayBiome) {
                    String biome = "N/A";
                    if (client.field_1687.method_23753(client.field_1724.method_24515()).method_40230().isPresent()) {
                        biome = ((class_5321)client.field_1687.method_23753(client.field_1724.method_24515()).method_40230().get()).method_29177().method_12832();
                        String[] parts = biome.split("_");
                        StringBuilder displayName = new StringBuilder();
                        for (String part : parts) {
                            if (part.isEmpty()) continue;
                            displayName.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1)).append(" ");
                        }
                        biome = displayName.toString().trim();
                    }
                    overlayLines.add(class_2561.method_30163((String)("Biome: " + biome)));
                }
                if (ConfigManager.config.tickregistryOverlayTargetedBlock) {
                    Object blockName = "";
                    if (client.field_1765.method_17783() == class_239.class_240.field_1332) {
                        class_3965 blockHit = (class_3965)client.field_1765;
                        class_2248 block = client.field_1687.method_8320(blockHit.method_17777()).method_26204();
                        blockName = block.method_9518().getString();
                        blockName = Character.toUpperCase(((String)blockName).charAt(0)) + ((String)blockName).substring(1);
                    }
                    overlayLines.add(class_2561.method_30163((String)("Targeted Block: " + (String)blockName)));
                }
            }
        });
        HudRenderCallback.EVENT.register(OverlayTickHandler::render);
    }

    private static void render(class_332 context, class_9779 tickCounter) {
        if (ConfigManager.config.tickregistryOverlay) {
            class_327 textRenderer = OverlayTickHandler.client.field_1772;
            Matrix3x2fStack matrices = context.method_51448();
            float scale = ConfigManager.config.tickregistryOverlayScale;
            int color = -1;
            int y = ConfigManager.config.tickregistryOverlayLocation == NotchArrowUtilsConfig.OverlayLocation.TOP_LEFT || ConfigManager.config.tickregistryOverlayLocation == NotchArrowUtilsConfig.OverlayLocation.TOP_RIGHT ? (int)(5.0f * scale) : (int)((float)client.method_22683().method_4502() - 20.0f * scale);
            for (class_2561 displayText : overlayLines) {
                int x = ConfigManager.config.tickregistryOverlayLocation == NotchArrowUtilsConfig.OverlayLocation.TOP_LEFT || ConfigManager.config.tickregistryOverlayLocation == NotchArrowUtilsConfig.OverlayLocation.BOTTOM_LEFT ? (int)(5.0f * scale) : (int)((float)client.method_22683().method_4486() - (float)textRenderer.method_27525((class_5348)displayText) * scale - 5.0f * scale);
                matrices.pushMatrix();
                matrices.translate((float)x, (float)y);
                matrices.scale(scale, scale);
                context.method_51439(textRenderer, displayText, 0, 0, color, ConfigManager.config.tickregistryOverlayTextShadow);
                matrices.popMatrix();
                if (ConfigManager.config.tickregistryOverlayLocation == NotchArrowUtilsConfig.OverlayLocation.TOP_LEFT || ConfigManager.config.tickregistryOverlayLocation == NotchArrowUtilsConfig.OverlayLocation.TOP_RIGHT) {
                    y += (int)(10.0f * scale);
                    continue;
                }
                y -= (int)(10.0f * scale);
            }
        }
    }
}

