/*
 * Decompiled with CFR 0.152.
 */
package com.notcharrow.notcharrowutils.ticks;

import com.notcharrow.notcharrowutils.config.ConfigManager;
import com.notcharrow.notcharrowutils.config.NotchArrowUtilsConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class PickupNotifierTickHandler {
    private static final Map<String, Integer> pickupDisplay = new HashMap<String, Integer>();
    private static final Map<String, Integer> pickupTimers = new HashMap<String, Integer>();
    private static final Map<String, Integer> previousCounts = new HashMap<String, Integer>();
    private static final class_2960 PICKUP_LAYER = class_2960.method_60655((String)"com.notcharrow.notcharrowutils", (String)"pickupnotifier");

    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null) {
                return;
            }
            if (!ConfigManager.config.tickregistryPickupNotifier) {
                pickupDisplay.clear();
                pickupTimers.clear();
                return;
            }
            int DISPLAY_TIME = ConfigManager.config.tickregistryPickupNotifierTime * 20;
            HashMap<String, Integer> currentCounts = new HashMap<String, Integer>();
            for (class_1799 stack : client.field_1724.method_31548()) {
                if (stack.method_7960()) continue;
                String itemName = stack.method_7909().method_63680().getString();
                currentCounts.put(itemName, currentCounts.getOrDefault(itemName, 0) + stack.method_7947());
            }
            for (String itemName : currentCounts.keySet()) {
                int previousCount;
                int count = (Integer)currentCounts.get(itemName);
                if (count > (previousCount = previousCounts.getOrDefault(itemName, 0).intValue())) {
                    int pickedUpAmount = count - previousCount;
                    pickupDisplay.merge(itemName, pickedUpAmount, Integer::sum);
                    pickupTimers.put(itemName, DISPLAY_TIME);
                    continue;
                }
                if (count >= previousCount) continue;
                int droppedAmount = previousCount - count;
                int newTotal = pickupDisplay.getOrDefault(itemName, 0) - droppedAmount;
                if (newTotal != 0) {
                    pickupDisplay.put(itemName, newTotal);
                    pickupTimers.put(itemName, DISPLAY_TIME);
                    continue;
                }
                pickupDisplay.remove(itemName);
                pickupTimers.remove(itemName);
            }
            for (String itemName : previousCounts.keySet()) {
                if (currentCounts.containsKey(itemName) || previousCounts.get(itemName) <= 0) continue;
                int droppedAmount = previousCounts.get(itemName);
                pickupDisplay.put(itemName, pickupDisplay.getOrDefault(itemName, 0) - droppedAmount);
                pickupTimers.put(itemName, DISPLAY_TIME);
            }
            previousCounts.clear();
            previousCounts.putAll(currentCounts);
            Iterator<Map.Entry<String, Integer>> iterator = pickupTimers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Integer> entry = iterator.next();
                String itemName = entry.getKey();
                int timeLeft = entry.getValue() - 1;
                if (timeLeft <= 0) {
                    iterator.remove();
                    pickupDisplay.remove(itemName);
                    pickupTimers.remove(itemName);
                    continue;
                }
                entry.setValue(timeLeft);
            }
        });
        HudRenderCallback.EVENT.register(PickupNotifierTickHandler::render);
    }

    private static void render(class_332 context, class_9779 tickCounter) {
        int yIncrement;
        int y;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || pickupDisplay.isEmpty()) {
            return;
        }
        class_327 textRenderer = client.field_1772;
        ArrayList<Map.Entry<String, Integer>> sortedEntries = new ArrayList<Map.Entry<String, Integer>>(pickupDisplay.entrySet());
        if (ConfigManager.config.tickregistryPickupNotifierLocation == NotchArrowUtilsConfig.PickupNotifierLocation.TOP_LEFT || ConfigManager.config.tickregistryPickupNotifierLocation == NotchArrowUtilsConfig.PickupNotifierLocation.TOP_RIGHT) {
            y = 20;
            yIncrement = 10;
            sortedEntries.sort(Comparator.comparing(e -> (Integer)e.getValue() < 0 ? 1 : 0).thenComparing(e -> ((String)e.getKey()).toLowerCase()));
        } else {
            y = client.method_22683().method_4502() - 20;
            yIncrement = -10;
            sortedEntries.sort(Comparator.comparing(e -> (Integer)e.getValue() < 0 ? 1 : 0).thenComparing(e -> ((String)e.getKey()).toLowerCase()).reversed());
        }
        for (Map.Entry entry : sortedEntries) {
            int x;
            int color;
            String displayText;
            String itemName = (String)entry.getKey();
            int count = (Integer)entry.getValue();
            if (count > 0) {
                displayText = "+ " + itemName + " x" + count;
                color = -11141291;
            } else {
                if (count >= 0) continue;
                displayText = "- " + itemName + " x" + Math.abs(count);
                color = -43691;
            }
            if (ConfigManager.config.tickregistryPickupNotifierLocation == NotchArrowUtilsConfig.PickupNotifierLocation.TOP_RIGHT || ConfigManager.config.tickregistryPickupNotifierLocation == NotchArrowUtilsConfig.PickupNotifierLocation.BOTTOM_RIGHT) {
                int textWidth = textRenderer.method_1727(displayText);
                x = client.method_22683().method_4486() - textWidth - 10;
            } else {
                x = 10;
            }
            context.method_51433(client.field_1772, displayText, x, y, color, true);
            y += yIncrement;
        }
    }
}

