/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.client.impl.jefb;

import com.tttsaurus.fluidintetweaker.Configuration;
import com.tttsaurus.fluidintetweaker.FluidInteractionTweaker;
import com.tttsaurus.fluidintetweaker.client.impl.jefb.JEFBCategory;
import com.tttsaurus.fluidintetweaker.client.impl.jefb.JEFBRecipeWrapper;
import com.tttsaurus.fluidintetweaker.common.core.WorldIngredient;
import com.tttsaurus.fluidintetweaker.common.core.behavior.BehaviorEvent;
import com.tttsaurus.fluidintetweaker.common.core.behavior.ComplexOutput;
import com.tttsaurus.fluidintetweaker.common.core.behavior.FluidBehaviorRecipe;
import java.util.LinkedHashMap;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@JEIPlugin
public class JEFBPlugin
implements IModPlugin {
    private static final LinkedHashMap<String, JEFBRecipeWrapper> recipeWrapperDict = new LinkedHashMap();

    public static void addRecipeWrapper(WorldIngredient ingredient, ComplexOutput complexOutput) {
        JEFBPlugin.addRecipeWrapper(ingredient, false, complexOutput);
    }

    public static void addRecipeWrapper(WorldIngredient ingredient, boolean isAnyFluidState, ComplexOutput complexOutput) {
        JEFBRecipeWrapper recipeWrapper = new JEFBRecipeWrapper(new FluidBehaviorRecipe(ingredient, complexOutput));
        recipeWrapper.isAnyFluidState = isAnyFluidState;
        String key = ingredient.toString();
        if (recipeWrapperDict.containsKey(key)) {
            key = key + recipeWrapper.hashCode();
        }
        recipeWrapperDict.put(key, recipeWrapper);
    }

    public static void addRecipeWrapper(FluidBehaviorRecipe recipe) {
        String recipeKey = recipe.ingredient.toString();
        JEFBRecipeWrapper recipeWrapper = new JEFBRecipeWrapper(recipe);
        recipeWrapperDict.put(recipeKey, recipeWrapper);
        recipe.ingredient.setIsFluidSource(!recipe.ingredient.getIsFluidSource());
        String newKey = recipe.ingredient.toString();
        if (recipeWrapperDict.containsKey(newKey) && JEFBPlugin.recipeWrapperDict.get((Object)newKey).recipe.complexOutput.equals(recipe.complexOutput)) {
            recipeWrapperDict.remove(newKey);
            recipeWrapper.isAnyFluidState = true;
        }
        recipe.ingredient.setIsFluidSource(!recipe.ingredient.getIsFluidSource());
    }

    public void register(@NotNull IModRegistry registry) {
        if (Configuration.enableThermalFoundationJEICompat && FluidInteractionTweaker.IS_THERMALFOUNDATION_LOADED) {
            WorldIngredient FLOWING_MANA = new WorldIngredient(FluidRegistry.getFluid((String)"mana"), false);
            JEFBPlugin.addRecipeWrapper(FLOWING_MANA, true, ComplexOutput.create().addEvent(BehaviorEvent.createTeleportEvent(8, 8)).addEvent(BehaviorEvent.createSetFireEvent()).addEvent(BehaviorEvent.createSetSnowEvent()));
            WorldIngredient FLOWING_PYROTHEUM = new WorldIngredient(FluidRegistry.getFluid((String)"pyrotheum"), false);
            JEFBPlugin.addRecipeWrapper(FLOWING_PYROTHEUM, true, ComplexOutput.create().addEvent(BehaviorEvent.createSetFireEvent()));
            WorldIngredient FLOWING_CRYOTHEUM = new WorldIngredient(FluidRegistry.getFluid((String)"cryotheum"), false);
            JEFBPlugin.addRecipeWrapper(FLOWING_CRYOTHEUM, true, ComplexOutput.create().addEvent(BehaviorEvent.createSetSnowEvent()).addEvent(BehaviorEvent.createExtinguishFireEvent()).addEvent(BehaviorEvent.createEntityConversionEvent("minecraft:zombie", "minecraft:snowman")).addEvent(BehaviorEvent.createEntityConversionEvent("minecraft:creeper", "minecraft:snowman")));
            WorldIngredient FLOWING_PETROTHEUM = new WorldIngredient(FluidRegistry.getFluid((String)"petrotheum"), false);
            JEFBPlugin.addRecipeWrapper(FLOWING_PETROTHEUM, true, ComplexOutput.create().addEvent(BehaviorEvent.createPotionEffectEvent("haste", 120, 0)));
        }
        registry.addRecipes(recipeWrapperDict.values(), "fluidintetweaker.jefb");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new JEFBCategory(registry.getJeiHelpers().getGuiHelper())});
    }
}

