/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.client.impl.jefb;

import com.tttsaurus.fluidintetweaker.client.impl.jefb.OnTooltipEventHandler;
import com.tttsaurus.fluidintetweaker.common.core.behavior.BehaviorEvent;
import com.tttsaurus.fluidintetweaker.common.core.behavior.BehaviorEventType;
import com.tttsaurus.fluidintetweaker.common.core.behavior.FluidBehaviorRecipe;
import com.tttsaurus.fluidintetweaker.common.core.behavior.condition.IEventCondition;
import com.tttsaurus.fluidintetweaker.common.core.util.BlockUtils;
import com.tttsaurus.fluidintetweaker.common.core.util.RomanNumberUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class JEFBRecipeWrapper
implements IRecipeWrapper {
    protected FluidBehaviorRecipe recipe;
    protected boolean isAnyFluidState = false;

    public JEFBRecipeWrapper(FluidBehaviorRecipe recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack(this.recipe.ingredient.getFluid(), 1000));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)new FluidStack(this.recipe.ingredient.getFluid(), 1000));
        ArrayList<List<Object>> itemOutputs = new ArrayList<List<Object>>();
        for (BehaviorEvent event : this.recipe.complexOutput.getEvents()) {
            ItemStack itemStack;
            BehaviorEventType eventType = event.getEventType();
            if (eventType == BehaviorEventType.PotionEffect) {
                int amplifier = event.getPotionEffect().func_76458_c() + 1;
                float duration = (float)event.getPotionEffect().func_76459_b() / 20.0f;
                String amplifierNotation = RomanNumberUtils.toRomanNotation(amplifier);
                itemStack = new ItemStack((Item)Items.field_151068_bn);
                itemStack.func_151001_c(I18n.func_135052_a((String)"fluidintetweaker.jefb.behavior.potion_effect", (Object[])new Object[0]) + " " + TextFormatting.DARK_AQUA + I18n.func_135052_a((String)event.getPotionEffect().func_188419_a().func_76393_a(), (Object[])new Object[0]) + " (" + amplifierNotation + ") " + TextFormatting.RESET + duration + "s" + TextFormatting.RESET);
                itemOutputs.add(Collections.singletonList(itemStack));
                continue;
            }
            if (eventType == BehaviorEventType.EntityConversion) {
                String i18nKey1 = "entity." + EntityList.func_191302_a((ResourceLocation)event.getEntityEntryFrom().getRegistryName()) + ".name";
                String i18nKey2 = "entity." + EntityList.func_191302_a((ResourceLocation)event.getEntityEntryTo().getRegistryName()) + ".name";
                ItemStack egg1 = new ItemStack(Items.field_151063_bx);
                NBTTagCompound nbt1 = new NBTTagCompound();
                nbt1.func_74778_a("id", event.getEntityEntryFrom().getRegistryName().toString());
                NBTTagCompound nbt2 = new NBTTagCompound();
                nbt2.func_74782_a("EntityTag", (NBTBase)nbt1);
                egg1.func_77982_d(nbt2);
                egg1.func_151001_c(I18n.func_135052_a((String)"fluidintetweaker.jefb.behavior.entity_conversion_0", (Object[])new Object[0]) + " " + TextFormatting.DARK_AQUA + I18n.func_135052_a((String)i18nKey1, (Object[])new Object[0]) + TextFormatting.RESET);
                ItemStack egg2 = new ItemStack(Items.field_151063_bx);
                nbt1 = new NBTTagCompound();
                nbt1.func_74778_a("id", event.getEntityEntryTo().getRegistryName().toString());
                nbt2 = new NBTTagCompound();
                nbt2.func_74782_a("EntityTag", (NBTBase)nbt1);
                egg2.func_77982_d(nbt2);
                egg2.func_151001_c(I18n.func_135052_a((String)"fluidintetweaker.jefb.behavior.entity_conversion_1", (Object[])new Object[0]) + " " + TextFormatting.DARK_AQUA + I18n.func_135052_a((String)i18nKey2, (Object[])new Object[0]) + TextFormatting.RESET);
                itemOutputs.add(Collections.singletonList(egg1));
                itemOutputs.add(Collections.singletonList(egg2));
                continue;
            }
            if (eventType == BehaviorEventType.ExtinguishFire) {
                ItemStack itemStack2 = new ItemStack(Items.field_151126_ay);
                itemStack2.func_151001_c(I18n.func_135052_a((String)"fluidintetweaker.jefb.behavior.extinguish_fire", (Object[])new Object[0]));
                itemOutputs.add(Collections.singletonList(itemStack2));
                continue;
            }
            if (eventType == BehaviorEventType.SetFire) {
                ItemStack itemStack3 = new ItemStack(Items.field_151033_d);
                itemStack3.func_151001_c(I18n.func_135052_a((String)"fluidintetweaker.jefb.behavior.set_fire", (Object[])new Object[0]));
                itemOutputs.add(Collections.singletonList(itemStack3));
                continue;
            }
            if (eventType == BehaviorEventType.SetSnow) {
                ItemStack itemStack4 = BlockUtils.getItemStack(Blocks.field_150431_aC.func_176223_P());
                itemStack4.func_151001_c(I18n.func_135052_a((String)"fluidintetweaker.jefb.behavior.set_snow", (Object[])new Object[0]));
                itemOutputs.add(Collections.singletonList(itemStack4));
                continue;
            }
            if (eventType == BehaviorEventType.Teleport) {
                ItemStack itemStack5 = new ItemStack(Items.field_151079_bi);
                itemStack5.func_151001_c(I18n.func_135052_a((String)"fluidintetweaker.jefb.behavior.teleport", (Object[])new Object[0]));
                itemOutputs.add(Collections.singletonList(itemStack5));
                continue;
            }
            if (eventType != BehaviorEventType.BreakSurrounding) continue;
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            for (IBlockState blockState : event.getBlockStates()) {
                itemStack = BlockUtils.getItemStack(blockState);
                itemStack.func_151001_c(I18n.func_135052_a((String)"fluidintetweaker.jefb.behavior.break", (Object[])new Object[0]) + " " + TextFormatting.DARK_AQUA + itemStack.func_82833_r() + TextFormatting.RESET);
                itemStacks.add(itemStack);
            }
            itemOutputs.add(itemStacks);
        }
        ingredients.setOutputLists(VanillaTypes.ITEM, itemOutputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int length;
        if (!this.isAnyFluidState) {
            minecraft.field_71466_p.func_78276_b(this.recipe.ingredient.getIsFluidSource() ? I18n.func_135052_a((String)"fluidintetweaker.fluid_source", (Object[])new Object[0]) : I18n.func_135052_a((String)"fluidintetweaker.fluid_flowing", (Object[])new Object[0]), 7, 33, Color.GRAY.getRGB());
        }
        if (mouseX >= 98 - (length = this.recipe.complexOutput.getEvents().size()) * 9 && mouseX <= 98 + length * 9) {
            ArrayList<String> tooltip = new ArrayList<String>();
            int hoverIndex = (mouseX - 98 + length * 9) / 18;
            hoverIndex = hoverIndex >= length ? length - 1 : hoverIndex;
            BehaviorEvent behaviorEvent = this.recipe.complexOutput.getEvents().get(hoverIndex);
            if (behaviorEvent.getEventType() == BehaviorEventType.EntityConversion && (mouseY < 5 || mouseY > 40)) {
                return;
            }
            if (behaviorEvent.getEventType() != BehaviorEventType.EntityConversion && (mouseY < 14 || mouseY > 31)) {
                return;
            }
            for (IEventCondition condition : behaviorEvent.getConditions()) {
                String desc = condition.getDesc(this.recipe);
                if (desc == null) continue;
                String[] lines = desc.split("<br>");
                tooltip.addAll(Arrays.asList(lines));
            }
            if (!tooltip.isEmpty()) {
                tooltip.add(0, I18n.func_135052_a((String)"fluidintetweaker.condition_tips", (Object[])new Object[0]));
            }
            if (!tooltip.isEmpty()) {
                OnTooltipEventHandler.addExtraTooltip(tooltip);
            }
        }
    }
}

