/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.client.impl.jefi;

import com.tttsaurus.fluidintetweaker.Configuration;
import com.tttsaurus.fluidintetweaker.FluidInteractionTweaker;
import com.tttsaurus.fluidintetweaker.client.impl.jefi.JEFICategory;
import com.tttsaurus.fluidintetweaker.client.impl.jefi.JEFIRecipeWrapper;
import com.tttsaurus.fluidintetweaker.common.core.WorldIngredient;
import com.tttsaurus.fluidintetweaker.common.core.WorldIngredientType;
import com.tttsaurus.fluidintetweaker.common.core.interaction.ComplexOutput;
import com.tttsaurus.fluidintetweaker.common.core.interaction.FluidInteractionRecipe;
import com.tttsaurus.fluidintetweaker.common.core.interaction.InteractionEvent;
import com.tttsaurus.fluidintetweaker.common.core.interaction.StringRecipeProtocol;
import com.tttsaurus.fluidintetweaker.common.core.util.BlockUtils;
import com.tttsaurus.fluidintetweaker.common.impl.interaction.condition.IsInitiatorAbove;
import com.tttsaurus.ometweaks.OMEConfig;
import com.tttsaurus.ometweaks.integration.thermalfoundation.ThermalFoundationModule;
import java.util.LinkedHashMap;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.init.Blocks;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@JEIPlugin
public class JEFIPlugin
implements IModPlugin {
    private static final LinkedHashMap<String, JEFIRecipeWrapper> recipeWrapperDict = new LinkedHashMap();

    public static void addRecipeWrapper(WorldIngredient ingredientA, boolean isAnyFluidStateA, WorldIngredient ingredientB, ComplexOutput complexOutput) {
        JEFIPlugin.addRecipeWrapper(ingredientA, isAnyFluidStateA, ingredientB, complexOutput, null);
    }

    public static void addRecipeWrapper(WorldIngredient ingredientA, boolean isAnyFluidStateA, WorldIngredient ingredientB, ComplexOutput complexOutput, String extraInfoLocalizationKey) {
        JEFIPlugin.addRecipeWrapper(ingredientA, isAnyFluidStateA, ingredientB, false, complexOutput, extraInfoLocalizationKey);
    }

    public static void addRecipeWrapper(WorldIngredient ingredientA, WorldIngredient ingredientB, boolean isAnyFluidStateB, ComplexOutput complexOutput) {
        JEFIPlugin.addRecipeWrapper(ingredientA, ingredientB, isAnyFluidStateB, complexOutput, null);
    }

    public static void addRecipeWrapper(WorldIngredient ingredientA, WorldIngredient ingredientB, boolean isAnyFluidStateB, ComplexOutput complexOutput, String extraInfoLocalizationKey) {
        JEFIPlugin.addRecipeWrapper(ingredientA, false, ingredientB, isAnyFluidStateB, complexOutput, extraInfoLocalizationKey);
    }

    public static void addRecipeWrapper(WorldIngredient ingredientA, boolean isAnyFluidStateA, WorldIngredient ingredientB, boolean isAnyFluidStateB, ComplexOutput complexOutput) {
        JEFIPlugin.addRecipeWrapper(ingredientA, isAnyFluidStateA, ingredientB, isAnyFluidStateB, complexOutput, null);
    }

    public static void addRecipeWrapper(WorldIngredient ingredientA, boolean isAnyFluidStateA, WorldIngredient ingredientB, boolean isAnyFluidStateB, ComplexOutput complexOutput, String extraInfoLocalizationKey) {
        JEFIRecipeWrapper recipeWrapper = new JEFIRecipeWrapper(new FluidInteractionRecipe(ingredientA, ingredientB, complexOutput, extraInfoLocalizationKey));
        recipeWrapper.isAnyFluidStateA = isAnyFluidStateA;
        recipeWrapper.isAnyFluidStateB = isAnyFluidStateB;
        String key = StringRecipeProtocol.getRecipeKeyFromTwoIngredients(ingredientA, ingredientB);
        if (recipeWrapperDict.containsKey(key)) {
            key = key + recipeWrapper.hashCode();
        }
        recipeWrapperDict.put(key, recipeWrapper);
    }

    public static void addRecipeWrapper(FluidInteractionRecipe recipe) {
        String newKey;
        String recipeKey = StringRecipeProtocol.getRecipeKeyFromTwoIngredients(recipe.ingredientA, recipe.ingredientB);
        JEFIRecipeWrapper recipeWrapper = new JEFIRecipeWrapper(recipe);
        recipeWrapperDict.put(recipeKey, recipeWrapper);
        if (recipe.ingredientA.getIngredientType() == WorldIngredientType.FLUID) {
            recipe.ingredientA.setIsFluidSource(!recipe.ingredientA.getIsFluidSource());
            newKey = StringRecipeProtocol.getRecipeKeyFromTwoIngredients(recipe.ingredientA, recipe.ingredientB);
            if (recipeWrapperDict.containsKey(newKey) && JEFIPlugin.recipeWrapperDict.get((Object)newKey).recipe.complexOutput.equals(recipe.complexOutput)) {
                recipeWrapperDict.remove(newKey);
                recipeWrapper.isAnyFluidStateA = true;
            }
            recipe.ingredientA.setIsFluidSource(!recipe.ingredientA.getIsFluidSource());
        }
        if (recipe.ingredientB.getIngredientType() == WorldIngredientType.FLUID) {
            recipe.ingredientB.setIsFluidSource(!recipe.ingredientB.getIsFluidSource());
            newKey = StringRecipeProtocol.getRecipeKeyFromTwoIngredients(recipe.ingredientA, recipe.ingredientB);
            if (recipeWrapperDict.containsKey(newKey) && JEFIPlugin.recipeWrapperDict.get((Object)newKey).recipe.complexOutput.equals(recipe.complexOutput)) {
                recipeWrapperDict.remove(newKey);
                recipeWrapper.isAnyFluidStateB = true;
            }
            recipe.ingredientB.setIsFluidSource(!recipe.ingredientB.getIsFluidSource());
        }
    }

    public void register(@NotNull IModRegistry registry) {
        if (Configuration.enableLavaAndWaterRecipeInJEI) {
            JEFIPlugin.addRecipeWrapper(WorldIngredient.SOURCE_LAVA, WorldIngredient.FLOWING_WATER, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150343_Z.func_176223_P()));
            JEFIPlugin.addRecipeWrapper(WorldIngredient.FLOWING_LAVA, WorldIngredient.FLOWING_WATER, true, ComplexOutput.create().addEvent(InteractionEvent.createSetBlockEvent(Blocks.field_150347_e.func_176223_P())).addEvent(InteractionEvent.createSetBlockEvent(Blocks.field_150348_b.func_176223_P()).addCondition(new IsInitiatorAbove())));
        }
        if (Configuration.enableThermalFoundationJEICompat && FluidInteractionTweaker.IS_THERMALFOUNDATION_LOADED) {
            boolean enableMana = true;
            boolean enablePyrotheum = true;
            boolean enableCryotheum = true;
            boolean enablePetrotheum = true;
            if (FluidInteractionTweaker.IS_OMETWEAKS_LOADED && OMEConfig.ENABLE && ThermalFoundationModule.ENABLE_TF_MODULE) {
                if (ThermalFoundationModule.DISABLE_TF_MANA_INTERACTIONS) {
                    enableMana = false;
                }
                if (ThermalFoundationModule.DISABLE_TF_PYROTHEUM_INTERACTIONS) {
                    enablePyrotheum = false;
                }
                if (ThermalFoundationModule.DISABLE_TF_CRYOTHEUM_INTERACTIONS) {
                    enableCryotheum = false;
                }
                if (ThermalFoundationModule.DISABLE_TF_PETROTHEUM_INTERACTIONS) {
                    enablePetrotheum = false;
                }
            }
            if (enableMana) {
                WorldIngredient FLOWING_MANA = new WorldIngredient(FluidRegistry.getFluid((String)"mana"), false);
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150346_d.func_176223_P()), FLOWING_MANA, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_185774_da.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150346_d.func_176203_a(1)), FLOWING_MANA, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_185774_da.func_176203_a(1)));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150458_ak.func_176223_P()), FLOWING_MANA, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150391_bh.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150359_w.func_176223_P()), FLOWING_MANA, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150354_m.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150369_x.func_176223_P()), FLOWING_MANA, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150368_y.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(BlockUtils.getBlockState("thermalfoundation:ore", 2)), FLOWING_MANA, true, ComplexOutput.createSimpleBlockOutput(BlockUtils.getBlockState("thermalfoundation:ore", 8)));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(BlockUtils.getBlockState("thermalfoundation:ore", 3)), FLOWING_MANA, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150352_o.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(BlockUtils.getBlockState("thermalfoundation:storage", 2)), FLOWING_MANA, true, ComplexOutput.createSimpleBlockOutput(BlockUtils.getBlockState("thermalfoundation:storage", 8)));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(BlockUtils.getBlockState("thermalfoundation:storage", 3)), FLOWING_MANA, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150340_R.func_176223_P()));
            }
            if (enablePyrotheum) {
                WorldIngredient FLOWING_PYROTHEUM = new WorldIngredient(FluidRegistry.getFluid((String)"pyrotheum"), false);
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150347_e.func_176223_P()), FLOWING_PYROTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150348_b.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150349_c.func_176223_P()), FLOWING_PYROTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150346_d.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150354_m.func_176223_P()), FLOWING_PYROTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150359_w.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(WorldIngredient.FLOWING_WATER, true, FLOWING_PYROTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150348_b.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150432_aD.func_176223_P()), FLOWING_PYROTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150348_b.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150435_aG.func_176223_P()), FLOWING_PYROTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150405_ch.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150433_aE.func_176223_P()), FLOWING_PYROTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150350_a.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150431_aC.func_176223_P()), FLOWING_PYROTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150350_a.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150446_ar.func_176203_a(0)), FLOWING_PYROTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150390_bg.func_176203_a(0)));
            }
            if (enableCryotheum) {
                WorldIngredient FLOWING_CRYOTHEUM = new WorldIngredient(FluidRegistry.getFluid((String)"cryotheum"), false);
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150349_c.func_176223_P()), FLOWING_CRYOTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150346_d.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(WorldIngredient.SOURCE_WATER, FLOWING_CRYOTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150432_aD.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(WorldIngredient.FLOWING_WATER, FLOWING_CRYOTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150433_aE.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(WorldIngredient.SOURCE_LAVA, FLOWING_CRYOTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150343_Z.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(WorldIngredient.FLOWING_LAVA, FLOWING_CRYOTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150348_b.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(FluidRegistry.getFluid((String)"glowstone"), true), FLOWING_CRYOTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150426_aN.func_176223_P()));
            }
            if (enablePetrotheum) {
                WorldIngredient FLOWING_PETROTHEUM = new WorldIngredient(FluidRegistry.getFluid((String)"petrotheum"), false);
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150348_b.func_176223_P()), FLOWING_PETROTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150351_n.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150347_e.func_176223_P()), FLOWING_PETROTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150351_n.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150417_aV.func_176223_P()), FLOWING_PETROTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150351_n.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150417_aV.func_176203_a(1)), FLOWING_PETROTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150351_n.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150417_aV.func_176203_a(2)), FLOWING_PETROTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150351_n.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150417_aV.func_176203_a(3)), FLOWING_PETROTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150351_n.func_176223_P()));
                JEFIPlugin.addRecipeWrapper(new WorldIngredient(Blocks.field_150341_Y.func_176223_P()), FLOWING_PETROTHEUM, true, ComplexOutput.createSimpleBlockOutput(Blocks.field_150351_n.func_176223_P()));
            }
        }
        if (!Configuration.enableBiomesOPlentyJEICompat || FluidInteractionTweaker.IS_BIOMESOPLENTY_LOADED) {
            // empty if block
        }
        registry.addRecipes(recipeWrapperDict.values(), "fluidintetweaker.jefi");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new JEFICategory(registry.getJeiHelpers().getGuiHelper())});
    }
}

