/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.client.impl.jefi;

import com.tttsaurus.fluidintetweaker.client.impl.EntityRenderer;
import com.tttsaurus.fluidintetweaker.client.impl.jefi.OnTooltipEventHandler;
import com.tttsaurus.fluidintetweaker.common.core.WorldIngredientType;
import com.tttsaurus.fluidintetweaker.common.core.interaction.FluidInteractionRecipe;
import com.tttsaurus.fluidintetweaker.common.core.interaction.InteractionEvent;
import com.tttsaurus.fluidintetweaker.common.core.interaction.InteractionEventType;
import com.tttsaurus.fluidintetweaker.common.core.interaction.condition.IEventCondition;
import com.tttsaurus.fluidintetweaker.common.core.util.BlockUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class JEFIRecipeWrapper
implements IRecipeWrapper {
    protected FluidInteractionRecipe recipe;
    protected boolean isAnyFluidStateA = false;
    protected boolean isAnyFluidStateB = false;
    private EntityRenderer entityRenderer = null;

    public JEFIRecipeWrapper(FluidInteractionRecipe recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        if (this.recipe.ingredientA.getIngredientType() == WorldIngredientType.FLUID && this.recipe.ingredientB.getIngredientType() == WorldIngredientType.FLUID) {
            ingredients.setInputs(VanillaTypes.FLUID, Arrays.asList(new FluidStack(this.recipe.ingredientA.getFluid(), 1000), new FluidStack(this.recipe.ingredientB.getFluid(), 1000)));
        } else if (this.recipe.ingredientA.getIngredientType() == WorldIngredientType.FLUID && this.recipe.ingredientB.getIngredientType() == WorldIngredientType.BLOCK) {
            ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack(this.recipe.ingredientA.getFluid(), 1000));
            ingredients.setInput(VanillaTypes.ITEM, (Object)BlockUtils.getItemStack(this.recipe.ingredientB.getBlockState()));
        } else if (this.recipe.ingredientA.getIngredientType() == WorldIngredientType.BLOCK && this.recipe.ingredientB.getIngredientType() == WorldIngredientType.FLUID) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)BlockUtils.getItemStack(this.recipe.ingredientA.getBlockState()));
            ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack(this.recipe.ingredientB.getFluid(), 1000));
        }
        ArrayList<ItemStack> itemOutputs = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
        for (InteractionEvent event : this.recipe.complexOutput.getEvents()) {
            InteractionEventType eventType = event.getEventType();
            if (eventType == InteractionEventType.SetBlock) {
                itemOutputs.add(BlockUtils.getItemStack(event.getBlockState()));
                continue;
            }
            if (eventType == InteractionEventType.Explosion) {
                ItemStack tnt = new ItemStack(Items.field_151142_bV);
                tnt.func_151001_c(I18n.func_135052_a((String)"fluidintetweaker.jefi.interaction.explosion", (Object[])new Object[0]));
                itemOutputs.add(tnt);
                continue;
            }
            if (eventType == InteractionEventType.SpawnEntity) {
                String i18nKey = "entity." + EntityList.func_191302_a((ResourceLocation)event.getEntityEntry().getRegistryName()) + ".name";
                ItemStack egg = new ItemStack(Items.field_151063_bx);
                NBTTagCompound nbt1 = new NBTTagCompound();
                nbt1.func_74778_a("id", event.getEntityEntry().getName());
                NBTTagCompound nbt2 = new NBTTagCompound();
                nbt2.func_74782_a("EntityTag", (NBTBase)nbt1);
                egg.func_77982_d(nbt2);
                egg.func_151001_c(I18n.func_135052_a((String)"fluidintetweaker.jefi.interaction.spawn_entity", (Object[])new Object[0]) + " " + TextFormatting.DARK_AQUA + I18n.func_135052_a((String)i18nKey, (Object[])new Object[0]) + TextFormatting.RESET);
                itemOutputs.add(egg);
                continue;
            }
            if (eventType == InteractionEventType.SpawnEntityItem) {
                ItemStack itemStack = event.getItemStack().func_77946_l();
                itemStack.func_151001_c(I18n.func_135052_a((String)"fluidintetweaker.jefi.interaction.spawn_entity_item", (Object[])new Object[0]) + " " + TextFormatting.DARK_AQUA + itemStack.func_82833_r() + TextFormatting.RESET);
                itemOutputs.add(itemStack);
                continue;
            }
            if (eventType != InteractionEventType.SetFluid) continue;
            fluidOutputs.add(new FluidStack(event.getFluid(), 1000));
        }
        ingredients.setOutputs(VanillaTypes.ITEM, itemOutputs);
        ingredients.setOutputs(VanillaTypes.FLUID, fluidOutputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int length;
        if (this.recipe.ingredientA.getIngredientType() == WorldIngredientType.FLUID && !this.isAnyFluidStateA) {
            minecraft.field_71466_p.func_78276_b(this.recipe.ingredientA.getIsFluidSource() ? I18n.func_135052_a((String)"fluidintetweaker.fluid_source", (Object[])new Object[0]) : I18n.func_135052_a((String)"fluidintetweaker.fluid_flowing", (Object[])new Object[0]), 7, 35, Color.GRAY.getRGB());
        }
        if (this.recipe.ingredientB.getIngredientType() == WorldIngredientType.FLUID && !this.isAnyFluidStateB) {
            minecraft.field_71466_p.func_78276_b(this.recipe.ingredientB.getIsFluidSource() ? I18n.func_135052_a((String)"fluidintetweaker.fluid_source", (Object[])new Object[0]) : I18n.func_135052_a((String)"fluidintetweaker.fluid_flowing", (Object[])new Object[0]), 47, 35, Color.GRAY.getRGB());
        }
        if (mouseX >= 116 - (length = this.recipe.complexOutput.getEvents().size()) * 9 && mouseX <= 116 + length * 9 && mouseY >= 14 && mouseY <= 31) {
            ArrayList<String> tooltip = new ArrayList<String>();
            int hoverIndex = (mouseX - 116 + length * 9) / 18;
            hoverIndex = hoverIndex >= length ? length - 1 : hoverIndex;
            InteractionEvent interactionEvent = this.recipe.complexOutput.getEvents().get(hoverIndex);
            if (interactionEvent.getEventType() == InteractionEventType.SpawnEntity) {
                float x = 116 - length * 9 + hoverIndex * 18 + 9;
                float y = 13.0f;
                if (this.entityRenderer == null) {
                    this.entityRenderer = new EntityRenderer(minecraft, interactionEvent.getEntityEntry());
                }
                float dist = 9.0f;
                double angle = Math.atan(((float)mouseX - x) / dist) / (double)6.28318f * 360.0;
                this.entityRenderer.render(x, y, 0.0f, (float)angle, 0.0f);
            }
            for (IEventCondition condition : interactionEvent.getConditions()) {
                String desc = condition.getDesc(this.recipe);
                if (desc == null) continue;
                String[] lines = desc.split("<br>");
                tooltip.addAll(Arrays.asList(lines));
            }
            if (!tooltip.isEmpty()) {
                tooltip.add(0, I18n.func_135052_a((String)"fluidintetweaker.condition_tips", (Object[])new Object[0]));
            }
            if (this.recipe.extraInfoLocalizationKey != null && !this.recipe.extraInfoLocalizationKey.isEmpty()) {
                String text = I18n.func_135052_a((String)this.recipe.extraInfoLocalizationKey, (Object[])new Object[0]);
                String[] lines = text.split("<br>");
                tooltip.addAll(Arrays.asList(lines));
            }
            if (!tooltip.isEmpty()) {
                OnTooltipEventHandler.addExtraTooltip(tooltip);
            }
        }
    }
}

