/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.common.core;

import com.tttsaurus.fluidintetweaker.common.core.WorldIngredientType;
import com.tttsaurus.fluidintetweaker.common.core.util.BlockUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class WorldIngredient {
    public static final String KEYWORD_BLOCK = "BLOCK";
    public static final String KEYWORD_FLUID_SOURCE = "FLUID_SOURCE";
    public static final String KEYWORD_FLUID_FLOWING = "FLUID_FLOWING";
    public static final WorldIngredient AIR = new WorldIngredient(Blocks.field_150350_a.func_176223_P());
    public static final WorldIngredient SOURCE_WATER = new WorldIngredient(FluidRegistry.WATER, true);
    public static final WorldIngredient FLOWING_WATER = new WorldIngredient(FluidRegistry.WATER, false);
    public static final WorldIngredient SOURCE_LAVA = new WorldIngredient(FluidRegistry.LAVA, true);
    public static final WorldIngredient FLOWING_LAVA = new WorldIngredient(FluidRegistry.LAVA, false);
    private WorldIngredientType ingredientType;
    private Fluid fluid;
    private boolean isFluidSource;
    private IBlockState blockState;

    public WorldIngredientType getIngredientType() {
        return this.ingredientType;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public boolean getIsFluidSource() {
        return this.isFluidSource;
    }

    public IBlockState getBlockState() {
        return this.blockState;
    }

    public void setIsFluidSource(boolean isFluidSource) {
        this.isFluidSource = isFluidSource;
    }

    public String toString() {
        if (this.ingredientType == WorldIngredientType.BLOCK && this.blockState != null) {
            return "BLOCK{" + BlockUtils.toString(this.blockState) + "}";
        }
        if (this.ingredientType == WorldIngredientType.FLUID && this.fluid != null) {
            if (this.isFluidSource) {
                return "FLUID_SOURCE{" + this.fluid.getName() + "}";
            }
            return "FLUID_FLOWING{" + this.fluid.getName() + "}";
        }
        return "";
    }

    public boolean equals(Object object) {
        return object instanceof WorldIngredient && object.toString().equals(this.toString());
    }

    public WorldIngredient(@Nonnull Fluid fluid, boolean isFluidSource) {
        this.ingredientType = WorldIngredientType.FLUID;
        this.fluid = fluid;
        this.isFluidSource = isFluidSource;
        this.blockState = null;
    }

    public WorldIngredient(@Nonnull IBlockState blockState) {
        this.ingredientType = WorldIngredientType.BLOCK;
        this.fluid = null;
        this.isFluidSource = false;
        this.blockState = blockState;
    }

    private WorldIngredient() {
    }

    public static WorldIngredient getFrom(@Nonnull IBlockState blockState) {
        Block block = blockState.func_177230_c();
        ResourceLocation rl = block.getRegistryName();
        if (rl == null) {
            return AIR;
        }
        String registryName = rl.toString();
        if (registryName.equals("minecraft:air")) {
            return AIR;
        }
        WorldIngredient ingredient = new WorldIngredient();
        ingredient.blockState = blockState;
        if (block instanceof BlockLiquid) {
            ingredient.ingredientType = WorldIngredientType.FLUID;
            if (registryName.equals("minecraft:water") || registryName.equals("minecraft:flowing_water")) {
                ingredient.fluid = FluidRegistry.WATER;
            } else if (registryName.equals("minecraft:lava") || registryName.equals("minecraft:flowing_lava")) {
                ingredient.fluid = FluidRegistry.LAVA;
            }
            ingredient.isFluidSource = (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
        } else if (block instanceof BlockFluidBase) {
            BlockFluidBase fluidBase = (BlockFluidBase)block;
            ingredient.ingredientType = WorldIngredientType.FLUID;
            ingredient.fluid = fluidBase.getFluid();
            ingredient.isFluidSource = (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
        } else {
            ingredient.ingredientType = WorldIngredientType.BLOCK;
        }
        return ingredient;
    }

    public static WorldIngredient getFrom(@Nonnull World world, @Nonnull BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        return WorldIngredient.getFrom(blockState);
    }
}

